/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.android.tools.idea.gradle.model.java.GradleModuleVersionImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarLibraryDependency
implements Serializable {
    private static final long serialVersionUID = 2L;
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    @NotNull
    private final String myName;
    @Nullable
    private final File myBinaryPath;
    @Nullable
    private final File mySourcePath;
    @Nullable
    private final File myJavadocPath;
    @Nullable
    private final String myScope;
    @Nullable
    private final GradleModuleVersion myModuleVersion;
    private final boolean myResolved;

    @NotNull
    public static String getDependencyName(@NotNull File binaryPath, boolean resolved) {
        if (resolved) {
            return binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
        }
        return binaryPath.getName().substring(UNRESOLVED_DEPENDENCY_PREFIX.length()).replace(' ', ':');
    }

    public static boolean isResolved(@NotNull String libraryName) {
        return !libraryName.startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
    }

    @PropertyMapping(value={"myName", "myBinaryPath", "mySourcePath", "myJavadocPath", "myScope", "myModuleVersion", "myResolved"})
    public JarLibraryDependency(@NotNull String name, @Nullable File binaryPath, @Nullable File sourcePath, @Nullable File javadocPath, @Nullable String scope2, @Nullable GradleModuleVersion moduleVersion, boolean resolved) {
        this.myName = name;
        this.myBinaryPath = binaryPath;
        this.mySourcePath = sourcePath;
        this.myJavadocPath = javadocPath;
        this.myScope = scope2;
        this.myModuleVersion = moduleVersion != null ? new GradleModuleVersionImpl(moduleVersion) : null;
        this.myResolved = resolved;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public File getBinaryPath() {
        return this.myBinaryPath;
    }

    @Nullable
    public File getSourcePath() {
        return this.mySourcePath;
    }

    @Nullable
    public File getJavadocPath() {
        return this.myJavadocPath;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    @Nullable
    public GradleModuleVersion getModuleVersion() {
        return this.myModuleVersion;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myBinaryPath, this.mySourcePath, this.myJavadocPath, this.myScope, this.myModuleVersion, this.myResolved);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JarLibraryDependency)) {
            return false;
        }
        JarLibraryDependency dependency = (JarLibraryDependency)obj;
        return Objects.equals(this.myName, dependency.myName) && Objects.equals(this.myBinaryPath, dependency.myBinaryPath) && Objects.equals(this.mySourcePath, dependency.mySourcePath) && Objects.equals(this.myJavadocPath, dependency.myJavadocPath) && Objects.equals(this.myScope, dependency.myScope) && Objects.equals(this.myModuleVersion, dependency.myModuleVersion) && Objects.equals(this.myResolved, dependency.myResolved);
    }
}

