/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.filters;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleExecutionConsoleManager;
import org.jetbrains.plugins.gradle.execution.filters.GradleReRunBuildFilter;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class AndroidGradleExecutionConsoleManager
extends GradleExecutionConsoleManager {
    public boolean isApplicableFor(@NotNull ExternalSystemTask task2) {
        return GradleConstants.SYSTEM_ID.equals((Object)task2.getId().getProjectSystemId()) && task2 instanceof ExternalSystemResolveProjectTask;
    }

    @Nullable
    public ExecutionConsole attachExecutionConsole(@NotNull Project project, @NotNull ExternalSystemTask task2, @Nullable ExecutionEnvironment env, @Nullable ProcessHandler processHandler) {
        if (task2 instanceof ExternalSystemResolveProjectTask) {
            ConsoleView executionConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
            executionConsole.attachToProcess(processHandler);
            executionConsole.addMessageFilter((Filter)new AndroidReRunSyncFilter(((ExternalSystemResolveProjectTask)task2).getExternalProjectPath()));
            return executionConsole;
        }
        return super.attachExecutionConsole(project, task2, env, processHandler);
    }

    static class AndroidReRunSyncFilter
    extends GradleReRunBuildFilter {
        AndroidReRunSyncFilter(@NotNull String projectPath) {
            super(projectPath);
        }

        @NotNull
        protected HyperlinkInfo getHyperLinkInfo(@NotNull List<String> options2) {
            return project -> {
                project.putUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY, (Object)options2.toArray(new String[0]));
                GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_USER_REQUEST_RERUN_WITH_ADDITIONAL_OPTIONS);
            };
        }
    }
}

