/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslUtil;
import com.android.tools.idea.gradle.dsl.parser.semantics.MethodSemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertySemanticsDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SemanticsDescription;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyDslNameConverter
implements GradleDslNameConverter {
    @Override
    @NotNull
    public String psiToName(@NotNull PsiElement element2) {
        StringBuilder sb;
        if (GroovyDslUtil.isStringLiteral(element2) && GroovyDslUtil.decodeStringLiteral(element2, sb = new StringBuilder())) {
            return GradleNameElement.escape(sb.toString());
        }
        return GroovyDslUtil.getGradleNameForPsiElement(element2);
    }

    @Override
    @NotNull
    public String convertReferenceText(@NotNull GradleDslElement context, @NotNull String referenceText) {
        String result2 = (String)ApplicationManager.getApplication().runReadAction(() -> {
            GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)context.getDslFile().getProject());
            GrExpression expression2 = factory2.createExpressionFromText((CharSequence)referenceText);
            return GroovyDslUtil.gradleNameFor(expression2);
        });
        return result2 != null ? result2 : referenceText;
    }

    @Override
    @NotNull
    public String convertReferenceToExternalText(@NotNull GradleDslElement context, @NotNull String referenceText, boolean forInjection) {
        if (context instanceof GradleDslSimpleExpression) {
            return GroovyDslUtil.convertToExternalTextValue((GradleDslSimpleExpression)context, context.getDslFile(), referenceText, forInjection);
        }
        return referenceText;
    }

    @Override
    @NotNull
    public String convertReferenceToExternalText(@NotNull GradleDslElement context, @NotNull GradleDslElement dslElement, boolean forInjection) {
        if (context instanceof GradleDslSimpleExpression) {
            String externalText = GroovyDslUtil.convertToExternalTextValue(dslElement, (GradleDslSimpleExpression)context, context.getDslFile(), forInjection);
            return externalText != null ? externalText : dslElement.getName();
        }
        return dslElement.getName();
    }

    @Override
    @NotNull
    public ExternalNameInfo externalNameForParent(@NotNull String modelName, @NotNull GradleDslElement context) {
        ImmutableMap<Pair<String, Integer>, ModelEffectDescription> map2 = context.getExternalToModelMap(this);
        ExternalNameInfo result2 = new ExternalNameInfo(modelName, null);
        for (Map.Entry e : map2.entrySet()) {
            if (!((ModelEffectDescription)e.getValue()).property.name.equals(modelName)) continue;
            SemanticsDescription semantics = ((ModelEffectDescription)e.getValue()).semantics;
            if (semantics == MethodSemanticsDescription.SET || semantics == MethodSemanticsDescription.ADD_AS_LIST || semantics == MethodSemanticsDescription.OTHER) {
                return new ExternalNameInfo((String)((Pair)e.getKey()).getFirst(), true);
            }
            if (semantics != PropertySemanticsDescription.VAR && semantics != PropertySemanticsDescription.VWO && semantics != PropertySemanticsDescription.VAR_BUT_DO_NOT_USE_FOR_WRITING_IN_KTS) continue;
            result2 = new ExternalNameInfo((String)((Pair)e.getKey()).getFirst(), false);
        }
        return result2;
    }

    @Override
    @Nullable
    public ModelPropertyDescription modelDescriptionForParent(@NotNull String externalName, @NotNull GradleDslElement context) {
        ImmutableMap<Pair<String, Integer>, ModelEffectDescription> map2 = context.getExternalToModelMap(this);
        for (Map.Entry e : map2.entrySet()) {
            if (!((String)((Pair)e.getKey()).getFirst()).equals(externalName)) continue;
            return ((ModelEffectDescription)e.getValue()).property;
        }
        return null;
    }
}

