/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.google.common.base.Charsets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDslFileCache {
    @NotNull
    private Project myProject;
    @NotNull
    private Map<String, GradleDslFile> myParsedBuildFiles = new HashMap<String, GradleDslFile>();
    @NotNull
    private Deque<VirtualFile> myParsingStack = new ArrayDeque<VirtualFile>();

    public GradleDslFileCache(@NotNull Project project) {
        this.myProject = project;
    }

    public void clearAllFiles() {
        this.myParsedBuildFiles.clear();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file2, @NotNull String name, @NotNull BuildModelContext context, boolean isApplied) {
        GradleDslFile dslFile = this.myParsedBuildFiles.get(file2.getUrl());
        if (dslFile == null) {
            if (!this.myParsingStack.contains(file2)) {
                this.myParsingStack.push(file2);
                dslFile = context.parseBuildFile(this.myProject, file2, name, isApplied);
                this.myParsingStack.pop();
                this.myParsedBuildFiles.put(file2.getUrl(), dslFile);
            } else {
                dslFile = new GradleBuildFile(file2, this.myProject, name, context);
                dslFile.notification(NotificationTypeReference.CIRCULAR_APPLICATION);
            }
        } else if (!(dslFile instanceof GradleBuildFile)) {
            throw new IllegalStateException("Found wrong type for build file in cache!");
        }
        return (GradleBuildFile)dslFile;
    }

    public void putBuildFile(@NotNull String name, @NotNull GradleDslFile buildFile) {
        this.myParsedBuildFiles.put(name, buildFile);
    }

    @Nullable
    public VirtualFile getCurrentParsingRoot() {
        return this.myParsingStack.isEmpty() ? null : this.myParsingStack.getLast();
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile, @NotNull BuildModelContext context) {
        GradleDslFile dslFile = this.myParsedBuildFiles.get(settingsFile.getUrl());
        if (dslFile == null) {
            dslFile = new GradleSettingsFile(settingsFile, this.myProject, "settings", context);
            dslFile.parse();
            this.myParsedBuildFiles.put(settingsFile.getUrl(), dslFile);
        } else if (!(dslFile instanceof GradleSettingsFile)) {
            throw new IllegalStateException("Found wrong type for settings file in cache!");
        }
        return (GradleSettingsFile)dslFile;
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file2, @NotNull String moduleName2, @NotNull BuildModelContext context) {
        GradleDslFile dslFile = this.myParsedBuildFiles.get(file2.getUrl());
        if (dslFile == null) {
            try {
                Properties properties2 = GradleDslFileCache.getProperties(file2);
                dslFile = new GradlePropertiesFile(properties2, file2, this.myProject, moduleName2, context);
                this.myParsedBuildFiles.put(file2.getUrl(), dslFile);
            }
            catch (IOException e) {
                Logger.getInstance(GradleDslFileCache.class).warn("Failed to process properties file " + file2.getPath(), (Throwable)e);
                return null;
            }
        } else if (!(dslFile instanceof GradlePropertiesFile)) {
            throw new IllegalStateException("Found wrong type for properties file in cache!");
        }
        return (GradlePropertiesFile)dslFile;
    }

    private static Properties getProperties(@NotNull VirtualFile file2) throws IOException {
        Properties properties2 = new Properties();
        properties2.load(new InputStreamReader(file2.getInputStream(), Charsets.UTF_8));
        return properties2;
    }

    @NotNull
    public List<GradleDslFile> getAllFiles() {
        return new ArrayList<GradleDslFile>(this.myParsedBuildFiles.values());
    }
}

