/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleNameElement {
    @NotNull
    public static final Pattern INDEX_PATTERN = Pattern.compile("\\[(.+?)\\]|(.+?)(?=\\[)");
    @Nullable
    private PsiElement myNameElement;
    @Nullable
    private String myLocalName;
    @Nullable
    private String myFakeName;
    @Nullable
    private String myName = null;
    @Nullable
    private String myOriginalName;

    @NotNull
    public static GradleNameElement from(@NotNull PsiElement element2, GradleDslNameConverter converter) {
        return new GradleNameElement(element2, converter);
    }

    @NotNull
    public static GradleNameElement empty() {
        return new GradleNameElement(null, null);
    }

    @NotNull
    public static GradleNameElement create(@NotNull String name) {
        return new GradleNameElement(GradleNameElement.escape(name), false);
    }

    @NotNull
    public static GradleNameElement fake(@NotNull String name) {
        return new GradleNameElement(name, true);
    }

    @NotNull
    public static GradleNameElement copy(@NotNull GradleNameElement element2) {
        return new GradleNameElement(element2);
    }

    private GradleNameElement(@Nullable PsiElement element2, GradleDslNameConverter converter) {
        this.setUpFrom(element2, converter);
    }

    private GradleNameElement(@NotNull String name, boolean isFake) {
        if (isFake) {
            this.myFakeName = name;
        } else {
            this.myLocalName = name;
        }
        this.myOriginalName = name;
    }

    private GradleNameElement(@NotNull GradleNameElement element2) {
        this.myLocalName = element2.myLocalName;
        this.myFakeName = element2.myFakeName;
        this.myOriginalName = element2.myOriginalName;
    }

    public void commitNameChange(@Nullable PsiElement nameElement, GradleDslNameConverter converter, GradleDslElement context) {
        this.setUpFrom(nameElement, converter);
        ModelPropertyDescription property2 = converter.modelDescriptionForParent(this.fullName(), context);
        String newName2 = property2 == null ? this.fullName() : property2.name;
        this.rename(newName2);
        this.myOriginalName = newName2;
    }

    @NotNull
    public String fullName() {
        List<String> parts = this.fullNameParts();
        return GradleNameElement.createNameFromParts(parts);
    }

    @NotNull
    public List<String> fullNameParts() {
        String name = this.findName();
        if (name == null) {
            return Lists.newArrayList();
        }
        List<String> nameSegments = GradleNameElement.split(name);
        return ContainerUtil.map(nameSegments, GradleNameElement::convertNameToKey);
    }

    public static String createNameFromParts(@NotNull List<String> parts) {
        return GradleNameElement.join(parts);
    }

    @NotNull
    public List<String> qualifyingParts() {
        List<String> parts = this.fullNameParts();
        if (parts.isEmpty()) {
            return parts;
        }
        return parts.subList(0, parts.size() - 1);
    }

    public boolean isQualified() {
        List<String> parts = this.fullNameParts();
        return parts.size() > 1;
    }

    @NotNull
    public String name() {
        List<String> parts = this.fullNameParts();
        if (parts.isEmpty()) {
            return "";
        }
        return parts.get(parts.size() - 1);
    }

    @Nullable
    public PsiElement getNamedPsiElement() {
        return this.myNameElement;
    }

    @Nullable
    public String getLocalName() {
        return this.myLocalName;
    }

    @Nullable
    public String getOriginalName() {
        return this.myOriginalName;
    }

    private void internalRename(@NotNull String newName2) {
        if (!this.isFake()) {
            this.myLocalName = newName2;
        } else {
            this.myFakeName = newName2;
        }
        this.myName = null;
    }

    public void rename(@NotNull String newName2) {
        this.internalRename(GradleNameElement.escape(newName2));
    }

    public void rename(@NotNull List<String> hierarchicalName) {
        this.internalRename(GradleNameElement.join(hierarchicalName));
    }

    public boolean isEmpty() {
        String name = this.findName();
        return name == null || name.isEmpty();
    }

    public boolean isFake() {
        return this.myNameElement == null && this.myFakeName != null;
    }

    @NotNull
    public String toString() {
        return this.fullName();
    }

    public boolean isReferencedIn(@NotNull String propertyReference) {
        String indexName;
        String name = this.name();
        if (propertyReference.equals(name)) {
            return true;
        }
        Matcher matcher = INDEX_PATTERN.matcher(propertyReference);
        if (matcher.find() && matcher.groupCount() > 0 && (indexName = matcher.group(0)).equals(name)) {
            return true;
        }
        List<String> parts = GradleNameElement.split(propertyReference);
        if (!parts.isEmpty() && parts.get(0).equals(name)) {
            return true;
        }
        return parts.size() > 1 && parts.get(0).equals(ExtDslElement.EXT.name) && parts.get(1).equals(name);
    }

    @Nullable
    private String findName() {
        if (this.myName != null) {
            return this.myName;
        }
        String name = null;
        if (this.myLocalName != null) {
            name = this.myLocalName;
        }
        if (name == null && this.myFakeName != null) {
            name = this.myFakeName;
        }
        this.myName = name;
        return name;
    }

    @NotNull
    public static String convertNameToKey(@NotNull String str) {
        return StringUtil.unquoteString((String)str);
    }

    @NotNull
    public static String escape(@NotNull String part) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < part.length(); ++i2) {
            char c = part.charAt(i2);
            if (c == '.' || c == '\\') {
                buf.append('\\');
            }
            buf.append(c);
        }
        String result2 = buf.toString();
        return result2;
    }

    @NotNull
    public static String unescape(@NotNull String part) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < part.length(); ++i2) {
            char c = part.charAt(i2);
            if (c == '\\') {
                assert (i2 < part.length() - 1);
                buf.append(part.charAt(++i2));
                continue;
            }
            buf.append(c);
        }
        String result2 = buf.toString();
        return result2;
    }

    @NotNull
    @VisibleForTesting
    public static String join(@NotNull List<String> parts) {
        String result2 = parts.stream().map(GradleNameElement::escape).collect(Collectors.joining("."));
        return result2;
    }

    @NotNull
    public static List<String> split(@NotNull String name) {
        StringBuilder buf = new StringBuilder();
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c = name.charAt(i2);
            if (c == '\\') {
                assert (i2 < name.length() - 1);
                buf.append(name.charAt(++i2));
                continue;
            }
            if (c == '.') {
                result2.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(name.charAt(i2));
        }
        result2.add(buf.toString());
        return result2;
    }

    private void setUpFrom(@Nullable PsiElement element2, GradleDslNameConverter converter) {
        this.myNameElement = element2;
        this.myFakeName = null;
        if (this.myNameElement instanceof PsiNamedElement) {
            this.myLocalName = GradleNameElement.escape(((PsiNamedElement)this.myNameElement).getName());
        } else if (this.myNameElement != null) {
            this.myLocalName = converter.psiToName(this.myNameElement);
        }
        this.myOriginalName = this.myLocalName;
        this.myName = null;
    }
}

