/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.apply;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyDslElement
extends GradlePropertiesDslElement {
    @NonNls
    public static final String APPLY_BLOCK_NAME = "apply";
    @NonNls
    private static final String FROM = "from";
    @NotNull
    private final List<GradleDslFile> myAppliedDslFiles = new ArrayList<GradleDslFile>();

    public ApplyDslElement(@NotNull GradleDslElement parent) {
        super(parent, null, GradleNameElement.create(APPLY_BLOCK_NAME));
        parent.getDslFile().registerApplyElement(this);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element2) {
        String fileName;
        GradleDslSimpleExpression from = ApplyDslElement.extractFrom(element2);
        if (from != null && (fileName = ApplyDslElement.attemptToExtractFileName(from)) != null) {
            VirtualFile file2;
            File realFile = new File(fileName);
            if (realFile.exists() && realFile.isAbsolute()) {
                file2 = LocalFileSystem.getInstance().findFileByIoFile(realFile);
            } else {
                VirtualFile parsingRoot = this.getDslFile().getContext().getCurrentParsingRoot();
                parsingRoot = parsingRoot == null ? this.getDslFile().getFile().getParent() : parsingRoot.getParent();
                file2 = VirtualFileManager.getInstance().findFileByUrl(parsingRoot + "/" + fileName);
            }
            if (file2 != null) {
                GradleBuildFile dslFile = this.getDslFile().getContext().getOrCreateBuildFile(file2, true);
                this.myAppliedDslFiles.add(dslFile);
                if (this.myParent instanceof GradlePropertiesDslElement) {
                    ((GradlePropertiesDslElement)this.myParent).addAppliedModelProperties(dslFile);
                }
            }
        }
        super.addParsedElement(element2);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myParent == null ? null : this.myParent.getPsiElement();
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.myParent == null ? null : this.myParent.create();
    }

    @Override
    public void setPsiElement(@Nullable PsiElement psiElement) {
    }

    @NotNull
    public List<GradleDslFile> getAppliedDslFiles() {
        return this.myAppliedDslFiles;
    }

    @Nullable
    private static String attemptToExtractFileName(@NotNull GradleDslSimpleExpression element2) {
        return element2.getValue(String.class);
    }

    @Nullable
    private static GradleDslSimpleExpression extractFrom(@NotNull GradleDslElement element2) {
        if (element2 instanceof GradleDslExpressionMap) {
            return ((GradleDslExpressionMap)element2).getPropertyElement(FROM, GradleDslSimpleExpression.class);
        }
        if (element2 instanceof GradleDslMethodCall) {
            return ((GradleDslMethodCall)element2).getArgumentsElement().getPropertyElement(FROM, GradleDslSimpleExpression.class);
        }
        return null;
    }
}

