/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.util.TypeReference;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.FakeElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslUnknownElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradlePropertyModelImpl
implements GradlePropertyModel {
    @Nullable
    protected GradleDslElement myElement;
    @Nullable
    protected GradleDslElement myDefaultElement;
    @NotNull
    protected GradleDslElement myPropertyHolder;
    @NotNull
    private List<PropertyTransform> myTransforms = new ArrayList<PropertyTransform>();
    @NotNull
    private final PropertyType myPropertyType;
    @NotNull
    protected String myName;
    @Nullable
    protected ModelPropertyDescription myPropertyDescription;

    public GradlePropertyModelImpl(@NotNull GradleDslElement element2) {
        this.myElement = element2;
        this.myTransforms.add(PropertyUtil.DEFAULT_TRANSFORM);
        GradleDslElement parent = element2.getParent();
        if (parent == null) {
            assert (element2 instanceof GradleDslFile);
            parent = element2;
        }
        assert (parent instanceof GradlePropertiesDslElement || parent instanceof GradleDslMethodCall) : "Property found to be invalid, this should never happen!";
        this.myPropertyHolder = parent;
        this.myPropertyType = this.myElement.getElementType();
        this.myName = this.myElement.getName();
        this.myPropertyDescription = this.myElement.getModelProperty();
    }

    public GradlePropertyModelImpl(@NotNull GradleDslElement holder, @NotNull PropertyType type, @NotNull String name) {
        this.myPropertyHolder = holder;
        this.myPropertyType = type;
        this.myName = name;
        this.myTransforms.add(PropertyUtil.DEFAULT_TRANSFORM);
        this.myPropertyDescription = null;
    }

    public GradlePropertyModelImpl(@NotNull GradleDslElement holder, @NotNull PropertyType type, @NotNull ModelPropertyDescription description2) {
        this(holder, type, description2.name);
        this.myPropertyDescription = description2;
    }

    public void addTransform(@NotNull PropertyTransform transform) {
        this.myTransforms.add(0, transform);
    }

    @Nullable
    public GradleDslElement getDefaultElement() {
        return this.myDefaultElement;
    }

    public void setDefaultElement(@NotNull GradleDslElement defaultElement) {
        this.myDefaultElement = defaultElement;
    }

    @Override
    @NotNull
    public GradlePropertyModel.ValueType getValueType() {
        return GradlePropertyModelImpl.extractAndGetValueType(this.getElement());
    }

    @Override
    @NotNull
    public PropertyType getPropertyType() {
        GradleDslElement element2 = this.getElement();
        return element2 == null ? this.myPropertyType : element2.getElementType();
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull TypeReference<T> typeReference) {
        return this.extractValue(typeReference, true);
    }

    @Override
    public <T> T getRawValue(@NotNull TypeReference<T> typeReference) {
        return this.extractValue(typeReference, false);
    }

    @Nullable
    private static GradleDslElement maybeGetInnerReferenceModel(@NotNull GradleDslElement element2) {
        GradleDslLiteral reference2;
        GradleReferenceInjection injection;
        GradleDslExpression expression2;
        GradleDslExpressionList list;
        if (GradlePropertyModelImpl.extractAndGetValueType(element2) == GradlePropertyModel.ValueType.LIST && element2 instanceof GradleDslExpressionList && (list = (GradleDslExpressionList)element2).getExpressions().size() == 1 && (expression2 = list.getElementAt(0)) instanceof GradleDslLiteral && ((GradleDslLiteral)expression2).isReference() && (injection = (reference2 = (GradleDslLiteral)expression2).getReferenceInjection()) != null) {
            return injection.getToBeInjected();
        }
        return null;
    }

    @NotNull
    private Map<String, GradlePropertyModel> getMap(boolean resolved) {
        GradleDslExpressionMap map2;
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return ImmutableMap.of();
        }
        GradleDslElement innerElement = GradlePropertyModelImpl.maybeGetInnerReferenceModel(element2);
        if (resolved && innerElement instanceof GradleDslExpressionMap) {
            map2 = (GradleDslExpressionMap)innerElement;
        } else {
            assert (element2 instanceof GradleDslExpressionMap);
            map2 = (GradleDslExpressionMap)element2;
        }
        return map2.getPropertyElements(GradleDslExpression.class).stream().collect(Collectors.toMap(e -> e.getName(), e -> new GradlePropertyModelImpl((GradleDslElement)e), (u, v) -> v, LinkedHashMap::new));
    }

    @NotNull
    private List<GradlePropertyModel> getList(boolean resolved) {
        GradleDslElement innerElement;
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return ImmutableList.of();
        }
        assert (element2 instanceof GradleDslExpressionList);
        GradleDslExpressionList list = (GradleDslExpressionList)element2;
        if (resolved && (innerElement = GradlePropertyModelImpl.maybeGetInnerReferenceModel(element2)) instanceof GradleDslExpressionList) {
            list = (GradleDslExpressionList)innerElement;
        }
        return ContainerUtil.map(list.getExpressions(), e -> new GradlePropertyModelImpl((GradleDslElement)e));
    }

    @Override
    @NotNull
    public String getName() {
        GradleDslExpressionList list;
        int index2;
        GradleDslElement element2 = this.getElement();
        if (element2 != null && element2.getParent() instanceof GradleDslExpressionList && (index2 = (list = (GradleDslExpressionList)element2.getParent()).findIndexOf(element2)) != -1) {
            return String.valueOf(index2);
        }
        return element2 == null ? this.myName : element2.getName();
    }

    @Override
    @NotNull
    public List<GradlePropertyModel> getDependencies() {
        return new ArrayList<GradlePropertyModel>(this.dependencies());
    }

    @Override
    @NotNull
    public String getFullyQualifiedName() {
        GradleDslElement element2 = this.getRawElement();
        if (element2 != null && element2.getParent() instanceof GradleDslExpressionList) {
            GradleDslExpressionList list = (GradleDslExpressionList)element2.getParent();
            return element2.getParent().getQualifiedName() + "[" + String.valueOf(list.findIndexOf(element2)) + "]";
        }
        return element2 == null ? this.myPropertyHolder.getQualifiedName() + "." + this.getName() : element2.getQualifiedName();
    }

    @Override
    @NotNull
    public VirtualFile getGradleFile() {
        return this.myPropertyHolder.getDslFile().getFile();
    }

    @Override
    public void setValue(@NotNull Object value2) {
        GradleDslExpression newElement = this.myPropertyDescription == null ? this.getTransform().bind(this.myPropertyHolder, this.myElement, value2, this.getName()) : this.getTransform().bind(this.myPropertyHolder, this.myElement, value2, this.myPropertyDescription);
        this.bindToNewElement(newElement);
    }

    @Override
    @NotNull
    public GradlePropertyModel convertToEmptyMap() {
        this.makeEmptyMap();
        return this;
    }

    @Override
    @NotNull
    public GradlePropertyModel getMapValue(@NotNull String key) {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.MAP && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't add map value to type: " + (Object)((Object)valueType) + ". Please call GradlePropertyModel#convertToMap before trying to add values");
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyMap();
        }
        GradleDslElement element2 = this.getTransform().transform(this.myElement);
        assert (element2 instanceof GradleDslExpressionMap);
        GradleDslExpressionMap map2 = (GradleDslExpressionMap)element2;
        GradleDslElement arg = map2.getPropertyElement(key);
        return arg == null ? new GradlePropertyModelImpl(element2, PropertyType.DERIVED, key) : new GradlePropertyModelImpl(arg);
    }

    @Override
    @NotNull
    public GradlePropertyModel convertToEmptyList() {
        this.makeEmptyList();
        return this;
    }

    @Override
    @NotNull
    public GradlePropertyModel addListValue() {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't add list value to type: " + (Object)((Object)valueType) + ". Please call GradlePropertyModel#convertToList before trying to add values");
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyList();
        }
        GradleDslElement element2 = this.getTransform().transform(this.myElement);
        assert (element2 instanceof GradleDslExpressionList);
        return this.addListValueAt(((GradleDslExpressionList)element2).getExpressions().size());
    }

    @Override
    @NotNull
    public GradlePropertyModel addListValueAt(int index2) {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't add list value to type: " + (Object)((Object)valueType) + ". Please call GradlePropertyModel#convertToList before trying to add values");
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyList();
        }
        GradleDslElement element2 = this.getTransform().transform(this.myElement);
        assert (element2 instanceof GradleDslExpressionList);
        GradleDslLiteral literal = new GradleDslLiteral(element2, GradleNameElement.empty());
        literal.setValue("");
        GradleDslExpressionList list = (GradleDslExpressionList)element2;
        list.addNewExpression(literal, index2);
        return new GradlePropertyModelImpl(literal);
    }

    @Override
    @Nullable
    public GradlePropertyModel getListValue(@NotNull Object value2) {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't get list value on type: " + (Object)((Object)valueType) + ". Please call GradlePropertyModel#convertToList before trying to get values");
        }
        List list = (List)this.getValue(LIST_TYPE);
        if (list == null) {
            return null;
        }
        return list.stream().filter(e -> {
            Object v = e.getValue(OBJECT_TYPE);
            return v != null && v.equals(value2);
        }).findFirst().orElse(null);
    }

    @Override
    public void delete() {
        GradleDslElement element2 = this.getElement();
        if (element2 == null || this.myElement == null) {
            return;
        }
        this.myElement = this.getTransform().delete(this.myPropertyHolder, this.myElement, element2);
    }

    @Override
    @NotNull
    public ResolvedPropertyModelImpl resolve() {
        return new ResolvedPropertyModelImpl(this);
    }

    @Override
    @NotNull
    public GradlePropertyModel getUnresolvedModel() {
        return this;
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return null;
        }
        return element2.getPsiElement();
    }

    @Override
    @Nullable
    public PsiElement getExpressionPsiElement() {
        return this.getExpressionPsiElement(false);
    }

    @Override
    @Nullable
    public PsiElement getFullExpressionPsiElement() {
        return this.getExpressionPsiElement(true);
    }

    @Nullable
    private PsiElement getExpressionPsiElement(boolean fullExpression) {
        GradleDslElement element2;
        GradleDslElement gradleDslElement = element2 = fullExpression ? this.myElement : this.getElement();
        if (element2 instanceof GradleDslExpression) {
            return ((GradleDslExpression)element2).getExpression();
        }
        return element2 == null ? null : element2.getPsiElement();
    }

    @Override
    public void rename(@NotNull String name) {
        this.rename(Arrays.asList(name));
    }

    @Override
    public void rename(@NotNull List<String> name) {
        if (this.myElement == null) {
            this.myName = GradleNameElement.join(name);
            return;
        }
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return;
        }
        GradleDslElement parent = element2.getParent();
        if (parent instanceof GradleDslExpressionList || parent instanceof GradleDslMethodCall) {
            throw new UnsupportedOperationException("Can't rename list values!");
        }
        element2.rename(name);
        this.myName = this.myElement.getName();
    }

    @Override
    public boolean isModified() {
        GradleDslElement element2 = this.myElement;
        if (element2 != null) {
            if (element2 instanceof FakeElement) {
                return PropertyUtil.isFakeElementModified((FakeElement)element2);
            }
            GradleDslElement originalElement = PropertyUtil.findOriginalElement(this.myPropertyHolder, element2);
            return originalElement == null || PropertyUtil.isElementModified(originalElement, element2);
        }
        GradlePropertiesDslElement holder = this.myPropertyHolder instanceof GradleDslMethodCall ? ((GradleDslMethodCall)this.myPropertyHolder).getArgumentsElement() : (GradlePropertiesDslElement)this.myPropertyHolder;
        GradleDslElement originalElement = holder.getOriginalElementForNameAndType(this.getName(), this.myPropertyType);
        GradleDslElement holderOriginalElement = PropertyUtil.findOriginalElement(holder.getParent(), holder);
        return originalElement != null && (originalElement.isModified() || PropertyUtil.isElementModified(holderOriginalElement, holder));
    }

    @Override
    public String toString() {
        return (String)this.getValue(STRING_TYPE);
    }

    @Override
    @Nullable
    public String valueAsString() {
        return (String)this.getValue(STRING_TYPE);
    }

    @Override
    @NotNull
    public String forceString() {
        String s = this.toString();
        assert (s != null);
        return s;
    }

    @Override
    @Nullable
    public Integer toInt() {
        return (Integer)this.getValue(INTEGER_TYPE);
    }

    @Override
    @Nullable
    public BigDecimal toBigDecimal() {
        return (BigDecimal)this.getValue(BIG_DECIMAL_TYPE);
    }

    @Override
    @Nullable
    public Boolean toBoolean() {
        return (Boolean)this.getValue(BOOLEAN_TYPE);
    }

    @Override
    @Nullable
    public List<GradlePropertyModel> toList() {
        return (List)this.getValue(LIST_TYPE);
    }

    @Override
    @Nullable
    public Map<String, GradlePropertyModel> toMap() {
        return (Map)this.getValue(MAP_TYPE);
    }

    private static GradlePropertyModel.ValueType extractAndGetValueType(@Nullable GradleDslElement element2) {
        if (element2 == null) {
            return GradlePropertyModel.ValueType.NONE;
        }
        if (element2 instanceof GradleDslExpressionMap) {
            return GradlePropertyModel.ValueType.MAP;
        }
        if (element2 instanceof GradleDslExpressionList) {
            return GradlePropertyModel.ValueType.LIST;
        }
        if (element2 instanceof GradleDslSimpleExpression && ((GradleDslSimpleExpression)element2).isReference()) {
            return GradlePropertyModel.ValueType.REFERENCE;
        }
        if (element2 instanceof GradleDslMethodCall && (element2.shouldUseAssignment() || element2.getElementType() == PropertyType.DERIVED) || element2 instanceof GradleDslUnknownElement) {
            return GradlePropertyModel.ValueType.UNKNOWN;
        }
        if (element2 instanceof GradleDslSimpleExpression) {
            GradleDslSimpleExpression expression2 = (GradleDslSimpleExpression)element2;
            Object value2 = expression2.getValue();
            if (value2 instanceof Boolean) {
                return GradlePropertyModel.ValueType.BOOLEAN;
            }
            if (value2 instanceof Integer) {
                return GradlePropertyModel.ValueType.INTEGER;
            }
            if (value2 instanceof String) {
                return GradlePropertyModel.ValueType.STRING;
            }
            if (value2 instanceof BigDecimal) {
                return GradlePropertyModel.ValueType.BIG_DECIMAL;
            }
            if (value2 == null) {
                return GradlePropertyModel.ValueType.NONE;
            }
            return GradlePropertyModel.ValueType.UNKNOWN;
        }
        return GradlePropertyModel.ValueType.UNKNOWN;
    }

    @Nullable
    private <T> T extractValue(@NotNull TypeReference<T> typeReference, boolean resolved) {
        Object value2;
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            element2 = this.getDefaultElement();
        }
        if (element2 == null) {
            return null;
        }
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType == GradlePropertyModel.ValueType.MAP) {
            value2 = this.getMap(resolved);
        } else if (valueType == GradlePropertyModel.ValueType.LIST) {
            value2 = this.getList(resolved);
        } else if (valueType == GradlePropertyModel.ValueType.REFERENCE) {
            ReferenceTo referenceVal;
            GradleDslSimpleExpression ref = (GradleDslSimpleExpression)element2;
            String refText = ref.getReferenceText();
            value2 = typeReference.getType() == Object.class || typeReference.getType() == ReferenceTo.class ? (refText != null ? ((referenceVal = ReferenceTo.createReferenceFromText(refText, this)) != null ? typeReference.castTo(referenceVal) : typeReference.castTo(new RawText(refText, refText))) : null) : (refText == null ? null : typeReference.castTo(refText));
        } else if (valueType == GradlePropertyModel.ValueType.UNKNOWN) {
            if (!(element2 instanceof GradleDslBlockElement)) {
                PsiElement psiElement;
                PsiElement psiElement2 = psiElement = element2 instanceof GradleDslSettableExpression ? ((GradleDslSettableExpression)element2).getCurrentElement() : element2.getPsiElement();
                if (psiElement == null) {
                    return null;
                }
                value2 = GradleDslElementImpl.getPsiText(psiElement);
            } else {
                value2 = element2.getFullName();
            }
        } else {
            GradleDslSimpleExpression expression2 = (GradleDslSimpleExpression)element2;
            Object object = value2 = resolved ? expression2.getValue() : expression2.getUnresolvedValue();
        }
        if (value2 == null) {
            return null;
        }
        T result2 = typeReference.castTo(value2);
        if (result2 == null && typeReference.getType().equals(String.class)) {
            result2 = typeReference.castTo(value2.toString());
        }
        return result2;
    }

    private void makeEmptyMap() {
        if (this.myPropertyDescription == null) {
            this.bindToNewElement(this.getTransform().bindMap(this.myPropertyHolder, this.myElement, this.getName(), false));
        } else {
            this.bindToNewElement(this.getTransform().bindMap(this.myPropertyHolder, this.myElement, this.myPropertyDescription, false));
        }
    }

    private void makeEmptyList() {
        if (this.myPropertyDescription == null) {
            this.bindToNewElement(this.getTransform().bindList(this.myPropertyHolder, this.myElement, this.getName(), false));
        } else {
            this.bindToNewElement(this.getTransform().bindList(this.myPropertyHolder, this.myElement, this.myPropertyDescription, false));
        }
    }

    private void bindToNewElement(@NotNull GradleDslExpression newElement) {
        if (newElement == this.myElement) {
            return;
        }
        if (this.myElement != null && this.myElement.getElementType() == PropertyType.FAKE) {
            throw new UnsupportedOperationException("Can't bind from a fake element!");
        }
        GradleDslElement element2 = this.getTransform().replace(this.myPropertyHolder, this.myElement, newElement, this.getName());
        element2.setElementType(this.myPropertyType);
        if (this.myElement != null) {
            element2.setUseAssignment(this.myElement.shouldUseAssignment());
        }
        if (this.myElement != null) {
            element2.setModelEffect(this.myElement.getModelEffect());
        }
        element2.setModified();
        this.myElement = element2;
    }

    @Nullable
    public GradleDslElement getElement() {
        return this.getTransform().transform(this.myElement);
    }

    @Override
    @Nullable
    public GradleDslElement getRawElement() {
        return this.myElement;
    }

    @Override
    @NotNull
    public GradleDslElement getRawPropertyHolder() {
        return this.myPropertyHolder;
    }

    @NotNull
    protected PropertyTransform getTransform() {
        for (PropertyTransform transform : this.myTransforms) {
            if (!transform.test(this.myElement, this.myPropertyHolder)) continue;
            return transform;
        }
        throw new IllegalStateException("No transforms found for this property model!");
    }

    @NotNull
    List<GradlePropertyModelImpl> dependencies() {
        GradleDslElement element2 = this.getElement();
        if (element2 == null) {
            return Collections.emptyList();
        }
        return element2.getResolvedVariables().stream().map(injection -> {
            GradleDslElement injected = injection.getToBeInjected();
            return injected != null ? new GradlePropertyModelImpl(injected) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

