/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.java.LanguageLevelPropertyModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PasswordPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.SigningConfigPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.model.java.LanguageLevelPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.kotlin.JvmTargetPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslGlobalValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradlePropertyModelBuilder {
    @Nullable
    private final GradlePropertiesDslElement myHolder;
    @NotNull
    private final String myName;
    @Nullable
    private final ModelPropertyDescription myProperty;
    @Nullable
    private final GradleDslElement myElement;
    @Nullable
    private GradleDslElement myDefault;
    @NotNull
    private List<PropertyTransform> myTransforms = new ArrayList<PropertyTransform>();

    @NotNull
    public static GradlePropertyModelBuilder create(@NotNull GradlePropertiesDslElement holder, @NotNull String name) {
        return new GradlePropertyModelBuilder(holder, name);
    }

    @NotNull
    public static GradlePropertyModelBuilder create(@NotNull GradlePropertiesDslElement holder, @NotNull ModelPropertyDescription property2) {
        return new GradlePropertyModelBuilder(holder, property2);
    }

    @NotNull
    public static GradlePropertyModelBuilder create(@NotNull GradleDslElement element2) {
        return new GradlePropertyModelBuilder(element2);
    }

    private GradlePropertyModelBuilder(@NotNull GradlePropertiesDslElement holder, @NotNull String name) {
        this.myHolder = holder;
        this.myName = name;
        this.myElement = null;
        this.myProperty = null;
    }

    private GradlePropertyModelBuilder(@NotNull GradlePropertiesDslElement holder, @NotNull ModelPropertyDescription property2) {
        this.myHolder = holder;
        this.myName = property2.name;
        this.myElement = null;
        this.myProperty = property2;
    }

    private GradlePropertyModelBuilder(@NotNull GradleDslElement element2) {
        this.myHolder = null;
        this.myName = element2.getName();
        this.myElement = element2;
        ModelEffectDescription effect = element2.getModelEffect();
        this.myProperty = effect == null ? null : effect.property;
    }

    public GradlePropertyModelBuilder withDefault(Object value2) {
        this.myDefault = new GradleDslGlobalValue(this.getParentElement(), value2, this.myName);
        return this;
    }

    public GradlePropertyModelBuilder addTransform(@NotNull PropertyTransform transform) {
        this.myTransforms.add(0, transform);
        return this;
    }

    @Nullable
    private GradleDslElement getElement() {
        if (this.myElement != null) {
            return this.myElement;
        }
        assert (this.myHolder != null);
        return this.myHolder.getPropertyElement(this.myName);
    }

    @NotNull
    private GradleDslElement getParentElement() {
        if (this.myHolder != null) {
            return this.myHolder;
        }
        assert (this.myElement != null && this.myElement.getParent() != null);
        return this.myElement.getParent();
    }

    public GradlePropertyModelImpl build() {
        GradleDslElement currentElement = this.getElement();
        GradlePropertyModelImpl model2 = currentElement != null ? new GradlePropertyModelImpl(currentElement) : (this.myProperty != null ? new GradlePropertyModelImpl(this.getParentElement(), PropertyType.REGULAR, this.myProperty) : new GradlePropertyModelImpl(this.getParentElement(), PropertyType.REGULAR, this.myName));
        return this.setUpModel(model2);
    }

    public SigningConfigPropertyModelImpl buildSigningConfig() {
        return new SigningConfigPropertyModelImpl(this.build());
    }

    public PasswordPropertyModelImpl buildPassword() {
        GradleDslElement currentElement = this.getElement();
        PasswordPropertyModelImpl model2 = currentElement == null ? new PasswordPropertyModelImpl(this.getParentElement(), PropertyType.REGULAR, this.myName) : new PasswordPropertyModelImpl(currentElement);
        return this.setUpModel(model2);
    }

    public ResolvedPropertyModelImpl buildResolved() {
        return this.build().resolve();
    }

    public LanguageLevelPropertyModelImpl buildLanguage() {
        return new LanguageLevelPropertyModelImpl(this.build());
    }

    public LanguageLevelPropertyModel buildJvmTarget() {
        return new JvmTargetPropertyModelImpl(this.build());
    }

    @Deprecated
    @Nullable
    public static GradlePropertyModel getModelFromExternalText(@NotNull String name, @NotNull GradleDslElement context) {
        GradleDslElement dslElement = context.resolveExternalSyntaxReference(name, false);
        if (dslElement == null) {
            return null;
        }
        return GradlePropertyModelBuilder.createModelFromDslElement(dslElement);
    }

    @Nullable
    public static GradlePropertyModel getModelFromInternalText(@NotNull String name, @NotNull GradleDslElement context) {
        GradleDslElement dslElement = context.resolveInternalSyntaxReference(name, false);
        if (dslElement == null) {
            return null;
        }
        return GradlePropertyModelBuilder.createModelFromDslElement(dslElement);
    }

    @NotNull
    public static GradlePropertyModel createModelFromDslElement(@NotNull GradleDslElement dslElement) {
        if (dslElement.getParent() != null && dslElement instanceof GradlePropertiesDslElement) {
            GradlePropertiesDslElement parent = (GradlePropertiesDslElement)dslElement.getParent();
            return GradlePropertyModelBuilder.create(parent, dslElement.getName()).build();
        }
        return GradlePropertyModelBuilder.create(dslElement).build();
    }

    @NotNull
    private <T extends GradlePropertyModelImpl> T setUpModel(@NotNull T model2) {
        if (this.myDefault != null) {
            model2.setDefaultElement(this.myDefault);
        }
        for (PropertyTransform t : this.myTransforms) {
            model2.addTransform(t);
        }
        return model2;
    }
}

