/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginModelImpl
implements PluginModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NotNull
    private final GradleDslElement myCompleteElement;
    @NotNull
    private final GradleDslSimpleExpression myDslElement;

    @NotNull
    public static List<PluginModelImpl> create(@NotNull GradlePropertiesDslElement dslElement) {
        List<GradleDslElement> elements = dslElement.getAllPropertyElements();
        ArrayList<PluginModelImpl> results = new ArrayList<PluginModelImpl>();
        for (GradleDslElement e : elements) {
            GradleDslElement element2;
            if (e instanceof GradleDslSimpleExpression) {
                if (e instanceof GradleDslMethodCall) {
                    element2 = (GradleDslMethodCall)e;
                    GradleDslExpressionList elementArguments = ((GradleDslMethodCall)element2).getArgumentsElement();
                    for (GradleDslSimpleExpression item : elementArguments.getSimpleExpressions()) {
                        results.add(new PluginModelImpl(e, item));
                    }
                    continue;
                }
                results.add(new PluginModelImpl(e, (GradleDslSimpleExpression)e));
                continue;
            }
            if (e instanceof GradleDslExpressionMap) {
                element2 = ((GradleDslExpressionMap)e).getElement(PLUGIN);
                if (!(element2 instanceof GradleDslSimpleExpression)) continue;
                results.add(new PluginModelImpl(e, (GradleDslSimpleExpression)element2));
                continue;
            }
            if (!(e instanceof GradleDslExpressionList)) continue;
            element2 = (GradleDslExpressionList)e;
            for (GradleDslSimpleExpression item : ((GradleDslExpressionList)element2).getSimpleExpressions()) {
                results.add(new PluginModelImpl(item, item));
            }
        }
        return results;
    }

    public static Map<String, PluginModelImpl> deduplicatePlugins(@NotNull List<PluginModelImpl> models2) {
        LinkedHashMap<String, PluginModelImpl> modelMap = new LinkedHashMap<String, PluginModelImpl>();
        for (PluginModelImpl model2 : models2) {
            ResolvedPropertyModel propertyModel = model2.name();
            if (propertyModel.getValueType() != GradlePropertyModel.ValueType.STRING) continue;
            modelMap.put(propertyModel.forceString(), model2);
        }
        return modelMap;
    }

    public static void removePlugins(@NotNull List<PluginModelImpl> models2, @NotNull String name) {
        for (PluginModelImpl model2 : models2) {
            if (!name.equals(model2.name().toString())) continue;
            model2.remove();
        }
    }

    public PluginModelImpl(@NotNull GradleDslElement completeElement, @NotNull GradleDslSimpleExpression element2) {
        this.myDslElement = element2;
        this.myCompleteElement = completeElement;
    }

    @Override
    @NotNull
    public ResolvedPropertyModel name() {
        return GradlePropertyModelBuilder.create(this.myDslElement).buildResolved();
    }

    @Override
    public void remove() {
        PropertyUtil.removeElement(this.myCompleteElement);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myCompleteElement.getPsiElement();
    }
}

