/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dependencies.ConfigurationNameMapper;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Objects;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        return (GradleDependencyManager)ServiceManager.getService((Project)project, GradleDependencyManager.class);
    }

    @NotNull
    public List<GradleCoordinate> findMissingDependencies(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2) {
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module2);
        GradleBuildModel buildModel = GradleBuildModel.get(module2);
        if (gradleModel == null && buildModel == null) {
            return Collections.emptyList();
        }
        List<ArtifactDependencyModel> compileDependencies = buildModel != null ? buildModel.dependencies().artifacts() : null;
        GradleVersion appCompatVersion = null;
        if (compileDependencies != null) {
            for (ArtifactDependencyModel dependency : compileDependencies) {
                if (!Objects.equal((Object)"com.android.support", (Object)dependency.group().toString()) || Objects.equal((Object)"multidex", (Object)dependency.name().forceString())) continue;
                String s = dependency.version().toString();
                if (s == null) break;
                appCompatVersion = GradleVersion.tryParse((String)s);
                break;
            }
        }
        Project project = module2.getProject();
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        ArrayList<GradleCoordinate> missingLibraries = new ArrayList<GradleCoordinate>();
        for (GradleCoordinate coordinate : dependencies2) {
            boolean dependencyFound;
            String groupId = coordinate.getGroupId();
            String artifactId = coordinate.getArtifactId();
            if (artifactId == null || groupId == null) continue;
            GradleCoordinate resolvedCoordinate = manager.resolveDynamicCoordinate(coordinate, project, null);
            if (appCompatVersion != null && coordinate.acceptsGreaterRevisions() && "com.android.support".equals(groupId) && !artifactId.equals("multidex")) {
                resolvedCoordinate = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + appCompatVersion.toString()));
            }
            if (resolvedCoordinate != null) {
                coordinate = resolvedCoordinate;
            }
            if (dependencyFound = compileDependencies != null && compileDependencies.stream().anyMatch(d -> Objects.equal((Object)d.group().toString(), (Object)groupId) && d.name().forceString().equals(artifactId))) continue;
            missingLibraries.add(coordinate);
        }
        return missingLibraries;
    }

    public boolean addDependenciesAndSync(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2, @Nullable Runnable callback2) {
        return this.addDependenciesInTransaction(module2, dependencies2, true, callback2, null);
    }

    public boolean addDependenciesWithoutSync(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2) {
        return this.addDependenciesInTransaction(module2, dependencies2, false, null, null);
    }

    public boolean addDependenciesWithoutSync(@NotNull Module module2, @NotNull Iterable<GradleCoordinate> dependencies2, @Nullable ConfigurationNameMapper nameMapper) {
        return this.addDependenciesInTransaction(module2, dependencies2, false, null, nameMapper);
    }

    public boolean updateLibrariesToVersion(@NotNull Module module2, @NotNull List<GradleCoordinate> dependencies2, @Nullable Runnable callback2) {
        GradleBuildModel buildModel = GradleBuildModel.get(module2);
        if (buildModel == null) {
            return false;
        }
        GradleDependencyManager.updateDependenciesInTransaction(buildModel, module2, dependencies2, callback2);
        return true;
    }

    public boolean userWantToAddDependencies(@NotNull Module module2, @NotNull Collection<GradleCoordinate> missing) {
        String libraryNames2 = StringUtil.join(missing, GradleCoordinate::getArtifactId, (String)", ");
        String message2 = String.format("This operation requires the %1$s %2$s. \n\nWould you like to add %3$s %1$s now?", StringUtil.pluralize((String)"library", (int)missing.size()), libraryNames2, StringUtil.pluralize((String)"this", (int)missing.size()));
        Project project = module2.getProject();
        return Messages.showOkCancelDialog((Project)project, (String)message2, (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    private boolean addDependenciesInTransaction(final @NotNull Module module2, final @NotNull Iterable<GradleCoordinate> coordinates, final boolean performSync, final @Nullable Runnable callback2, final @Nullable ConfigurationNameMapper nameMapper) {
        if (!performSync && callback2 != null) {
            throw new IllegalArgumentException("Callback must be null if sync is not requested.");
        }
        final GradleBuildModel buildModel = GradleBuildModel.get(module2);
        if (buildModel == null) {
            return false;
        }
        final Project project = module2.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                List<GradleCoordinate> missing = GradleDependencyManager.this.findMissingDependencies(module2, coordinates);
                if (missing.isEmpty()) {
                    return;
                }
                GradleDependencyManager.addDependencies(buildModel, module2, missing, nameMapper);
                if (performSync) {
                    GradleDependencyManager.requestProjectSync(project, callback2, GradleSyncStats.Trigger.TRIGGER_GRADLEDEPENDENCY_ADDED);
                }
            }
        }.execute();
        return true;
    }

    private static void addDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module2, @NotNull List<GradleCoordinate> coordinates, @Nullable ConfigurationNameMapper nameMapper) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate coordinate : coordinates) {
                String name = "compile";
                if (nameMapper != null) {
                    name = nameMapper.mapName(module2, name, coordinate);
                }
                name = GradleUtil.mapConfigurationName(name, GradleUtil.getAndroidGradleModelVersionInUse(module2), false);
                dependenciesModel.addArtifact(name, coordinate.toString());
            }
            buildModel.applyChanges();
        });
    }

    private static void updateDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module2, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback2) {
        assert (!coordinates.isEmpty());
        final Project project = module2.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                GradleDependencyManager.updateDependencies(buildModel, module2, coordinates);
                GradleDependencyManager.requestProjectSync(project, callback2, GradleSyncStats.Trigger.TRIGGER_GRADLEDEPENDENCY_UPDATED);
            }
        }.execute();
    }

    private static void requestProjectSync(@NotNull Project project, @Nullable Runnable callback2, @NotNull GradleSyncStats.Trigger trigger) {
        if (callback2 != null) {
            GradleBuildInvoker.getInstance(project).add(new GradleCompletionTask(project, callback2));
        }
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(trigger);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request);
    }

    private static void updateDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module2, @NotNull List<GradleCoordinate> coordinates) {
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate gc : coordinates) {
                ArrayList<ArtifactDependencyModel> artifacts = new ArrayList<ArtifactDependencyModel>(dependenciesModel.artifacts());
                for (ArtifactDependencyModel m : artifacts) {
                    if (gc.getGroupId() == null || !gc.getGroupId().equals(m.group().toString()) || gc.getArtifactId() == null || !gc.getArtifactId().equals(m.name().forceString()) || gc.getRevision().equals(m.version().toString())) continue;
                    dependenciesModel.remove(m);
                    dependenciesModel.addArtifact(m.configurationName(), gc.toString());
                }
            }
            buildModel.applyChanges();
        });
    }

    private static class GradleCompletionTask
    implements GradleBuildInvoker.AfterGradleInvocationTask {
        private final Project myProject;
        private final Runnable myCallback;

        private GradleCompletionTask(@NotNull Project project, @NotNull Runnable callback2) {
            this.myProject = project;
            this.myCallback = callback2;
        }

        @Override
        public void execute(@NotNull GradleInvocationResult result2) {
            GradleBuildInvoker.getInstance(this.myProject).remove(this);
            this.myCallback.run();
        }
    }
}

