/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.folding;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InlinedResource
implements ModificationTracker {
    static final InlinedResource NONE = new InlinedResource(ResourceType.STRING, "", null, null, null);
    private static final int FOLD_MAX_LENGTH = 60;
    private final ResourceType myType;
    @NotNull
    private String myKey;
    @Nullable
    private PsiElement myElement;
    @Nullable
    private FoldingDescriptor myDescriptor;
    @Nullable
    private LocalResourceRepository myResourceRepository;
    private static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    InlinedResource(@NotNull ResourceType type, @NotNull String key, @Nullable LocalResourceRepository resources, @Nullable FoldingDescriptor descriptor2, @Nullable PsiElement element2) {
        this.myType = type;
        this.myKey = key;
        this.myResourceRepository = resources;
        this.myDescriptor = descriptor2;
        this.myElement = element2;
    }

    @Nullable
    FoldingDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public long getModificationCount() {
        return this.myResourceRepository != null ? this.myResourceRepository.getModificationCount() : 0L;
    }

    @Nullable
    public String getResolvedString() {
        if (this.myResourceRepository != null && this.myResourceRepository.hasResources(ResourceNamespace.TODO(), this.myType, this.myKey)) {
            String text2;
            FolderConfiguration referenceConfig = new FolderConfiguration();
            referenceConfig.setLocaleQualifier(new LocaleQualifier("xx"));
            ResourceValue value2 = ResourceRepositoryUtil.getConfiguredValue((ResourceRepository)this.myResourceRepository, (ResourceType)this.myType, (String)this.myKey, (FolderConfiguration)referenceConfig);
            if (value2 != null && (text2 = value2.getValue()) != null) {
                if (this.myElement instanceof PsiMethodCallExpression) {
                    text2 = InlinedResource.insertArguments((PsiMethodCallExpression)this.myElement, text2);
                }
                if (this.myType == ResourceType.PLURALS && text2.startsWith("@string/") && (value2 = ResourceRepositoryUtil.getConfiguredValue((ResourceRepository)this.myResourceRepository, (ResourceType)ResourceType.STRING, (String)text2.substring("@string/".length()), (FolderConfiguration)referenceConfig)) != null && value2.getValue() != null) {
                    text2 = value2.getValue();
                    return '\"' + StringUtil.shortenTextWithEllipsis((String)text2, (int)58, (int)0) + '\"';
                }
                if (this.myType == ResourceType.STRING || this.myElement instanceof XmlAttributeValue) {
                    return '\"' + StringUtil.shortenTextWithEllipsis((String)text2, (int)58, (int)0) + '\"';
                }
                if (text2.length() <= 1) {
                    return this.myKey + ": " + text2;
                }
                return StringUtil.shortenTextWithEllipsis((String)text2, (int)60, (int)0);
            }
        }
        return null;
    }

    @NotNull
    private static String insertArguments(@NotNull PsiMethodCallExpression methodCallExpression, @NotNull String s) {
        if (s.indexOf(37) == -1) {
            return s;
        }
        PsiExpression[] args = methodCallExpression.getArgumentList().getExpressions();
        if (args.length == 0 || !args[0].isValid()) {
            return s;
        }
        Matcher matcher = FORMAT.matcher(s);
        int index2 = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int start2 = 0;
        StringBuilder sb = new StringBuilder(2 * s.length());
        while (matcher.find(index2)) {
            int number;
            if ("%".equals(matcher.group(6))) {
                index2 = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index2 = prevIndex;
                continue;
            }
            index2 = matcher.end();
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number <= 0 || number >= args.length) continue;
            PsiExpression argExpression = args[number];
            Object value2 = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)argExpression, (boolean)false);
            if (value2 == null) {
                value2 = args[number].getText();
            }
            for (int i2 = start2; i2 < matchStart; ++i2) {
                sb.append(s.charAt(i2));
            }
            sb.append('{');
            sb.append(value2);
            sb.append('}');
            start2 = index2;
        }
        int n = s.length();
        for (int i3 = start2; i3 < n; ++i3) {
            sb.append(s.charAt(i3));
        }
        return sb.toString();
    }
}

