/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.ui;

import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.explorer.DeviceExplorerModel;
import com.android.tools.idea.explorer.DeviceExplorerModelListener;
import com.android.tools.idea.explorer.DeviceExplorerView;
import com.android.tools.idea.explorer.DeviceExplorerViewListener;
import com.android.tools.idea.explorer.DeviceExplorerViewProgressListener;
import com.android.tools.idea.explorer.DeviceFileEntryNode;
import com.android.tools.idea.explorer.DeviceFileSystemRendererFactory;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceFileSystemRenderer;
import com.android.tools.idea.explorer.fs.DeviceFileSystemService;
import com.android.tools.idea.explorer.ui.ComponentPopupMenu;
import com.android.tools.idea.explorer.ui.DeviceExplorerPanel;
import com.android.tools.idea.explorer.ui.PopupMenuItem;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceExplorerViewImpl
implements DeviceExplorerView {
    @NotNull
    private final List<DeviceExplorerViewListener> myListeners = new ArrayList<DeviceExplorerViewListener>();
    @NotNull
    private final List<DeviceExplorerViewProgressListener> myProgressListeners = new ArrayList<DeviceExplorerViewProgressListener>();
    @NotNull
    private final DeviceFileSystemRenderer myDeviceRenderer;
    @NotNull
    private final DeviceExplorerPanel myPanel;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @Nullable
    private ComponentPopupMenu myTreePopupMenu;
    private int myTreeLoadingCount;

    public DeviceExplorerViewImpl(@NotNull Project project, @NotNull DeviceFileSystemRendererFactory rendererFactory, @NotNull DeviceExplorerModel model2) {
        model2.addListener(new ModelListener());
        this.myDeviceRenderer = rendererFactory.create(new DeviceNamePropertiesFetcher((Disposable)project, new FutureCallback<DeviceNameProperties>(){

            public void onSuccess(@Nullable DeviceNameProperties result2) {
                DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().updateUI();
            }

            public void onFailure(@NotNull Throwable t) {
                Logger.getInstance(DeviceExplorerViewImpl.class).warn("Error retrieving device name properties", t);
            }
        }));
        this.myPanel = new DeviceExplorerPanel();
        this.myPanel.setCancelActionListener(e -> this.myProgressListeners.forEach(DeviceExplorerViewProgressListener::cancellationRequested));
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myLoadingPanel;
    }

    @Nullable
    public JComboBox<DeviceFileSystem> getDeviceCombo() {
        return this.myPanel.getDeviceCombo();
    }

    @Nullable
    public JTree getFileTree() {
        return this.myPanel.getTree();
    }

    @Nullable
    public ActionGroup getFileTreeActionGroup() {
        return this.myTreePopupMenu == null ? null : this.myTreePopupMenu.getActionGroup();
    }

    @NotNull
    public JBLoadingPanel getLoadingPanel() {
        return this.myLoadingPanel;
    }

    @Nullable
    public DeviceExplorerPanel getDeviceExplorerPanel() {
        return this.myPanel;
    }

    @Override
    public void addListener(@NotNull DeviceExplorerViewListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceExplorerViewListener listener2) {
        this.myListeners.remove(listener2);
    }

    @Override
    public void addProgressListener(@NotNull DeviceExplorerViewProgressListener listener2) {
        this.myProgressListeners.add(listener2);
    }

    @Override
    public void removeProgressListener(@NotNull DeviceExplorerViewProgressListener listener2) {
        this.myProgressListeners.remove(listener2);
    }

    @Override
    public void setup() {
        this.setupPanel();
    }

    @Override
    public void reportErrorRelatedToService(@NotNull DeviceFileSystemService service, @NotNull String message2, @NotNull Throwable t) {
        if (t.getMessage() != null) {
            message2 = message2 + ": " + t.getMessage();
        }
        this.myPanel.showErrorMessageLayer(message2, false);
    }

    @Override
    public void reportErrorRelatedToDevice(@NotNull DeviceFileSystem fileSystem, @NotNull String message2, @NotNull Throwable t) {
        if (t.getMessage() != null) {
            message2 = message2 + ": " + t.getMessage();
        }
        this.myPanel.showErrorMessageLayer(message2, true);
    }

    @Override
    public void reportErrorRelatedToNode(@NotNull DeviceFileEntryNode node2, @NotNull String message2, @NotNull Throwable t) {
        DeviceExplorerViewImpl.reportError(message2, t);
    }

    @Override
    public void reportMessageRelatedToDevice(@NotNull DeviceFileSystem fileSystem, @NotNull String message2) {
        this.myPanel.showMessageLayer(message2, true);
    }

    @Override
    public void reportMessageRelatedToNode(@NotNull DeviceFileEntryNode node2, @NotNull String message2) {
        DeviceExplorerViewImpl.reportMessage(message2);
    }

    private static void reportMessage(@NotNull String message2) {
        Notification notification = new Notification("Device File Explorer", "Device File Explorer", message2, NotificationType.INFORMATION);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)notification));
    }

    private static void reportError(@NotNull String message2, @NotNull Throwable t) {
        if (t instanceof CancellationException) {
            return;
        }
        if (t.getMessage() != null) {
            message2 = message2 + ": " + t.getMessage();
        }
        Notification notification = new Notification("Device File Explorer", "Device File Explorer", message2, NotificationType.WARNING);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)notification));
    }

    private void setupPanel() {
        this.myPanel.getComponent().setBorder(IdeBorderFactory.createBorder((int)8));
        this.myLoadingPanel.add((Component)this.myPanel.getComponent(), (Object)"Center");
        this.myPanel.getDeviceCombo().setRenderer(this.myDeviceRenderer.getDeviceNameListRenderer());
        this.myPanel.getDeviceCombo().addActionListener(actionEvent -> {
            Object sel = this.myPanel.getDeviceCombo().getSelectedItem();
            if (sel instanceof DeviceFileSystem) {
                DeviceFileSystem device = (DeviceFileSystem)sel;
                this.myListeners.forEach(x -> x.deviceSelected(device));
            } else {
                this.myListeners.forEach(DeviceExplorerViewListener::noDeviceSelected);
            }
        });
        final Tree tree = this.myPanel.getTree();
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DeviceFileEntryNode node2 = DeviceFileEntryNode.fromNode(event.getPath().getLastPathComponent());
                if (node2 != null) {
                    DeviceExplorerViewImpl.this.expandTreeNode(node2);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int selRow = tree.getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
                    if (selRow != -1 && selPath != null) {
                        DeviceExplorerViewImpl.this.openSelectedNodes(Collections.singletonList(selPath));
                    }
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath[] paths;
                if (10 == e.getKeyCode() && (paths = tree.getSelectionPaths()) != null) {
                    DeviceExplorerViewImpl.this.openSelectedNodes(Arrays.asList(paths));
                }
            }
        });
        this.createTreePopupMenu();
        this.myLoadingPanel.setLoadingText("Initializing ADB");
        this.myLoadingPanel.startLoading();
    }

    private void createTreePopupMenu() {
        this.myTreePopupMenu = new ComponentPopupMenu((JComponent)this.myPanel.getTree());
        ComponentPopupMenu fileMenu = this.myTreePopupMenu.addPopup("New");
        fileMenu.addItem(new NewFileMenuItem());
        fileMenu.addItem(new NewDirectoryMenuItem());
        this.myTreePopupMenu.addSeparator();
        this.myTreePopupMenu.addItem(new OpenMenuItem());
        this.myTreePopupMenu.addItem(new SaveAsMenuItem());
        this.myTreePopupMenu.addItem(new UploadFilesMenuItem());
        this.myTreePopupMenu.addItem(new DeleteNodesMenuItem());
        this.myTreePopupMenu.addSeparator();
        this.myTreePopupMenu.addItem(new SynchronizeNodesMenuItem());
        this.myTreePopupMenu.addItem(new CopyPathMenuItem());
        this.myTreePopupMenu.install();
    }

    private void openSelectedNodes(@NotNull List<TreePath> paths) {
        List<DeviceFileEntryNode> nodes = paths.stream().map(x -> DeviceFileEntryNode.fromNode(x.getLastPathComponent())).filter(Objects::nonNull).collect(Collectors.toList());
        this.openNodes(nodes);
    }

    private void copyNodePaths(@NotNull List<DeviceFileEntryNode> treeNodes) {
        this.myListeners.forEach(x -> x.copyNodePathsInvoked(treeNodes));
    }

    private void openNodes(@NotNull List<DeviceFileEntryNode> treeNodes) {
        this.myListeners.forEach(x -> x.openNodesInEditorInvoked(treeNodes));
    }

    private void saveNodesAs(@NotNull List<DeviceFileEntryNode> treeNodes) {
        this.myListeners.forEach(x -> x.saveNodesAsInvoked(treeNodes));
    }

    private void newDirectory(@NotNull DeviceFileEntryNode treeNode) {
        this.myListeners.forEach(x -> x.newDirectoryInvoked(treeNode));
    }

    private void newFile(@NotNull DeviceFileEntryNode treeNode) {
        this.myListeners.forEach(x -> x.newFileInvoked(treeNode));
    }

    private void deleteNodes(@NotNull List<DeviceFileEntryNode> treeNodes) {
        this.myListeners.forEach(x -> x.deleteNodesInvoked(treeNodes));
    }

    private void synchronizeNodes(@NotNull List<DeviceFileEntryNode> treeNodes) {
        this.myListeners.forEach(x -> x.synchronizeNodesInvoked(treeNodes));
    }

    private void uploadFiles(@NotNull DeviceFileEntryNode treeNode) {
        this.myListeners.forEach(x -> x.uploadFilesInvoked(treeNode));
    }

    @Override
    public void startRefresh(@NotNull String text2) {
        this.myPanel.showMessageLayer("", false);
        this.myLoadingPanel.setLoadingText(text2);
        this.myLoadingPanel.startLoading();
    }

    @Override
    public void stopRefresh() {
        this.myLoadingPanel.stopLoading();
    }

    @Override
    public void showNoDeviceScreen() {
        this.myPanel.showMessageLayer("Connect a device via USB cable or run an Android Virtual Device", AndroidIcons.DeviceExplorer.DevicesLineup, false);
    }

    public void setRootFolder(@Nullable DefaultTreeModel model2, @Nullable DefaultTreeSelectionModel treeSelectionModel) {
        Tree tree = this.myPanel.getTree();
        tree.setModel((TreeModel)model2);
        tree.setSelectionModel((TreeSelectionModel)treeSelectionModel);
        if (model2 != null) {
            this.myPanel.showTree();
            DeviceFileEntryNode rootNode = DeviceFileEntryNode.fromNode(model2.getRoot());
            if (rootNode != null) {
                tree.setRootVisible(false);
                this.expandTreeNode(rootNode);
            } else {
                tree.setRootVisible(true);
            }
        }
    }

    @Override
    public void startTreeBusyIndicator() {
        this.incrementTreeLoading();
    }

    @Override
    public void stopTreeBusyIndicator() {
        this.decrementTreeLoading();
    }

    @Override
    public void expandNode(@NotNull DeviceFileEntryNode treeNode) {
        this.myPanel.getTree().expandPath(new TreePath(treeNode.getPath()));
    }

    @Override
    public void startProgress() {
        this.myPanel.getProgressPanel().start();
    }

    @Override
    public void setProgressIndeterminate(boolean indeterminate) {
        this.myPanel.getProgressPanel().setIndeterminate(indeterminate);
    }

    @Override
    public void setProgressValue(double fraction) {
        this.myPanel.getProgressPanel().setProgress(fraction);
    }

    @Override
    public void setProgressOkColor() {
        this.myPanel.getProgressPanel().setOkStatusColor();
    }

    @Override
    public void setProgressWarningColor() {
        this.myPanel.getProgressPanel().setWarningStatusColor();
    }

    @Override
    public void setProgressErrorColor() {
        this.myPanel.getProgressPanel().setErrorStatusColor();
    }

    @Override
    public void setProgressText(@NotNull String text2) {
        this.myPanel.getProgressPanel().setText(text2);
    }

    @Override
    public void stopProgress() {
        this.myPanel.getProgressPanel().stop();
    }

    private void expandTreeNode(@NotNull DeviceFileEntryNode node2) {
        this.myListeners.forEach(x -> x.treeNodeExpanding(node2));
    }

    private void incrementTreeLoading() {
        if (this.myTreeLoadingCount == 0) {
            this.myPanel.getTree().setPaintBusy(true);
        }
        ++this.myTreeLoadingCount;
    }

    private void decrementTreeLoading() {
        --this.myTreeLoadingCount;
        if (this.myTreeLoadingCount == 0) {
            this.myPanel.getTree().setPaintBusy(false);
        }
    }

    private class UploadFilesMenuItem
    extends SingleSelectionTreeMenuItem {
        private UploadFilesMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Upload...";
        }

        @Override
        @Nullable
        public Shortcut[] getShortcuts() {
            return new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(79, 192), null), new KeyboardShortcut(KeyStroke.getKeyStroke(85, 192), null)};
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            return node2.getEntry().isDirectory() || node2.isSymbolicLinkToDirectory();
        }

        @Override
        public void run(@NotNull DeviceFileEntryNode node2) {
            DeviceExplorerViewImpl.this.uploadFiles(node2);
        }
    }

    private class SynchronizeNodesMenuItem
    extends TreeMenuItem {
        private SynchronizeNodesMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Synchronize";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.Refresh;
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            return true;
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            DeviceExplorerViewImpl.this.synchronizeNodes(nodes);
        }
    }

    private class DeleteNodesMenuItem
    extends TreeMenuItem {
        private DeleteNodesMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Delete...";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.Cancel;
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            return true;
        }

        @Override
        @Nullable
        public String getShortcutId() {
            return "$Delete";
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            DeviceExplorerViewImpl.this.deleteNodes(nodes);
        }
    }

    private class NewDirectoryMenuItem
    extends SingleSelectionTreeMenuItem {
        private NewDirectoryMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Directory";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Nodes.Folder;
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            return node2.getEntry().isDirectory() || node2.isSymbolicLinkToDirectory();
        }

        @Override
        public void run(@NotNull DeviceFileEntryNode node2) {
            DeviceExplorerViewImpl.this.newDirectory(node2);
        }
    }

    private class NewFileMenuItem
    extends SingleSelectionTreeMenuItem {
        private NewFileMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "File";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.FileTypes.Text;
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            return node2.getEntry().isDirectory() || node2.isSymbolicLinkToDirectory();
        }

        @Override
        public void run(@NotNull DeviceFileEntryNode node2) {
            DeviceExplorerViewImpl.this.newFile(node2);
        }
    }

    private class SaveAsMenuItem
    extends TreeMenuItem {
        private SaveAsMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Save As...";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.Menu_saveall;
        }

        @Override
        @Nullable
        public Shortcut[] getShortcuts() {
            return new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(83, 192), null), new KeyboardShortcut(KeyStroke.getKeyStroke(68, 192), null)};
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            return true;
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            DeviceExplorerViewImpl.this.saveNodesAs(nodes);
        }
    }

    private class OpenMenuItem
    extends TreeMenuItem {
        private OpenMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Open";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.Menu_open;
        }

        @Override
        @Nullable
        public String getShortcutId() {
            return "OpenFile";
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            return node2.getEntry().isFile();
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            DeviceExplorerViewImpl.this.openNodes(nodes);
        }
    }

    private class CopyPathMenuItem
    extends TreeMenuItem {
        private CopyPathMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Copy Path";
        }

        @Override
        public String getShortcutId() {
            return "CopyPaths";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.Copy;
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            return true;
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            DeviceExplorerViewImpl.this.copyNodePaths(nodes);
        }
    }

    private abstract class SingleSelectionTreeMenuItem
    extends TreeMenuItem {
        private SingleSelectionTreeMenuItem() {
        }

        @Override
        public boolean isEnabled(@NotNull List<DeviceFileEntryNode> nodes) {
            return super.isEnabled(nodes) && nodes.size() == 1;
        }

        @Override
        public boolean isVisible(@NotNull List<DeviceFileEntryNode> nodes) {
            return super.isVisible(nodes) && nodes.size() == 1;
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes.size() == 1) {
                this.run(nodes.get(0));
            }
        }

        public abstract void run(@NotNull DeviceFileEntryNode var1);
    }

    private abstract class TreeMenuItem
    implements PopupMenuItem {
        private TreeMenuItem() {
        }

        @Override
        @NotNull
        public abstract String getText();

        @Override
        @Nullable
        public Icon getIcon() {
            return null;
        }

        @Override
        public final boolean isEnabled() {
            List<DeviceFileEntryNode> nodes = this.getSelectedNodes();
            if (nodes == null) {
                return false;
            }
            return this.isEnabled(nodes);
        }

        public boolean isEnabled(@NotNull List<DeviceFileEntryNode> nodes) {
            return nodes.stream().anyMatch(this::isEnabled);
        }

        @Override
        public final boolean isVisible() {
            List<DeviceFileEntryNode> nodes = this.getSelectedNodes();
            if (nodes == null) {
                return false;
            }
            return this.isVisible(nodes);
        }

        public boolean isVisible(@NotNull List<DeviceFileEntryNode> nodes) {
            return nodes.stream().anyMatch(this::isVisible);
        }

        @Override
        public final void run() {
            List<DeviceFileEntryNode> nodes = this.getSelectedNodes();
            if (nodes == null) {
                return;
            }
            if (!(nodes = nodes.stream().filter(this::isEnabled).collect(Collectors.toList())).isEmpty()) {
                this.run(nodes);
            }
        }

        @Nullable
        private List<DeviceFileEntryNode> getSelectedNodes() {
            TreePath[] paths = DeviceExplorerViewImpl.this.myPanel.getTree().getSelectionPaths();
            if (paths == null) {
                return null;
            }
            List<DeviceFileEntryNode> nodes = Arrays.stream(paths).map(path2 -> DeviceFileEntryNode.fromNode(path2.getLastPathComponent())).filter(Objects::nonNull).collect(Collectors.toList());
            if (nodes.isEmpty()) {
                return null;
            }
            return nodes;
        }

        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            return true;
        }

        public boolean isEnabled(@NotNull DeviceFileEntryNode node2) {
            return this.isVisible(node2);
        }

        public abstract void run(@NotNull List<DeviceFileEntryNode> var1);
    }

    private class ModelListener
    implements DeviceExplorerModelListener {
        private ModelListener() {
        }

        @Override
        public void allDevicesRemoved() {
            DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().removeAllItems();
        }

        @Override
        public void deviceAdded(@NotNull DeviceFileSystem device) {
            DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().addItem(device);
        }

        @Override
        public void deviceRemoved(@NotNull DeviceFileSystem device) {
            DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().removeItem(device);
        }

        @Override
        public void deviceUpdated(@NotNull DeviceFileSystem device) {
            if (DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().getSelectedItem() == device) {
                DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().repaint();
            }
        }

        @Override
        public void activeDeviceChanged(@Nullable DeviceFileSystem newActiveDevice) {
        }

        @Override
        public void treeModelChanged(@Nullable DefaultTreeModel newTreeModel, @Nullable DefaultTreeSelectionModel newTreeSelectionModel) {
            DeviceExplorerViewImpl.this.setRootFolder(newTreeModel, newTreeSelectionModel);
        }
    }
}

