/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.annotations.concurrency.UiThread;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceFileSystemService;
import com.android.tools.idea.explorer.fs.DeviceFileSystemServiceListener;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@UiThread
public final class AdbDeviceFileSystemService
implements Disposable,
DeviceFileSystemService<AdbDeviceFileSystem> {
    public static Logger LOGGER = Logger.getInstance(AdbDeviceFileSystemService.class);
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;
    @NotNull
    private final List<AdbDeviceFileSystem> myDevices = new ArrayList<AdbDeviceFileSystem>();
    @NotNull
    private final List<DeviceFileSystemServiceListener> myListeners = new ArrayList<DeviceFileSystemServiceListener>();
    @NotNull
    private State myState = State.Initial;
    @Nullable
    private AndroidDebugBridge myBridge;
    @Nullable
    private DeviceChangeListener myDeviceChangeListener;
    @Nullable
    private DebugBridgeChangeListener myDebugBridgeChangeListener;
    @Nullable
    private File myAdb;
    @NotNull
    private SettableFuture<Void> myStartServiceFuture = SettableFuture.create();

    @NotNull
    public static AdbDeviceFileSystemService getInstance(Project project) {
        return (AdbDeviceFileSystemService)ServiceManager.getService((Project)project, AdbDeviceFileSystemService.class);
    }

    private AdbDeviceFileSystemService() {
        this.myEdtExecutor = new FutureCallbackExecutor((Executor)EdtExecutorService.getInstance());
        this.myTaskExecutor = new FutureCallbackExecutor((Executor)PooledThreadExecutor.INSTANCE);
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.myDebugBridgeChangeListener);
        this.myBridge = null;
        this.myDevices.clear();
        this.myListeners.clear();
    }

    @NotNull
    List<AdbDeviceFileSystem> getDeviceList() {
        return this.myDevices;
    }

    @Override
    public void addListener(@NotNull DeviceFileSystemServiceListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceFileSystemServiceListener listener2) {
        this.myListeners.remove(listener2);
    }

    @NotNull
    public FutureCallbackExecutor getEdtExecutor() {
        return this.myEdtExecutor;
    }

    @NotNull
    public FutureCallbackExecutor getTaskExecutor() {
        return this.myTaskExecutor;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> start(@NotNull Supplier<File> adbSupplier) {
        if (this.myState == State.SetupRunning || this.myState == State.SetupDone) {
            return this.myStartServiceFuture;
        }
        File adb = adbSupplier.get();
        if (adb == null) {
            LOGGER.warn("ADB not found");
            return Futures.immediateFailedFuture((Throwable)new FileNotFoundException("Android Debug Bridge not found."));
        }
        this.myAdb = adb;
        this.myDeviceChangeListener = new DeviceChangeListener();
        this.myDebugBridgeChangeListener = new DebugBridgeChangeListener();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.myDebugBridgeChangeListener);
        return this.startDebugBridge();
    }

    @NotNull
    private ListenableFuture<Void> startDebugBridge() {
        assert (this.myAdb != null);
        this.myState = State.SetupRunning;
        this.myStartServiceFuture = SettableFuture.create();
        ListenableFuture<AndroidDebugBridge> debugBridgeFuture = AdbService.getInstance().getDebugBridge(this.myAdb);
        this.myEdtExecutor.addCallback(debugBridgeFuture, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                LOGGER.info("Successfully obtained debug bridge");
                AdbDeviceFileSystemService.this.myState = State.SetupDone;
                AdbDeviceFileSystemService.this.myStartServiceFuture.set(null);
            }

            public void onFailure(@NotNull Throwable t) {
                LOGGER.warn("Unable to obtain debug bridge", t);
                AdbDeviceFileSystemService.this.myState = State.Initial;
                if (t.getMessage() != null) {
                    AdbDeviceFileSystemService.this.myStartServiceFuture.setException(t);
                } else {
                    AdbDeviceFileSystemService.this.myStartServiceFuture.setException((Throwable)new RuntimeException(AdbService.getDebugBridgeDiagnosticErrorMessage(t, AdbDeviceFileSystemService.this.myAdb), t));
                }
            }
        });
        return this.myStartServiceFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> restart(@NotNull Supplier<File> adbSupplier) {
        if (this.myState == State.Initial) {
            return this.start(adbSupplier);
        }
        this.checkState(State.SetupDone);
        final SettableFuture futureResult = SettableFuture.create();
        this.getTaskExecutor().execute(() -> {
            try {
                AdbService.getInstance().terminateDdmlib();
            }
            catch (Throwable t) {
                futureResult.setException(t);
                return;
            }
            this.getEdtExecutor().execute(() -> {
                ListenableFuture<Void> futureStart = this.startDebugBridge();
                this.getEdtExecutor().addCallback(futureStart, (FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(@Nullable Void result2) {
                        futureResult.set(null);
                    }

                    public void onFailure(@NotNull Throwable t) {
                        futureResult.setException(t);
                    }
                });
            });
        });
        return futureResult;
    }

    @Override
    @NotNull
    public ListenableFuture<List<AdbDeviceFileSystem>> getDevices() {
        this.checkState(State.SetupDone);
        return Futures.immediateFuture(this.myDevices);
    }

    private void checkState(State state) {
        if (this.myState != state) {
            throw new IllegalStateException();
        }
    }

    private class DeviceChangeListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private DeviceChangeListener() {
        }

        public void deviceConnected(IDevice device) {
            LOGGER.info(String.format("Device connected: %s", device));
            AdbDeviceFileSystemService.this.myEdtExecutor.execute(() -> {
                AdbDeviceFileSystem deviceFileSystem = this.findDevice(device);
                if (deviceFileSystem == null) {
                    AdbDeviceFileSystem newDevice = new AdbDeviceFileSystem(device, (Executor)AdbDeviceFileSystemService.this.myEdtExecutor, (Executor)AdbDeviceFileSystemService.this.myTaskExecutor);
                    AdbDeviceFileSystemService.this.myDevices.add(newDevice);
                    AdbDeviceFileSystemService.this.myListeners.forEach(x -> x.deviceAdded(newDevice));
                }
            });
        }

        public void deviceDisconnected(IDevice device) {
            LOGGER.info(String.format("Device disconnected: %s", device));
            AdbDeviceFileSystemService.this.myEdtExecutor.execute(() -> {
                AdbDeviceFileSystem deviceFileSystem = this.findDevice(device);
                if (deviceFileSystem != null) {
                    AdbDeviceFileSystemService.this.myListeners.forEach(x -> x.deviceRemoved(deviceFileSystem));
                    AdbDeviceFileSystemService.this.myDevices.remove(deviceFileSystem);
                }
            });
        }

        public void deviceChanged(IDevice device, int changeMask) {
            LOGGER.info(String.format("Device changed: %s", device));
            AdbDeviceFileSystemService.this.myEdtExecutor.execute(() -> {
                AdbDeviceFileSystem deviceFileSystem = this.findDevice(device);
                if (deviceFileSystem != null) {
                    AdbDeviceFileSystemService.this.myListeners.forEach(x -> x.deviceUpdated(deviceFileSystem));
                }
            });
        }

        @Nullable
        private AdbDeviceFileSystem findDevice(IDevice device) {
            return AdbDeviceFileSystemService.this.myDevices.stream().filter(system -> system.isDevice(device)).findFirst().orElse(null);
        }
    }

    private class DebugBridgeChangeListener
    implements AndroidDebugBridge.IDebugBridgeChangeListener {
        private DebugBridgeChangeListener() {
        }

        public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
            LOGGER.info("Debug bridge changed");
            AdbDeviceFileSystemService.this.myEdtExecutor.execute(() -> {
                if (AdbDeviceFileSystemService.this.myBridge != null) {
                    AdbDeviceFileSystemService.this.myDevices.clear();
                    AdbDeviceFileSystemService.this.myListeners.forEach(DeviceFileSystemServiceListener::serviceRestarted);
                    AdbDeviceFileSystemService.this.myBridge = null;
                }
                if (bridge != null) {
                    AdbDeviceFileSystemService.this.myBridge = bridge;
                    if (AdbDeviceFileSystemService.this.myBridge.hasInitialDeviceList()) {
                        Arrays.stream(AdbDeviceFileSystemService.this.myBridge.getDevices()).map(d -> new AdbDeviceFileSystem((IDevice)d, (Executor)AdbDeviceFileSystemService.this.myEdtExecutor, (Executor)AdbDeviceFileSystemService.this.myTaskExecutor)).forEach(AdbDeviceFileSystemService.this.myDevices::add);
                    }
                }
            });
        }
    }

    public static enum State {
        Initial,
        SetupRunning,
        SetupDone;

    }
}

