/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs;

import com.android.tools.idea.experimental.codeanalysis.datastructs.Modifier;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGField;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGMethod;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGPartialMethodSignature;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.BlockGraph;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCFGClass
implements PsiAnnotationOwner {
    public static final PsiCFGClass[] EMPTY_ARRAY = new PsiCFGClass[0];
    private PsiClass mRef;
    private PsiLambdaExpression mLambdaExpressionRef;
    private PsiFile mPsiFileRef;
    private int mModifierbits;
    private boolean mIsInterface = false;
    protected Map<PsiMethod, PsiCFGMethod> mMethodMap;
    protected Map<PsiCFGPartialMethodSignature, PsiCFGMethod> mSignatureMethodMap;
    protected ArrayList<PsiCFGMethod> mMethodList;
    protected Map<String, PsiCFGField> mFieldMap;
    protected boolean mIsAnonlymous;
    protected boolean mIsLambda;
    protected boolean mIsNestedClass;
    protected PsiCFGMethod mNestedClassParentMethod;
    protected BlockGraph mNestedClassParentBlock;
    protected ArrayList<PsiCFGClass> declaredAnonymousClass;
    protected ArrayList<PsiCFGClass> declaredLambda;
    protected String qualifiedClassName;
    protected PsiCFGClass mSuperCFGClass;
    protected Set<PsiCFGClass> mImplementedInterfacesSet;
    protected Set<PsiCFGClass> mDirectSubClasses;
    protected Set<PsiCFGClass> mDirectSubInterfaces;
    protected Map<String, Set<PsiCFGClass>> nestedInnerClassMap;
    protected boolean mLibraryClass;
    protected PsiCFGClass mDirectOverriddenInterface;

    public PsiCFGClass(@Nullable PsiClass origin, @Nullable PsiFile declearingFile) {
        this.mRef = origin;
        this.mPsiFileRef = declearingFile;
        this.parseModifierList();
        this.mIsAnonlymous = false;
        this.mIsLambda = false;
        this.mLibraryClass = false;
        this.mIsNestedClass = false;
        this.mNestedClassParentMethod = null;
        this.qualifiedClassName = origin != null && origin.getQualifiedName() != null ? origin.getQualifiedName() : "";
        this.declaredAnonymousClass = Lists.newArrayList();
        this.declaredLambda = Lists.newArrayList();
        this.mMethodMap = Maps.newHashMap();
        this.mFieldMap = Maps.newHashMap();
        this.mSuperCFGClass = null;
        this.mImplementedInterfacesSet = Sets.newHashSet();
        this.mDirectSubClasses = Sets.newHashSet();
        this.mDirectSubInterfaces = Sets.newHashSet();
        this.mMethodList = Lists.newArrayList();
        this.mSignatureMethodMap = Maps.newHashMap();
        this.nestedInnerClassMap = Maps.newHashMap();
    }

    public void setLibraryClass() {
        this.mLibraryClass = true;
    }

    public boolean isLibraryClass() {
        return this.mLibraryClass;
    }

    @Nullable
    public PsiCFGClass getSuperClass() {
        return this.mSuperCFGClass;
    }

    public void setSuperClass(@NotNull PsiCFGClass clazz) {
        this.mSuperCFGClass = clazz;
    }

    public void addSubClass(@NotNull PsiCFGClass clazz) {
        this.mDirectSubClasses.add(clazz);
    }

    @NotNull
    public Set<PsiCFGClass> getSubClassSet() {
        return this.mDirectSubClasses;
    }

    public void addSubInterface(@NotNull PsiCFGClass interfaze) {
        this.mDirectSubClasses.add(interfaze);
    }

    public void addInterface(@NotNull PsiCFGClass interfaze) {
        this.mImplementedInterfacesSet.add(interfaze);
    }

    @NotNull
    public Set<PsiCFGClass> getImplementedInterfaceSet() {
        return this.mImplementedInterfacesSet;
    }

    @NotNull
    public PsiCFGClass[] getImplementedInterfaceArray() {
        return this.mImplementedInterfacesSet.toArray(EMPTY_ARRAY);
    }

    @NotNull
    public PsiCFGClass[] getAllSupers() {
        ArrayList supersList = Lists.newArrayList();
        supersList.add(this.mSuperCFGClass);
        supersList.addAll(this.mImplementedInterfacesSet);
        return supersList.toArray(EMPTY_ARRAY);
    }

    @Nullable
    public PsiLambdaExpression getPsiLambdaRef() {
        return this.mLambdaExpressionRef;
    }

    public void setLambdaRef(@NotNull PsiLambdaExpression lambdaRef) {
        this.mLambdaExpressionRef = lambdaRef;
        this.mIsLambda = true;
    }

    @Nullable
    public PsiClass getPsiClass() {
        return this.mRef;
    }

    public boolean isPublic() {
        return (this.mModifierbits & 1) != 0;
    }

    public boolean isInterface() {
        return this.mIsInterface;
    }

    public void setIsInterface(boolean isInterface) {
        this.mIsInterface = isInterface;
    }

    @Nullable
    public PsiFile getDeclearingFile() {
        return this.mPsiFileRef;
    }

    public boolean isAnonymous() {
        return this.mIsAnonlymous;
    }

    public void setAnonlymous() {
        this.mIsAnonlymous = true;
    }

    public void setNested() {
        this.mIsNestedClass = true;
    }

    public boolean isNested() {
        return this.mIsNestedClass;
    }

    @Nullable
    public PsiCFGMethod getDeclaringCFGMethod() {
        return this.mNestedClassParentMethod;
    }

    public void setDeclaringCFGMethod(PsiCFGMethod method2) {
        this.mNestedClassParentMethod = method2;
    }

    public BlockGraph getDeclaringBlock() {
        return this.mNestedClassParentBlock;
    }

    public void setDeclaringBlock(BlockGraph parentBlock) {
        this.mNestedClassParentBlock = parentBlock;
    }

    public String toString() {
        return this.getQualifiedClassName();
    }

    public PsiCFGClass getAnonymousClassDirectParent() {
        return this.mDirectOverriddenInterface;
    }

    public PsiCFGClass addAnonymousClass(PsiCFGClass anonymousClass) {
        int curCount = this.declaredAnonymousClass.size() + 1;
        anonymousClass.qualifiedClassName = this.qualifiedClassName + "$" + curCount;
        this.declaredAnonymousClass.add(anonymousClass);
        return anonymousClass;
    }

    public PsiCFGClass addNestedInnerClass(PsiCFGClass nestedClass, String name) {
        String qualifiedName;
        Set<Object> currentCFGClassSet;
        if (name == null) {
            name = "";
        }
        if (this.nestedInnerClassMap.containsKey(name)) {
            currentCFGClassSet = this.nestedInnerClassMap.get(name);
        } else {
            currentCFGClassSet = Sets.newHashSet();
            this.nestedInnerClassMap.put(name, (Set<PsiCFGClass>)currentCFGClassSet);
        }
        int indexNumber = currentCFGClassSet.size() + 1;
        nestedClass.qualifiedClassName = qualifiedName = String.format(Locale.US, "%s.$%d%s", this.qualifiedClassName, indexNumber, name);
        currentCFGClassSet.add(nestedClass);
        return nestedClass;
    }

    public PsiCFGClass addLambda(PsiCFGClass lambdaClass) {
        int curCount = this.declaredLambda.size() + 1;
        lambdaClass.qualifiedClassName = this.qualifiedClassName + "$lambda$" + curCount;
        this.declaredLambda.add(lambdaClass);
        return lambdaClass;
    }

    public void setDirectOverride(PsiCFGClass cfgClass) {
        this.mDirectOverriddenInterface = cfgClass;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        if (this.mRef.getModifierList() != null) {
            return this.mRef.getModifierList().getAnnotations();
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        if (this.mRef.getModifierList() != null) {
            return this.mRef.getModifierList().getApplicableAnnotations();
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @Nullable
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (this.mRef.getModifierList() != null) {
            return this.mRef.getModifierList().findAnnotation(qualifiedName);
        }
        return null;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (this.mRef.getModifierList() != null) {
            return this.mRef.getModifierList().addAnnotation(qualifiedName);
        }
        return null;
    }

    private void parseModifierList() {
        if (this.mRef != null) {
            PsiModifierList modList = this.mRef.getModifierList();
            if (modList == null) {
                this.mModifierbits = 2;
            } else {
                Modifier.ParseModifierList(modList);
            }
        }
    }

    @NotNull
    public String getQualifiedClassName() {
        return this.qualifiedClassName;
    }

    public void addMethod(@NotNull PsiCFGMethod method2) {
        this.mMethodList.add(method2);
        PsiMethod methodRef = method2.getMethodRef();
        if (methodRef != null) {
            this.mMethodMap.put(methodRef, method2);
        }
        this.mSignatureMethodMap.put(method2.getSignature(), method2);
    }

    public void addField(@NotNull PsiCFGField field2) {
        this.mFieldMap.put(field2.getPsiFieldRef().getName(), field2);
    }

    @Nullable
    public PsiCFGField getField(String name) {
        if (this.mFieldMap.containsKey(name)) {
            return this.mFieldMap.get(name);
        }
        return null;
    }

    @Nullable
    public PsiCFGMethod getMethod(PsiMethod method2) {
        if (this.mMethodMap.containsKey(method2)) {
            return this.mMethodMap.get(method2);
        }
        return null;
    }

    @Nullable
    public PsiCFGMethod getMethod(PsiCFGPartialMethodSignature signature) {
        if (this.mSignatureMethodMap.containsKey(signature)) {
            return this.mSignatureMethodMap.get(signature);
        }
        return null;
    }

    @NotNull
    public PsiCFGMethod[] getAllMethods() {
        PsiCFGMethod[] retArray = this.mMethodList.toArray(PsiCFGMethod.EMPTY_ARRAY);
        return retArray;
    }

    @NotNull
    public PsiCFGField[] getAllFields() {
        PsiCFGField[] retArray = new PsiCFGField[this.mFieldMap.size()];
        int i2 = 0;
        for (String key : this.mFieldMap.keySet()) {
            retArray[i2++] = this.mFieldMap.get(key);
        }
        return retArray;
    }
}

