/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator.actions.dialogs;

import com.android.annotations.concurrency.Slow;
import com.android.emulator.control.SnapshotDetails;
import com.android.emulator.control.SnapshotList;
import com.android.emulator.snapshot.SnapshotOuterClass;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.emulator.EmptyStreamObserver;
import com.android.tools.idea.emulator.EmulatorController;
import com.android.tools.idea.emulator.KeyValueFiles;
import com.android.tools.idea.emulator.actions.dialogs.BootMode;
import com.android.tools.idea.emulator.actions.dialogs.BootType;
import com.android.tools.idea.emulator.actions.dialogs.SnapshotInfo;
import com.intellij.openapi.diagnostic.Logger;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u0006H\u0003J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\nH\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0007J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0015H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/emulator/actions/dialogs/SnapshotManager;", "", "emulatorController", "Lcom/android/tools/idea/emulator/EmulatorController;", "(Lcom/android/tools/idea/emulator/EmulatorController;)V", "avdFolder", "Ljava/nio/file/Path;", "getAvdFolder", "()Ljava/nio/file/Path;", "avdId", "", "getAvdId", "()Ljava/lang/String;", "getEmulatorController", "()Lcom/android/tools/idea/emulator/EmulatorController;", "snapshotsFolder", "getSnapshotsFolder", "fetchSnapshotList", "", "Lcom/android/tools/idea/emulator/actions/dialogs/SnapshotInfo;", "excludeQuickBoot", "", "folderSize", "", "folder", "readBootMode", "Lcom/android/tools/idea/emulator/actions/dialogs/BootMode;", "readSnapshotInfo", "snapshotFolder", "snapshotFolderName", "saveBootMode", "", "bootMode", "saveSnapshotProto", "snapshotProto", "Lcom/android/emulator/snapshot/SnapshotOuterClass$Snapshot;", "toYesNo", "value", "intellij.android.emulator"})
public final class SnapshotManager {
    @NotNull
    private final Path snapshotsFolder;
    @NotNull
    private final EmulatorController emulatorController;

    @NotNull
    public final Path getSnapshotsFolder() {
        return this.snapshotsFolder;
    }

    @NotNull
    public final Path getAvdFolder() {
        return this.emulatorController.getEmulatorId().getAvdFolder();
    }

    private final String getAvdId() {
        return this.emulatorController.getEmulatorId().getAvdId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    @NotNull
    public final List<SnapshotInfo> fetchSnapshotList(boolean excludeQuickBoot) {
        CountDownLatch validSnapshotsReady = new CountDownLatch(1);
        boolean bl = false;
        HashSet validSnapshotIds = new HashSet();
        this.emulatorController.listSnapshots((StreamObserver<SnapshotList>)new EmptyStreamObserver<SnapshotList>(validSnapshotIds, validSnapshotsReady){
            final /* synthetic */ HashSet $validSnapshotIds;
            final /* synthetic */ CountDownLatch $validSnapshotsReady;

            public void onNext(@NotNull SnapshotList response) {
                for (SnapshotDetails snapshot : response.getSnapshotsList()) {
                    this.$validSnapshotIds.add(snapshot.getSnapshotId());
                }
            }

            public void onError(@NotNull Throwable t) {
                this.$validSnapshotsReady.countDown();
            }

            public void onCompleted() {
                this.$validSnapshotsReady.countDown();
            }
            {
                this.$validSnapshotIds = $captured_local_variable$0;
                this.$validSnapshotsReady = $captured_local_variable$1;
            }
        });
        try {
            List list;
            AutoCloseable $this$use$iv = Files.list(this.snapshotsFolder);
            boolean $i$f$use22 = false;
            boolean closed$iv = false;
            try {
                Stream stream = (Stream)$this$use$iv;
                boolean bl2 = false;
                list = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)new Function1<Path, SnapshotInfo>(this, excludeQuickBoot){
                    final /* synthetic */ SnapshotManager this$0;
                    final /* synthetic */ boolean $excludeQuickBoot$inlined;
                    {
                        this.this$0 = snapshotManager;
                        this.$excludeQuickBoot$inlined = bl;
                        super(1);
                    }

                    @Nullable
                    public final SnapshotInfo invoke(Path folder) {
                        return this.$excludeQuickBoot$inlined && Intrinsics.areEqual((Object)((Object)folder.getFileName()).toString(), (Object)"default_boot") ? null : SnapshotManager.access$readSnapshotInfo(this.this$0, folder);
                    }
                })));
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    AutoCloseable autoCloseable;
                    if (!closed$iv && (autoCloseable = $this$use$iv) != null) {
                        autoCloseable.close();
                    }
                    throw throwable;
                }
            }
            AutoCloseable autoCloseable = $this$use$iv;
            if (autoCloseable != null) {
                autoCloseable.close();
            }
            List snapshots = list;
            validSnapshotsReady.await();
            Iterator $i$f$use22 = snapshots.iterator();
            while ($i$f$use22.hasNext()) {
                SnapshotInfo snapshot;
                snapshot.setValid(validSnapshotIds.contains((snapshot = (SnapshotInfo)$i$f$use22.next()).getSnapshotId()) || snapshot.isQuickBoot() && !snapshot.isCreated());
            }
            return snapshots;
        }
        catch (NoSuchFileException snapshots) {
        }
        catch (IOException e) {
            SnapshotManager $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            Logger.getInstance(SnapshotManager.class).warn("Error reading " + this.snapshotsFolder + " - " + e.getLocalizedMessage());
        }
        return CollectionsKt.emptyList();
    }

    public static /* synthetic */ List fetchSnapshotList$default(SnapshotManager snapshotManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return snapshotManager.fetchSnapshotList(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    private final SnapshotInfo readSnapshotInfo(Path snapshotFolder) {
        Path snapshotProtoFile = snapshotFolder.resolve("snapshot.pb");
        try {
            InputStream it;
            AutoCloseable $this$use$iv = Files.newInputStream(snapshotProtoFile, new OpenOption[0]);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                it = (InputStream)$this$use$iv;
                boolean bl = false;
                it = SnapshotOuterClass.Snapshot.parseFrom((InputStream)it);
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    AutoCloseable autoCloseable;
                    if (!closed$iv && (autoCloseable = $this$use$iv) != null) {
                        autoCloseable.close();
                    }
                    throw throwable;
                }
            }
            AutoCloseable autoCloseable = $this$use$iv;
            if (autoCloseable != null) {
                autoCloseable.close();
            }
            InputStream snapshot = it;
            return new SnapshotInfo(snapshotFolder, (SnapshotOuterClass.Snapshot)snapshot, this.folderSize(snapshotFolder));
        }
        catch (NoSuchFileException snapshot) {
        }
        catch (IOException e) {
            SnapshotManager $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            Logger.getInstance(SnapshotManager.class).warn("Error reading " + snapshotProtoFile + " - " + e.getLocalizedMessage());
        }
        return null;
    }

    @Slow
    @Nullable
    public final SnapshotInfo readSnapshotInfo(@NotNull String snapshotFolderName) {
        return this.readSnapshotInfo(this.snapshotsFolder.resolve(snapshotFolderName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public final void saveSnapshotProto(@NotNull Path snapshotFolder, @NotNull SnapshotOuterClass.Snapshot snapshotProto) {
        Path protoFile = snapshotFolder.resolve("snapshot.pb");
        try {
            AutoCloseable $this$use$iv = Files.newOutputStream(protoFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                OutputStream stream = (OutputStream)$this$use$iv;
                boolean bl = false;
                snapshotProto.writeTo(stream);
                stream = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    AutoCloseable autoCloseable;
                    if (!closed$iv && (autoCloseable = $this$use$iv) != null) {
                        autoCloseable.close();
                    }
                    throw throwable;
                }
            }
            AutoCloseable autoCloseable = $this$use$iv;
            if (autoCloseable != null) {
                autoCloseable.close();
            }
        }
        catch (IOException e) {
            SnapshotManager $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            Logger.getInstance(SnapshotManager.class).warn("Error writing " + protoFile + " - " + e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final long folderSize(Path folder) {
        void size;
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        AutoCloseable $this$use$iv = Files.list(folder);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            Stream stream = (Stream)$this$use$iv;
            boolean bl = false;
            stream.forEach((Consumer)new Consumer<Path>(this, (Ref.LongRef)size){
                final /* synthetic */ SnapshotManager this$0;
                final /* synthetic */ Ref.LongRef $size$inlined;
                {
                    this.this$0 = snapshotManager;
                    this.$size$inlined = longRef;
                }

                public final void accept(Path file2) {
                    try {
                        this.$size$inlined.element = this.$size$inlined.element + (Files.isDirectory(file2, new LinkOption[0]) ? SnapshotManager.access$folderSize(this.this$0, file2) : Files.size(file2));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                AutoCloseable autoCloseable;
                if (!closed$iv && (autoCloseable = $this$use$iv) != null) {
                    autoCloseable.close();
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return size.element;
    }

    @Slow
    @Nullable
    public final BootMode readBootMode() {
        Set keysToExtract = SetsKt.setOf((Object[])new String[]{"fastboot.chosenSnapshotFile", "fastboot.forceChosenSnapshotBoot", "fastboot.forceColdBoot", "fastboot.forceFastBoot"});
        Map<String, String> map2 = KeyValueFiles.readKeyValueFile(this.getAvdFolder().resolve("config.ini"), keysToExtract);
        if (map2 == null) {
            return null;
        }
        Map<String, String> map3 = map2;
        BootType bootType = Intrinsics.areEqual((Object)map3.get("fastboot.forceFastBoot"), (Object)"yes") ? BootType.QUICK : (Intrinsics.areEqual((Object)map3.get("fastboot.forceChosenSnapshotBoot"), (Object)"yes") ? BootType.SNAPSHOT : BootType.COLD);
        return new BootMode(bootType, map3.get("fastboot.chosenSnapshotFile"));
    }

    @Slow
    public final void saveBootMode(@NotNull BootMode bootMode) {
        Map updates = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"fastboot.forceColdBoot", (Object)this.toYesNo(bootMode.getBootType() == BootType.COLD)), TuplesKt.to((Object)"fastboot.forceFastBoot", (Object)this.toYesNo(bootMode.getBootType() == BootType.QUICK)), TuplesKt.to((Object)"fastboot.forceChosenSnapshotBoot", (Object)this.toYesNo(bootMode.getBootType() == BootType.SNAPSHOT)), TuplesKt.to((Object)"fastboot.chosenSnapshotFile", (Object)bootMode.getBootSnapshotId())});
        KeyValueFiles.updateKeyValueFile(this.getAvdFolder().resolve("config.ini"), updates);
        AvdManagerConnection avdManagerConnection = AvdManagerConnection.getDefaultAvdManagerConnection();
        avdManagerConnection.reloadAvd(this.getAvdId());
    }

    private final String toYesNo(boolean value2) {
        return value2 ? "yes" : "no";
    }

    @NotNull
    public final EmulatorController getEmulatorController() {
        return this.emulatorController;
    }

    public SnapshotManager(@NotNull EmulatorController emulatorController) {
        this.emulatorController = emulatorController;
        this.snapshotsFolder = this.getAvdFolder().resolve("snapshots");
    }

    public static final /* synthetic */ SnapshotInfo access$readSnapshotInfo(SnapshotManager $this, Path snapshotFolder) {
        return $this.readSnapshotInfo(snapshotFolder);
    }

    public static final /* synthetic */ long access$folderSize(SnapshotManager $this, Path folder) {
        return $this.folderSize(folder);
    }
}

