/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator;

import com.android.emulator.control.Rotation;
import com.android.tools.idea.emulator.KeyValueFiles;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 #2\u00020\u0001:\u0001#BI\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/emulator/EmulatorConfiguration;", "", "avdName", "", "avdFolder", "Ljava/nio/file/Path;", "displaySize", "Ljava/awt/Dimension;", "density", "", "skinFolder", "hasOrientationSensors", "", "hasAudioOutput", "initialOrientation", "Lcom/android/emulator/control/Rotation$SkinRotation;", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/awt/Dimension;ILjava/nio/file/Path;ZZLcom/android/emulator/control/Rotation$SkinRotation;)V", "getAvdFolder", "()Ljava/nio/file/Path;", "getAvdName", "()Ljava/lang/String;", "getDensity", "()I", "displayHeight", "getDisplayHeight", "getDisplaySize", "()Ljava/awt/Dimension;", "displayWidth", "getDisplayWidth", "getHasAudioOutput", "()Z", "getHasOrientationSensors", "getInitialOrientation", "()Lcom/android/emulator/control/Rotation$SkinRotation;", "getSkinFolder", "Companion", "intellij.android.emulator"})
public final class EmulatorConfiguration {
    @NotNull
    private final String avdName;
    @NotNull
    private final Path avdFolder;
    @NotNull
    private final Dimension displaySize;
    private final int density;
    @Nullable
    private final Path skinFolder;
    private final boolean hasOrientationSensors;
    private final boolean hasAudioOutput;
    @NotNull
    private final Rotation.SkinRotation initialOrientation;
    public static final Companion Companion = new Companion(null);

    public final int getDisplayWidth() {
        return this.displaySize.width;
    }

    public final int getDisplayHeight() {
        return this.displaySize.height;
    }

    @NotNull
    public final String getAvdName() {
        return this.avdName;
    }

    @NotNull
    public final Path getAvdFolder() {
        return this.avdFolder;
    }

    @NotNull
    public final Dimension getDisplaySize() {
        return this.displaySize;
    }

    public final int getDensity() {
        return this.density;
    }

    @Nullable
    public final Path getSkinFolder() {
        return this.skinFolder;
    }

    public final boolean getHasOrientationSensors() {
        return this.hasOrientationSensors;
    }

    public final boolean getHasAudioOutput() {
        return this.hasAudioOutput;
    }

    @NotNull
    public final Rotation.SkinRotation getInitialOrientation() {
        return this.initialOrientation;
    }

    private EmulatorConfiguration(String avdName, Path avdFolder, Dimension displaySize, int density, Path skinFolder, boolean hasOrientationSensors, boolean hasAudioOutput, Rotation.SkinRotation initialOrientation) {
        this.avdName = avdName;
        this.avdFolder = avdFolder;
        this.displaySize = displaySize;
        this.density = density;
        this.skinFolder = skinFolder;
        this.hasOrientationSensors = hasOrientationSensors;
        this.hasAudioOutput = hasAudioOutput;
        this.initialOrientation = initialOrientation;
    }

    public /* synthetic */ EmulatorConfiguration(String avdName, Path avdFolder, Dimension displaySize, int density, Path skinFolder, boolean hasOrientationSensors, boolean hasAudioOutput, Rotation.SkinRotation initialOrientation, DefaultConstructorMarker $constructor_marker) {
        this(avdName, avdFolder, displaySize, density, skinFolder, hasOrientationSensors, hasAudioOutput, initialOrientation);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/emulator/EmulatorConfiguration$Companion;", "", "()V", "getSkinPath", "Ljava/nio/file/Path;", "configIni", "", "", "androidSdkRoot", "readAvdDefinition", "Lcom/android/tools/idea/emulator/EmulatorConfiguration;", "avdId", "avdFolder", "intellij.android.emulator"})
    public static final class Companion {
        @Nullable
        public final EmulatorConfiguration readAvdDefinition(@NotNull String avdId, @NotNull Path avdFolder) {
            boolean hasOrientationSensors;
            boolean bl;
            String string;
            Path file2 = avdFolder.resolve("hardware-qemu.ini");
            Set keysToExtract1 = SetsKt.setOf((Object[])new String[]{"android.sdk.root", "hw.audioOutput", "hw.lcd.height", "hw.lcd.width", "hw.lcd.density"});
            Map<String, String> map2 = KeyValueFiles.readKeyValueFile(file2, keysToExtract1);
            if (map2 == null) {
                return null;
            }
            Map<String, String> hardwareIni = map2;
            String string2 = hardwareIni.get("android.sdk.root");
            if (string2 == null) {
                string2 = string = System.getenv("ANDROID_SDK_ROOT");
            }
            if (string2 == null) {
                string = "";
            }
            String sdkPath = string;
            Path androidSdkRoot = avdFolder.getFileSystem().getPath(sdkPath, new String[0]);
            int displayWidth = StringUtil.parseInt((String)hardwareIni.get("hw.lcd.width"), (int)0);
            int displayHeight = StringUtil.parseInt((String)hardwareIni.get("hw.lcd.height"), (int)0);
            int density = StringUtil.parseInt((String)hardwareIni.get("hw.lcd.density"), (int)0);
            String string3 = hardwareIni.get("hw.audioOutput");
            if (string3 != null) {
                String string4 = string3;
                boolean bl2 = false;
                String string5 = string4;
                boolean bl3 = false;
                bl = Boolean.parseBoolean(string5);
            } else {
                bl = true;
            }
            boolean hasAudioOutput = bl;
            Set keysToExtract2 = SetsKt.setOf((Object[])new String[]{"avd.ini.displayname", "hw.sensors.orientation", "hw.initialOrientation", "showDeviceFrame", "skin.path"});
            Map<String, String> map3 = KeyValueFiles.readKeyValueFile(avdFolder.resolve("config.ini"), keysToExtract2);
            if (map3 == null) {
                return null;
            }
            Map<String, String> configIni = map3;
            String string6 = configIni.get("avd.ini.displayname");
            if (string6 == null) {
                string6 = StringsKt.replace$default((String)avdId, (char)'_', (char)' ', (boolean)false, (int)4, null);
            }
            String avdName = string6;
            Rotation.SkinRotation initialOrientation = StringsKt.equals((String)"landscape", (String)configIni.get("hw.initialOrientation"), (boolean)true) ? Rotation.SkinRotation.LANDSCAPE : Rotation.SkinRotation.PORTRAIT;
            Path skinPath = this.getSkinPath(configIni, androidSdkRoot);
            String string7 = configIni.get("hw.sensors.orientation");
            boolean bl4 = hasOrientationSensors = string7 != null ? StringsKt.equals((String)string7, (String)"yes", (boolean)true) : true;
            if (displayWidth <= 0 || displayHeight <= 0) {
                return null;
            }
            return new EmulatorConfiguration(avdName, avdFolder, new Dimension(displayWidth, displayHeight), density, skinPath, hasOrientationSensors, hasAudioOutput, initialOrientation, null);
        }

        private final Path getSkinPath(Map<String, String> configIni, Path androidSdkRoot) {
            if (StringsKt.equals((String)"no", (String)configIni.get("showDeviceFrame"), (boolean)true)) {
                return null;
            }
            String skinPath = configIni.get("skin.path");
            return skinPath == null || Intrinsics.areEqual((Object)skinPath, (Object)"_no_skin") ? null : androidSdkRoot.resolve(skinPath);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

