/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ptable;

import com.android.tools.idea.editors.layoutInspector.ui.PropertiesTablePanel;
import com.android.tools.property.ptable.PNameRenderer;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableCellRenderer;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class LITableNameRenderer
implements PNameRenderer {
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final PTableCellRenderer myRenderer = new Renderer();

    public LITableNameRenderer() {
        this.myPanel.add((Component)((Object)this.myRenderer), "Center");
    }

    @Override
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean cellHasFocus, int row, int column) {
        this.myRenderer.clear();
        PTableItem item = (PTableItem)value2;
        this.myRenderer.getTableCellRendererComponent(table2, value2, isSelected, cellHasFocus, row, column);
        this.myRenderer.setBackground(isSelected ? UIUtil.getTableSelectionBackground((boolean)true) : (item.hasChildren() ? PropertiesTablePanel.GROUP_BACKGROUND_COLOR : PropertiesTablePanel.ITEM_BACKGROUND_COLOR));
        this.myPanel.setBackground(isSelected ? UIUtil.getTableSelectionBackground((boolean)true) : (item.hasChildren() ? PropertiesTablePanel.GROUP_BACKGROUND_COLOR : PropertiesTablePanel.ITEM_BACKGROUND_COLOR));
        String label = item.getParent() != null ? item.getParent().getChildLabel(item) : item.getName();
        this.myRenderer.append(label, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myRenderer.setToolTipText(item.getTooltipText());
        this.myRenderer.setBorder(new EmptyBorder(1, 1, 1, 1));
        return this.myPanel;
    }

    @Override
    public boolean hitTestTreeNodeIcon(@NotNull PTableItem item, int x, int y) {
        Icon icon2 = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)true, (boolean)true);
        int beforeIcon = LITableNameRenderer.getBeforeIconSpacing(LITableNameRenderer.getDepth(item), icon2.getIconWidth());
        return x >= beforeIcon && x <= beforeIcon + icon2.getIconWidth();
    }

    private static int getBeforeIconSpacing(int depth, int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return nodeIndent * depth + leftIconOffset;
    }

    private static int getAfterIconSpacing(int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return Math.max(0, nodeIndent - leftIconOffset - iconWidth);
    }

    private static int getDepth(@NotNull PTableItem item) {
        int result2 = 0;
        while (item.getParent() != null) {
            ++result2;
            item = item.getParent();
            assert (item != null);
        }
        return result2;
    }

    private static class Renderer
    extends PTableCellRenderer {
        private Renderer() {
        }

        @Override
        protected void customizeCellRenderer(@NotNull PTable table2, @NotNull PTableItem value2, boolean selected, boolean hasFocus, int row, int column) {
            this.setIcon(value2, selected, hasFocus);
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
        }

        private void setIcon(@NotNull PTableItem item, boolean selected, boolean hasFocus) {
            int textGap;
            int indent;
            Icon icon2;
            Icon groupIcon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)selected, (boolean)hasFocus);
            if (item.hasChildren()) {
                icon2 = groupIcon;
                indent = LITableNameRenderer.getBeforeIconSpacing(LITableNameRenderer.getDepth(item), groupIcon.getIconWidth());
                textGap = LITableNameRenderer.getAfterIconSpacing(groupIcon.getIconWidth());
            } else {
                icon2 = null;
                indent = 2;
                textGap = 0;
            }
            this.setIcon(icon2);
            this.setIconTextGap(textGap);
            this.setIpad((Insets)JBUI.insetsLeft((int)indent));
        }
    }
}

