/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.util;

import com.android.tools.idea.diagnostics.hprof.parser.ConstantPoolEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HeapDumpRecordType;
import com.android.tools.idea.diagnostics.hprof.parser.InstanceFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.RecordType;
import com.android.tools.idea.diagnostics.hprof.parser.StaticFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TObjectLongHashMap;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000bH\u0002Jm\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0 \u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\u0013H\u0002J&\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.J&\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0007J&\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u000206J.\u00107\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020\u0005J\u0018\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0005H\u0002J\u0016\u0010@\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u0007J\u001e\u0010B\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u0005J\u000e\u0010E\u001a\u00020\u00132\u0006\u0010F\u001a\u00020\u0007J6\u0010G\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u00020\u0005J\u001e\u0010N\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u00072\u0006\u0010O\u001a\u000206J\u0016\u0010P\u001a\u00020\u00132\u0006\u0010F\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000bJ\u0014\u0010Q\u001a\u00020\u0013*\u00020\u00032\u0006\u0010F\u001a\u00020\u0007H\u0002J\u0014\u0010R\u001a\u00020\u0013*\u00020S2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u001c\u0010T\u001a\u00020\u0013*\u00020\u00032\u0006\u0010U\u001a\u00020\u00072\u0006\u0010V\u001a\u000209H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/HprofWriter;", "Ljava/io/Closeable;", "dos", "Ljava/io/DataOutputStream;", "idSize", "", "timestamp", "", "(Ljava/io/DataOutputStream;IJ)V", "idToStringMap", "Lgnu/trove/TLongObjectHashMap;", "", "nextStringId", "stringToIdMap", "Lgnu/trove/TObjectLongHashMap;", "subtagsBaos", "Ljava/io/ByteArrayOutputStream;", "subtagsStream", "close", "", "flushHeapObjects", "getOrCreateStringId", "s", "writeClassDump", "classObjectId", "stackTraceSerialNumber", "superClassObjectId", "classLoaderObjectId", "signersObjectId", "protectionDomainObjectId", "instanceSize", "constantPool", "", "Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;", "(JIJJJJI[Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;)V", "writeHeapDumpRecordHeader", "heapDumpRecordType", "Lcom/android/tools/idea/diagnostics/hprof/parser/HeapDumpRecordType;", "writeHeapDumpRecords", "writeInstanceDump", "objectId", "bytes", "", "writeLoadClass", "serialNumber", "classNameId", "writeObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "elementIds", "", "writePrimitiveArrayDump", "elementType", "Lcom/android/tools/idea/diagnostics/hprof/parser/Type;", "elements", "elementsCount", "writeRecordHeader", "recordType", "Lcom/android/tools/idea/diagnostics/hprof/parser/RecordType;", "length", "writeRootGlobalJNI", "jniGlobalRefId", "writeRootJavaFrame", "threadSerialNumber", "frameNumber", "writeRootUnknown", "id", "writeStackFrame", "stackFrameId", "methodNameStringId", "methodSignatureStringId", "sourceFilenameStringId", "classSerialNumber", "lineNumber", "writeStackTrace", "stackFrameIds", "writeStringInUTF8", "writeId", "writeNullTerminatedString", "Ljava/io/DataOutput;", "writeValue", "value", "type", "intellij.android.core"})
public final class HprofWriter
implements Closeable {
    private final TObjectLongHashMap<String> stringToIdMap;
    private final TLongObjectHashMap<String> idToStringMap;
    private long nextStringId;
    private final ByteArrayOutputStream subtagsBaos;
    private DataOutputStream subtagsStream;
    private final DataOutputStream dos;
    private final int idSize;

    @Override
    public void close() {
        this.flushHeapObjects();
        this.dos.close();
    }

    private final void writeNullTerminatedString(DataOutput $this$writeNullTerminatedString, String s) {
        String string = s;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        $this$writeNullTerminatedString.write(byArray);
        $this$writeNullTerminatedString.write(0);
    }

    public final void writeStringInUTF8(long id, @NotNull String s) {
        String string = s;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        this.writeRecordHeader(RecordType.StringInUTF8, bytes.length + this.idSize);
        this.writeId(this.dos, id);
        this.dos.write(bytes);
    }

    public final void writeLoadClass(int serialNumber, long classObjectId, int stackTraceSerialNumber, long classNameId) {
        this.writeRecordHeader(RecordType.LoadClass, 8 + this.idSize * 2);
        this.dos.writeInt(serialNumber);
        this.writeId(this.dos, classObjectId);
        this.dos.writeInt(stackTraceSerialNumber);
        this.writeId(this.dos, classNameId);
    }

    public final void flushHeapObjects() {
        this.writeHeapDumpRecords();
    }

    private final void writeHeapDumpRecords() {
        if (this.subtagsBaos.size() > 0) {
            this.subtagsStream.close();
            this.writeRecordHeader(RecordType.HeapDump, this.subtagsBaos.size());
            this.subtagsBaos.writeTo(this.dos);
            this.subtagsBaos.reset();
            this.subtagsStream = new DataOutputStream(this.subtagsBaos);
            this.writeRecordHeader(RecordType.HeapDumpEnd, 0);
        }
    }

    public final void writeRootUnknown(long id) {
        DataOutputStream dataOutputStream = this.subtagsStream;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.RootUnknown);
        this.writeId($this$with, id);
    }

    public final void writeRootJavaFrame(long objectId, int threadSerialNumber, int frameNumber) {
        DataOutputStream dataOutputStream = this.subtagsStream;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.RootJavaFrame);
        this.writeId($this$with, objectId);
        $this$with.writeInt(threadSerialNumber);
        $this$with.writeInt(frameNumber);
    }

    public final void writeClassDump(long classObjectId, int stackTraceSerialNumber, long superClassObjectId, long classLoaderObjectId, long signersObjectId, long protectionDomainObjectId, int instanceSize, @NotNull ConstantPoolEntry[] constantPool, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        DataOutputStream dataOutputStream = this.subtagsStream;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.ClassDump);
        this.writeId($this$with, classObjectId);
        $this$with.writeInt(stackTraceSerialNumber);
        this.writeId($this$with, superClassObjectId);
        this.writeId($this$with, classLoaderObjectId);
        this.writeId($this$with, signersObjectId);
        this.writeId($this$with, protectionDomainObjectId);
        this.writeId($this$with, 0L);
        this.writeId($this$with, 0L);
        $this$with.writeInt(instanceSize);
        $this$with.writeShort(constantPool.length);
        for (ConstantPoolEntry constantPoolEntry : constantPool) {
            $this$with.writeShort(constantPoolEntry.getConstantPoolIndex());
            $this$with.writeByte(constantPoolEntry.getType().getTypeId());
            this.writeValue($this$with, constantPoolEntry.getValue(), constantPoolEntry.getType());
        }
        $this$with.writeShort(staticFields.length);
        for (StaticFieldEntry staticFieldEntry : staticFields) {
            this.writeId($this$with, staticFieldEntry.getFieldNameStringId());
            $this$with.writeByte(staticFieldEntry.getType().getTypeId());
            this.writeValue($this$with, staticFieldEntry.getValue(), staticFieldEntry.getType());
        }
        $this$with.writeShort(instanceFields.length);
        for (InstanceFieldEntry instanceFieldEntry : instanceFields) {
            this.writeId($this$with, instanceFieldEntry.getFieldNameStringId());
            $this$with.writeByte(instanceFieldEntry.getType().getTypeId());
        }
    }

    public final void writeInstanceDump(long objectId, int stackTraceSerialNumber, long classObjectId, @NotNull byte[] bytes) {
        DataOutputStream dataOutputStream = this.subtagsStream;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.InstanceDump);
        this.writeId($this$with, objectId);
        $this$with.writeInt(stackTraceSerialNumber);
        this.writeId($this$with, classObjectId);
        byte[] byArray = bytes;
        boolean bl4 = false;
        $this$with.writeInt(byArray.length);
        $this$with.write(bytes);
    }

    public final void writeObjectArrayDump(long arrayObjectId, int stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] elementIds) {
        DataOutputStream dataOutputStream = this.subtagsStream;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.ObjectArrayDump);
        this.writeId($this$with, arrayObjectId);
        $this$with.writeInt(stackTraceSerialNumber);
        long[] lArray = elementIds;
        boolean bl4 = false;
        $this$with.writeInt(lArray.length);
        this.writeId($this$with, arrayClassObjectId);
        long[] $this$forEach$iv = elementIds;
        boolean $i$f$forEach = false;
        long[] lArray2 = $this$forEach$iv;
        int n = lArray2.length;
        for (int j = 0; j < n; ++j) {
            long element$iv;
            long id = element$iv = lArray2[j];
            boolean bl5 = false;
            this.writeId($this$with, id);
        }
    }

    public final void writePrimitiveArrayDump(long arrayObjectId, int stackTraceSerialNumber, @NotNull Type elementType, @NotNull byte[] elements, int elementsCount) {
        DataOutputStream dataOutputStream = this.subtagsStream;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.PrimitiveArrayDump);
        this.writeId($this$with, arrayObjectId);
        $this$with.writeInt(stackTraceSerialNumber);
        $this$with.writeInt(elementsCount);
        boolean bl4 = elementType != Type.OBJECT;
        boolean bl5 = false;
        boolean bl6 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl7 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        $this$with.writeByte(elementType.getTypeId());
        bl4 = elements.length == elementsCount * elementType.getSize();
        bl5 = false;
        bl6 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl8 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        $this$with.write(elements);
    }

    private final long getOrCreateStringId(String s) {
        long id = this.stringToIdMap.get((Object)s);
        if (id == 0L) {
            long l = this.nextStringId;
            this.nextStringId = l + 1L;
            long newId = l;
            this.writeStringInUTF8(newId, s);
            this.idToStringMap.put(newId, (Object)s);
            this.stringToIdMap.put((Object)s, newId);
            return newId;
        }
        return id;
    }

    private final void writeRecordHeader(RecordType recordType, int length) {
        DataOutputStream dataOutputStream = this.dos;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        $this$with.writeByte(recordType.getValue());
        $this$with.writeInt(0);
        $this$with.writeInt(length);
    }

    private final void writeHeapDumpRecordHeader(HeapDumpRecordType heapDumpRecordType) {
        DataOutputStream dataOutputStream = this.subtagsStream;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        $this$with.writeByte(heapDumpRecordType.getValue());
    }

    public final void writeRootGlobalJNI(long objectId, long jniGlobalRefId) {
        DataOutputStream dataOutputStream = this.subtagsStream;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        this.writeHeapDumpRecordHeader(HeapDumpRecordType.RootGlobalJNI);
        this.writeId($this$with, objectId);
        this.writeId($this$with, jniGlobalRefId);
    }

    private final void writeId(DataOutputStream $this$writeId, long id) {
        switch (this.idSize) {
            case 4: {
                $this$writeId.writeInt((int)id);
                break;
            }
            case 8: {
                $this$writeId.writeLong(id);
                break;
            }
            default: {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!_Assertions.ENABLED) break;
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    private final void writeValue(DataOutputStream $this$writeValue, long value2, Type type) {
        if (type == Type.OBJECT) {
            this.writeId($this$writeValue, value2);
        } else {
            switch (type.getSize()) {
                case 1: {
                    $this$writeValue.writeByte((int)value2);
                    break;
                }
                case 2: {
                    $this$writeValue.writeShort((int)value2);
                    break;
                }
                case 4: {
                    $this$writeValue.writeInt((int)value2);
                    break;
                }
                case 8: {
                    $this$writeValue.writeLong(value2);
                    break;
                }
                default: {
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!_Assertions.ENABLED) break;
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
        }
    }

    public final void writeStackTrace(int stackTraceSerialNumber, long threadSerialNumber, @NotNull long[] stackFrameIds) {
        DataOutputStream dataOutputStream = this.dos;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        int length = 12 + this.idSize * stackFrameIds.length;
        this.writeRecordHeader(RecordType.StackTrace, length);
        $this$with.writeInt(stackTraceSerialNumber);
        $this$with.writeInt((int)threadSerialNumber);
        $this$with.writeInt(stackFrameIds.length);
        for (long frameId : stackFrameIds) {
            this.writeId($this$with, frameId);
        }
    }

    public final void writeStackFrame(long stackFrameId, long methodNameStringId, long methodSignatureStringId, long sourceFilenameStringId, int classSerialNumber, int lineNumber) {
        DataOutputStream dataOutputStream = this.dos;
        boolean bl = false;
        boolean bl2 = false;
        DataOutputStream $this$with = dataOutputStream;
        boolean bl3 = false;
        int length = 4 * this.idSize + 8;
        this.writeRecordHeader(RecordType.StackFrame, length);
        this.writeId($this$with, stackFrameId);
        this.writeId($this$with, methodNameStringId);
        this.writeId($this$with, methodSignatureStringId);
        this.writeId($this$with, sourceFilenameStringId);
        $this$with.writeInt(classSerialNumber);
        $this$with.writeInt(lineNumber);
    }

    public HprofWriter(@NotNull DataOutputStream dos, int idSize, long timestamp) {
        this.dos = dos;
        this.idSize = idSize;
        if (this.idSize != 4 && this.idSize != 8) {
            throw (Throwable)new IllegalArgumentException("idSize can only be 4 or 8");
        }
        this.writeNullTerminatedString(this.dos, "JAVA PROFILE 1.0.1");
        this.dos.writeInt(this.idSize);
        this.dos.writeLong(timestamp);
        this.stringToIdMap = new TObjectLongHashMap();
        this.idToStringMap = new TLongObjectHashMap();
        this.nextStringId = 1L;
        this.subtagsBaos = new ByteArrayOutputStream();
        this.subtagsStream = new DataOutputStream(this.subtagsBaos);
    }
}

