/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.histogram;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.histogram.HistogramEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.TruncatingPrintBuffer;
import com.android.tools.idea.diagnostics.hprof.visitors.HistogramVisitor;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "", "entries", "", "Lcom/android/tools/idea/diagnostics/hprof/histogram/HistogramEntry;", "instanceCount", "", "(Ljava/util/List;J)V", "bytesCount", "getBytesCount", "()J", "getEntries", "()Ljava/util/List;", "getInstanceCount", "getTotals", "Lkotlin/Pair;", "prepareReport", "", "name", "topClassCount", "", "Companion", "intellij.android.core"})
public final class Histogram {
    private final long bytesCount;
    @NotNull
    private final List<HistogramEntry> entries;
    private final long instanceCount;
    public static final Companion Companion = new Companion(null);

    private final Pair<Long, Long> getTotals() {
        long totalInstances = 0L;
        long totalBytes = 0L;
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HistogramEntry it = (HistogramEntry)element$iv;
            boolean bl = false;
            totalBytes += it.getTotalBytes();
            totalInstances += it.getTotalInstances();
        }
        return new Pair((Object)totalInstances, (Object)totalBytes);
    }

    public final long getBytesCount() {
        return this.bytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String prepareReport(@NotNull String name, int topClassCount) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        StringBuilder stringBuilder2 = $this$buildString;
        String string = "Histogram. Top " + topClassCount + " by instance count:";
        boolean bl6 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        Function1 appendToResult2 = (Function1)new Function1<String, Unit>($this$buildString){
            final /* synthetic */ StringBuilder $this_buildString;

            public final void invoke(@NotNull String s) {
                StringBuilder stringBuilder = this.$this_buildString;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(s);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
            }
            {
                this.$this_buildString = stringBuilder;
                super(1);
            }
        };
        int counter = 1;
        Object object = new TruncatingPrintBuffer(topClassCount, 0, (Function1<? super String, ? extends Object>)appendToResult2);
        boolean bl7 = false;
        boolean bl8 = false;
        Throwable throwable = null;
        try {
            TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)object;
            boolean bl9 = false;
            Iterable $this$forEach$iv = this.entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HistogramEntry entry = (HistogramEntry)element$iv;
                boolean bl10 = false;
                buffer.println(Histogram.Companion.formatEntryLine(counter, entry));
                int n = counter;
                counter = n + 1;
            }
            buffer = Unit.INSTANCE;
        }
        catch (Throwable buffer) {
            throwable = buffer;
            throw buffer;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = $this$buildString;
        String string2 = Histogram.Companion.getSummaryLine(this, name);
        int n = 0;
        StringBuilder stringBuilder4 = ((StringBuilder)object).append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        StringsKt.appendln((StringBuilder)$this$buildString);
        object = $this$buildString;
        string2 = "Top 10 by bytes count:";
        n = 0;
        StringBuilder stringBuilder5 = ((StringBuilder)object).append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        Iterable $this$sortedByDescending$iv22 = this.entries;
        boolean $i$f$sortedByDescending = false;
        boolean buffer = false;
        List entriesByBytes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv22, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HistogramEntry it = (HistogramEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalBytes());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalBytes();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        });
        int $this$sortedByDescending$iv22 = 0;
        n = 10;
        while ($this$sortedByDescending$iv22 < n) {
            void i2;
            HistogramEntry entry = (HistogramEntry)entriesByBytes.get((int)i2);
            StringBuilder stringBuilder6 = $this$buildString;
            String string3 = Histogram.Companion.formatEntryLine((int)(i2 + true), entry);
            boolean bl11 = false;
            StringBuilder stringBuilder7 = stringBuilder6.append(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder7);
            ++i2;
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    @NotNull
    public final List<HistogramEntry> getEntries() {
        return this.entries;
    }

    public final long getInstanceCount() {
        return this.instanceCount;
    }

    public Histogram(@NotNull List<HistogramEntry> entries, long instanceCount) {
        this.entries = entries;
        this.instanceCount = instanceCount;
        this.bytesCount = ((Number)this.getTotals().getSecond()).longValue();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\nH\u0002J.\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram$Companion;", "", "()V", "create", "Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "parser", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "formatEntryLine", "", "counter", "", "entry", "Lcom/android/tools/idea/diagnostics/hprof/histogram/HistogramEntry;", "formatEntryLineMerged", "entry2", "getSummaryLine", "histogram", "histogramName", "prepareMergedHistogramReport", "mainHistogram", "mainHistogramName", "secondaryHistogram", "secondaryHistogramName", "options", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$HistogramOptions;", "intellij.android.core"})
    public static final class Companion {
        @NotNull
        public final Histogram create(@NotNull HProfEventBasedParser parser, @NotNull ClassStore classStore) {
            HistogramVisitor histogramVisitor = new HistogramVisitor(classStore);
            parser.accept(histogramVisitor, "histogram");
            return histogramVisitor.createHistogram();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String prepareMergedHistogramReport(@NotNull Histogram mainHistogram, @NotNull String mainHistogramName, @NotNull Histogram secondaryHistogram, @NotNull String secondaryHistogramName, @NotNull AnalysisConfig.HistogramOptions options2) {
            Object object;
            Object it22;
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            HashMap mapClassNameToEntrySecondary = new HashMap();
            Iterable $this$forEach$iv = secondaryHistogram.getEntries();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                it22 = (HistogramEntry)element$iv;
                boolean bl6 = false;
                ((Map)mapClassNameToEntrySecondary).put(((HistogramEntry)it22).getClassDefinition().getName(), it22);
            }
            String summary = Companion.getSummaryLine(mainHistogram, mainHistogramName) + System.lineSeparator() + Companion.getSummaryLine(secondaryHistogram, secondaryHistogramName);
            if (options2.getIncludeByCount()) {
                StringBuilder $i$f$forEach2 = $this$buildString;
                object = "Histogram. Top " + options2.getClassByCountLimit() + " by instance count [All-objects] [Only-strong-ref]:";
                boolean element$iv = false;
                StringBuilder stringBuilder2 = $i$f$forEach2.append((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                int counter = 1;
                object = new TruncatingPrintBuffer(options2.getClassByCountLimit(), 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>($this$buildString){

                    @NotNull
                    public final StringBuilder invoke(@Nullable String p1) {
                        StringBuilder stringBuilder = (StringBuilder)this.receiver;
                        boolean bl = false;
                        StringBuilder stringBuilder2 = stringBuilder.append(p1);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                        return StringsKt.appendln((StringBuilder)stringBuilder2);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinPackage(StringsKt.class, (String)"intellij.android.core");
                    }

                    public final String getName() {
                        return "appendln";
                    }

                    public final String getSignature() {
                        return "appendln(Ljava/lang/StringBuilder;Ljava/lang/String;)Ljava/lang/StringBuilder;";
                    }
                }));
                element$iv = false;
                boolean it22 = false;
                it22 = null;
                try {
                    TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)object;
                    boolean bl7 = false;
                    Iterable $this$forEach$iv2 = mainHistogram.getEntries();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        HistogramEntry entry = (HistogramEntry)element$iv2;
                        boolean bl8 = false;
                        HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                        buffer.println(Companion.formatEntryLineMerged(counter, entry, entry2));
                        int n = counter;
                        counter = n + 1;
                    }
                    buffer = Unit.INSTANCE;
                }
                catch (Throwable buffer) {
                    it22 = buffer;
                    throw buffer;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)it22);
                }
                object = $this$buildString;
                element$iv = false;
                StringBuilder stringBuilder3 = ((StringBuilder)object).append(summary);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
            }
            if (options2.getIncludeBySize() && options2.getIncludeByCount()) {
                StringsKt.appendln((StringBuilder)$this$buildString);
            }
            if (options2.getIncludeBySize()) {
                int classCountInByBytesSection = Math.min(mainHistogram.getEntries().size(), options2.getClassBySizeLimit());
                object = $this$buildString;
                String element$iv = "Top " + classCountInByBytesSection + " by size:";
                boolean it22 = false;
                StringBuilder stringBuilder4 = ((StringBuilder)object).append(element$iv);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder4);
                Iterable $this$sortedByDescending$iv22 = mainHistogram.getEntries();
                boolean $i$f$sortedByDescending = false;
                boolean buffer = false;
                List entriesByBytes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv22, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        HistogramEntry it = (HistogramEntry)b;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getTotalBytes());
                        it = (HistogramEntry)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Long l = it.getTotalBytes();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                });
                int $this$sortedByDescending$iv22 = 0;
                int n = classCountInByBytesSection;
                while ($this$sortedByDescending$iv22 < n) {
                    void i2;
                    HistogramEntry entry = (HistogramEntry)entriesByBytes.get((int)i2);
                    HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                    StringBuilder stringBuilder5 = $this$buildString;
                    String string = Companion.formatEntryLineMerged((int)(i2 + true), entry, entry2);
                    boolean bl9 = false;
                    StringBuilder stringBuilder6 = stringBuilder5.append(string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder6);
                    ++i2;
                }
                if (!options2.getIncludeByCount()) {
                    StringBuilder stringBuilder7 = $this$buildString;
                    n = 0;
                    StringBuilder stringBuilder8 = stringBuilder7.append(summary);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder8);
                }
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String getSummaryLine(Histogram histogram2, String histogramName) {
            void totalInstances;
            Pair pair = histogram2.getTotals();
            long l = ((Number)pair.component1()).longValue();
            long totalBytes = ((Number)pair.component2()).longValue();
            pair = StringCompanionObject.INSTANCE;
            String string = "Total - %10s: %s %s %d classes (Total instances: %d)";
            Object[] objectArray = new Object[]{histogramName, HeapReportUtils.INSTANCE.toPaddedShortStringAsCount((long)totalInstances), HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(totalBytes), histogram2.getEntries().size(), histogram2.getInstanceCount()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private final String formatEntryLineMerged(int counter, HistogramEntry entry, HistogramEntry entry2) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%5d: [%s/%s] [%s/%s] %s";
            Object[] objectArray = new Object[6];
            objectArray[0] = counter;
            objectArray[1] = HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(entry.getTotalInstances());
            objectArray[2] = HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getTotalBytes());
            HistogramEntry histogramEntry = entry2;
            objectArray[3] = HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(histogramEntry != null ? histogramEntry.getTotalInstances() : 0L);
            HistogramEntry histogramEntry2 = entry2;
            objectArray[4] = HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(histogramEntry2 != null ? histogramEntry2.getTotalBytes() : 0L);
            objectArray[5] = entry.getClassDefinition().getPrettyName();
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private final String formatEntryLine(int counter, HistogramEntry entry) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%5d: [%s/%s] %s";
            Object[] objectArray = new Object[]{counter, HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(entry.getTotalInstances()), HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getTotalBytes()), entry.getClassDefinition().getPrettyName()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

