/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.DisjointUnionMap;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.utils.SparseArray;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.intellij.openapi.application.ReadAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceResolverCache {
    private final ConfigurationManager myManager;
    @VisibleForTesting
    final Map<String, ResourceResolver> myResolverMap = new HashMap<String, ResourceResolver>();
    @VisibleForTesting
    final Map<String, Table<ResourceNamespace, ResourceType, ResourceValueMap>> myAppResourceMap = new HashMap<String, Table<ResourceNamespace, ResourceType, ResourceValueMap>>();
    @VisibleForTesting
    final Map<String, Map<ResourceType, ResourceValueMap>> myFrameworkResourceMap = new HashMap<String, Map<ResourceType, ResourceValueMap>>();
    private long myCachedGeneration;
    private SparseArray<AndroidTargetData> myFrameworkResources = new SparseArray();
    private String myCustomConfigurationKey;
    private String myCustomResolverKey;

    public ResourceResolverCache(ConfigurationManager manager) {
        this.myManager = manager;
    }

    @NotNull
    public ResourceResolver getResourceResolver(@Nullable IAndroidTarget target, @NotNull String themeStyle, @NotNull FolderConfiguration fullConfiguration) {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myManager.getModule());
        if (repositoryManager == null) {
            return ResourceResolver.create(Collections.emptyMap(), null);
        }
        LocalResourceRepository resources = repositoryManager.getAppResources();
        if (this.myCachedGeneration != resources.getModificationCount()) {
            this.myResolverMap.clear();
            this.myAppResourceMap.clear();
        }
        this.myCachedGeneration = resources.getModificationCount();
        String qualifierString = fullConfiguration.getQualifierString();
        String resolverKey = ResourceResolverCache.getResolverKey(themeStyle, qualifierString);
        ResourceResolver resolver = this.myResolverMap.get(resolverKey);
        if (resolver == null) {
            if (target == null) {
                target = this.myManager.getTarget();
            }
            Map frameworkResources = target == null ? Collections.emptyMap() : this.getConfiguredFrameworkResources(target, fullConfiguration);
            Table configuredAppRes = this.myAppResourceMap.get(qualifierString);
            if (configuredAppRes == null) {
                configuredAppRes = (Table)ReadAction.compute(() -> ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)resources, (FolderConfiguration)fullConfiguration));
                this.myAppResourceMap.put(qualifierString, (Table<ResourceNamespace, ResourceType, ResourceValueMap>)configuredAppRes);
            }
            DisjointUnionMap allResources = new DisjointUnionMap(Collections.singletonMap(ResourceNamespace.ANDROID, frameworkResources), configuredAppRes.rowMap());
            assert (themeStyle.startsWith("@")) : themeStyle;
            ResourceReference theme = null;
            ResourceUrl themeUrl = ResourceUrl.parse((String)themeStyle);
            if (themeUrl != null) {
                ResourceNamespace contextNamespace = (ResourceNamespace)ReadAction.compute(() -> repositoryManager.getNamespace());
                theme = themeUrl.resolve(contextNamespace, ResourceNamespace.Resolver.EMPTY_RESOLVER);
            }
            resolver = ResourceResolver.create((Map)allResources, theme);
            if (target instanceof CompatibilityRenderTarget) {
                int apiLevel = target.getVersion().getFeatureLevel();
                if (apiLevel >= 21) {
                    resolver.setDeviceDefaults("Material");
                } else if (apiLevel >= 14) {
                    resolver.setDeviceDefaults("Holo");
                } else {
                    resolver.setDeviceDefaults("");
                }
            }
            this.myResolverMap.put(resolverKey, resolver);
        }
        return resolver;
    }

    public Map<ResourceType, ResourceValueMap> getConfiguredFrameworkResources(@NotNull IAndroidTarget target, @NotNull FolderConfiguration fullConfiguration) {
        ResourceRepository resourceRepository = this.getFrameworkResources(fullConfiguration, target);
        if (resourceRepository == null) {
            return Collections.emptyMap();
        }
        String qualifierString = fullConfiguration.getQualifierString();
        Map frameworkResources = this.myFrameworkResourceMap.get(qualifierString);
        if (frameworkResources == null) {
            frameworkResources = ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)resourceRepository, (FolderConfiguration)fullConfiguration).row((Object)ResourceNamespace.ANDROID);
            this.myFrameworkResourceMap.put(qualifierString, frameworkResources);
        }
        return frameworkResources;
    }

    @NotNull
    private static String getResolverKey(@NotNull String themeStyle, @NotNull String qualifierString) {
        return qualifierString.isEmpty() ? themeStyle : themeStyle + "-" + qualifierString;
    }

    @Nullable
    public ResourceRepository getFrameworkResources(@NotNull FolderConfiguration configuration, @NotNull IAndroidTarget target) {
        String language;
        LocaleQualifier locale;
        int apiLevel = target.getVersion().getFeatureLevel();
        AndroidTargetData targetData = (AndroidTargetData)this.myFrameworkResources.get(apiLevel);
        if (targetData == null) {
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myManager.getModule());
            if (platform == null) {
                return null;
            }
            targetData = platform.getSdkData().getTargetData(target);
            this.myFrameworkResources.put(apiLevel, (Object)targetData);
        }
        if ((locale = configuration.getLocaleQualifier()) == null) {
            locale = this.myManager.getLocale().qualifier;
        }
        ImmutableSet languages2 = (language = locale.getLanguage()) == null ? ImmutableSet.of() : ImmutableSet.of((Object)language);
        return targetData.getFrameworkResources((Set<String>)languages2);
    }

    public void reset() {
        this.myCachedGeneration = 0L;
        this.myAppResourceMap.clear();
        this.myResolverMap.clear();
    }

    public void replaceCustomConfig(@NotNull String themeStyle, @NotNull FolderConfiguration fullConfiguration) {
        String qualifierString = fullConfiguration.getQualifierString();
        String newCustomResolverKey = ResourceResolverCache.getResolverKey(themeStyle, qualifierString);
        if (newCustomResolverKey.equals(this.myCustomResolverKey)) {
            return;
        }
        if (this.myCustomConfigurationKey != null) {
            this.myFrameworkResourceMap.remove(this.myCustomConfigurationKey);
            this.myAppResourceMap.remove(this.myCustomConfigurationKey);
        }
        if (this.myCustomResolverKey != null) {
            this.myResolverMap.remove(this.myCustomResolverKey);
        }
        this.myCustomConfigurationKey = qualifierString;
        this.myCustomResolverKey = newCustomResolverKey;
    }
}

