/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="AndroidLayouts", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ConfigurationStateManager
implements PersistentStateComponent<State> {
    private final Map<VirtualFile, ConfigurationFileState> myFileToState = new HashMap<VirtualFile, ConfigurationFileState>();
    private ConfigurationProjectState myProjectState = new ConfigurationProjectState();

    @NotNull
    public static ConfigurationStateManager get(@NotNull Project project) {
        return (ConfigurationStateManager)ServiceManager.getService((Project)project, ConfigurationStateManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ConfigurationFileState getConfigurationState(@NotNull VirtualFile file2) {
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            return this.myFileToState.get(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurationState(@NotNull VirtualFile file2, @NotNull ConfigurationFileState state) {
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            this.myFileToState.put(file2, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigurationState(@NotNull VirtualFile file2) {
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            this.myFileToState.remove(file2);
        }
    }

    @NotNull
    public ConfigurationProjectState getProjectState() {
        return this.myProjectState;
    }

    @VisibleForTesting
    void setProjectState(@NotNull ConfigurationProjectState projectState) {
        this.myProjectState = projectState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        HashMap<String, ConfigurationFileState> urlToState = new HashMap<String, ConfigurationFileState>();
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            for (Map.Entry<VirtualFile, ConfigurationFileState> entry : this.myFileToState.entrySet()) {
                urlToState.put(entry.getKey().getUrl(), entry.getValue());
            }
        }
        State state = new State();
        state.setUrlToStateMap(urlToState);
        state.setProjectState(this.myProjectState);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        this.myProjectState = state.getProjectState();
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            this.myFileToState.clear();
            for (Map.Entry<String, ConfigurationFileState> entry : state.getUrlToStateMap().entrySet()) {
                VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(entry.getKey());
                if (file2 == null) continue;
                this.myFileToState.put(file2, entry.getValue());
            }
        }
    }

    public static class State {
        private ConfigurationProjectState myProjectState;
        private Map<String, ConfigurationFileState> myUrlToStateMap = new HashMap<String, ConfigurationFileState>();

        @Tag(value="shared")
        @Property(surroundWithTag=false)
        public ConfigurationProjectState getProjectState() {
            return this.myProjectState;
        }

        public void setProjectState(ConfigurationProjectState projectState) {
            this.myProjectState = projectState;
        }

        @XMap(propertyElementName="layouts", keyAttributeName="url", entryTagName="layout")
        public Map<String, ConfigurationFileState> getUrlToStateMap() {
            return this.myUrlToStateMap;
        }

        public void setUrlToStateMap(Map<String, ConfigurationFileState> urlToState) {
            this.myUrlToStateMap = urlToState;
        }
    }
}

