/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.util;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NlTreeDumper {
    private final Map<NlComponent, Integer> myComponentIds;
    private final boolean myIncludeIdentity;
    private final boolean myShowBoundaries;

    public NlTreeDumper() {
        this(true, true);
    }

    public NlTreeDumper(boolean includeIdentity, boolean showBoundaries) {
        this.myComponentIds = includeIdentity ? new HashMap() : Collections.emptyMap();
        this.myIncludeIdentity = includeIdentity;
        this.myShowBoundaries = showBoundaries;
    }

    @NotNull
    public static String dumpTree(@NotNull List<NlComponent> roots) {
        return new NlTreeDumper(false, true).toTree(roots);
    }

    @NotNull
    public String toTree(@NotNull List<NlComponent> roots) {
        StringBuilder sb = new StringBuilder(200);
        for (NlComponent root2 : roots) {
            this.describe(sb, root2, 0, new HashSet<NlComponent>());
        }
        return sb.toString().trim();
    }

    private void describe(@NotNull StringBuilder sb, @NotNull NlComponent component, int depth, @NotNull HashSet<NlComponent> visited) {
        boolean isLoop = !visited.add(component);
        for (int i2 = 0; i2 < depth; ++i2) {
            sb.append("    ");
        }
        if (isLoop) {
            sb.append("!!LOOP!! ");
        }
        sb.append(this.describe(component)).append('\n');
        if (isLoop) {
            return;
        }
        for (NlComponent child : component.getChildren()) {
            this.describe(sb, child, depth + 1, visited);
        }
    }

    @NotNull
    private String describe(@NotNull NlComponent root2) {
        MoreObjects.ToStringHelper helper2 = MoreObjects.toStringHelper((Object)root2).omitNullValues().add("tag", (Object)("<" + root2.getTagName() + ">"));
        if (this.myShowBoundaries && NlComponentHelperKt.getHasNlComponentInfo(root2)) {
            helper2.add("bounds", (Object)("[" + NlComponentHelperKt.getX(root2) + "," + NlComponentHelperKt.getY(root2) + ":" + NlComponentHelperKt.getW(root2) + "x" + NlComponentHelperKt.getH(root2)));
        }
        if (this.myIncludeIdentity) {
            helper2.add("instance", this.getInstanceId(root2));
        }
        return helper2.toString();
    }

    private int getInstanceId(@NotNull NlComponent root2) {
        Integer id = this.myComponentIds.get(root2);
        if (id == null) {
            id = this.myComponentIds.size();
            this.myComponentIds.put(root2, id);
        }
        return id;
    }
}

