/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawLasso;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LassoTarget
extends BaseTarget {
    private static final boolean DEBUG_RENDERER = false;
    private float myOriginX;
    private float myOriginY;
    private float myLastX;
    private float myLastY;
    private boolean myShowRect;
    private final boolean mySelectWhileDragging;
    private final boolean myShowMargins;
    private final boolean myRecurse;
    private final HashSet<SceneComponent> myIntersectingComponents = new HashSet();
    private boolean myHasChanged;
    private boolean myHasDragged;

    public LassoTarget() {
        this(false, true, false);
    }

    public LassoTarget(boolean selectWhileDragging, boolean showMargins, boolean recurse) {
        this.mySelectWhileDragging = selectWhileDragging;
        this.myShowMargins = showMargins;
        this.myRecurse = recurse;
    }

    public boolean getSelectWhileDragging() {
        return this.mySelectWhileDragging;
    }

    public boolean getHasChanged() {
        return this.myHasChanged;
    }

    public void clearHasChanged() {
        this.myHasChanged = false;
    }

    public boolean getHasDragged() {
        return this.myHasDragged;
    }

    public HashSet<SceneComponent> getIntersectingComponents() {
        return this.myIntersectingComponents;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (this.myShowRect) {
            float x1 = Math.min(this.myOriginX, this.myLastX);
            float x2 = Math.max(this.myOriginX, this.myLastX);
            float y1 = Math.min(this.myOriginY, this.myLastY);
            float y2 = Math.max(this.myOriginY, this.myLastY);
            DrawLasso.add(list, sceneContext, x1, y1, x2, y2, this.myLastX, this.myLastY, this.myShowMargins);
        }
    }

    @Override
    protected boolean isHittable() {
        return !this.myComponent.isSelected() || !this.myComponent.isDragging();
    }

    @Override
    public int getPreferenceLevel() {
        return 10;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myOriginX = x;
        this.myOriginY = y;
        this.myLastX = x;
        this.myLastY = y;
        this.myIntersectingComponents.clear();
        this.myHasChanged = true;
        this.myHasDragged = false;
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets, @NotNull SceneContext context) {
        this.myLastX = x;
        this.myLastY = y;
        this.myShowRect = true;
        this.myHasDragged = true;
        this.fillSelectedComponents(context);
        this.myComponent.getScene().needsRebuildList();
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        this.myShowRect = false;
        this.myComponent.getScene().needsRebuildList();
    }

    private void fillSelectedComponents(@NotNull SceneContext sceneTransform) {
        float x1 = Math.min(this.myOriginX, this.myLastX);
        float x2 = Math.max(this.myOriginX, this.myLastX);
        float y1 = Math.min(this.myOriginY, this.myLastY);
        float y2 = Math.max(this.myOriginY, this.myLastY);
        if ((int)(x2 - x1) == 0 && (int)(y2 - y1) == 0) {
            return;
        }
        Rectangle bounds2 = new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
        this.fillSelectedComponents(this.myComponent, bounds2, sceneTransform);
    }

    private void fillSelectedComponents(@NotNull SceneComponent parent, @NotNull Rectangle bounds2, @NotNull SceneContext sceneTransform) {
        int count = parent.getChildCount();
        for (int i2 = 0; i2 < count; ++i2) {
            boolean contains;
            boolean intersects;
            SceneComponent component = parent.getChild(i2);
            if (this.myRecurse) {
                this.fillSelectedComponents(component, bounds2, sceneTransform);
            }
            if ((intersects = component.intersects(sceneTransform, bounds2)) == (contains = this.myIntersectingComponents.contains(component))) continue;
            this.myHasChanged = true;
            if (contains) {
                this.myIntersectingComponents.remove(component);
                continue;
            }
            this.myIntersectingComponents.add(component);
        }
    }

    @Override
    @Nullable
    public List<SceneComponent> newSelection() {
        if (this.getHasDragged()) {
            return ImmutableList.copyOf(this.getIntersectingComponents());
        }
        return null;
    }
}

