/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.model.ResourceDataManagerKt;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DnDTransferItem {
    private final boolean myFromPalette;
    private final long myModelId;
    private final ImmutableList<DnDTransferComponent> myComponents;
    private boolean myIsCut;

    public DnDTransferItem(@NotNull DnDTransferComponent component) {
        this(true, 0L, (ImmutableList<DnDTransferComponent>)ImmutableList.of((Object)component));
    }

    public DnDTransferItem(long modelId, @NotNull ImmutableList<DnDTransferComponent> components) {
        this(false, modelId, components);
    }

    private DnDTransferItem(boolean fromPalette, long modelId, @NotNull ImmutableList<DnDTransferComponent> components) {
        this.myFromPalette = fromPalette;
        this.myModelId = modelId;
        this.myComponents = components;
    }

    @Nullable
    public static DnDTransferItem getTransferItem(@NotNull Transferable transferable, boolean allowPlaceholder) {
        try {
            String xml;
            ResourceUrl url;
            DnDTransferItem item;
            if (transferable.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR)) {
                return (DnDTransferItem)transferable.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
            }
            if (transferable.isDataFlavorSupported(ResourceDataManagerKt.RESOURCE_URL_FLAVOR) && (item = DnDTransferItem.fromResourceUrl(url = (ResourceUrl)transferable.getTransferData(ResourceDataManagerKt.RESOURCE_URL_FLAVOR))) != null) {
                return item;
            }
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && !StringUtil.isEmpty((String)(xml = (String)transferable.getTransferData(DataFlavor.stringFlavor)))) {
                return new DnDTransferItem(new DnDTransferComponent("", xml, 200, 100));
            }
        }
        catch (InvalidDnDOperationException ex) {
            if (!allowPlaceholder) {
                return null;
            }
            String defaultXml = "<placeholder xmlns:android=\"http://schemas.android.com/apk/res/android\"/>";
            return new DnDTransferItem(new DnDTransferComponent("", defaultXml, 200, 100));
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Logger.getInstance(DnDTransferItem.class).warn((Throwable)ex);
        }
        return null;
    }

    @Nullable
    private static DnDTransferItem fromResourceUrl(@NotNull ResourceUrl url) {
        String tag;
        String representation;
        ResourceManagerTracking.INSTANCE.logDragOnViewGroup(url.type);
        if (url.type == ResourceType.LAYOUT) {
            representation = String.format("<include layout=\"%s\"/>", url.toString());
            tag = "include";
        } else if (url.type == ResourceType.COLOR || url.type == ResourceType.DRAWABLE || url.type == ResourceType.MIPMAP) {
            String size = url.type == ResourceType.COLOR ? "50dp" : "wrap_content";
            String xml = "<ImageView\n    android:layout_width=\"%1$s\"\n    android:layout_height=\"%1$s\"\n    android:src=\"%2$s\"/>";
            representation = String.format(xml, size, url.toString());
            tag = "ImageView";
        } else {
            return null;
        }
        return new DnDTransferItem(new DnDTransferComponent(tag, representation, 100, 100));
    }

    public boolean isFromPalette() {
        return this.myFromPalette;
    }

    public long getModelId() {
        return this.myModelId;
    }

    public void setIsCut() {
        this.myIsCut = true;
    }

    public boolean isCut() {
        return this.myIsCut;
    }

    public void consumeCut() {
        this.myIsCut = false;
    }

    public ImmutableList<DnDTransferComponent> getComponents() {
        return this.myComponents;
    }
}

