/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.command;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NlWriteCommandActionUtil {
    private NlWriteCommandActionUtil() {
    }

    public static void run(@NotNull NlComponent component, @NotNull String name, @NotNull Runnable runnable2) {
        NlWriteCommandActionUtil.run(Collections.singletonList(component), name, runnable2);
    }

    public static void run(@NotNull List<NlComponent> components, @NotNull String name, @NotNull Runnable runnable2) {
        NlWriteCommandActionUtil.run(components, name, null, runnable2);
    }

    public static void run(@NotNull List<NlComponent> components, @NotNull String name, @Nullable String groupId, @NotNull Runnable runnable2) {
        NlModel model2 = NlWriteCommandActionUtil.checkComponents(components);
        Runnable withCleanUp = () -> {
            runnable2.run();
            NlWriteCommandActionUtil.cleanUp(components);
        };
        WriteCommandAction.runWriteCommandAction((Project)model2.getProject(), (String)name, (String)groupId, (Runnable)withCleanUp, (PsiFile[])new PsiFile[]{model2.getFile()});
    }

    public static <T> T compute(@NotNull NlComponent component, @NotNull String name, @NotNull Computable<T> computable) {
        return NlWriteCommandActionUtil.compute(Collections.singletonList(component), name, computable);
    }

    public static <T> T compute(@NotNull List<NlComponent> components, @NotNull String name, @NotNull Computable<T> computable) {
        NlModel model2 = NlWriteCommandActionUtil.checkComponents(components);
        Computable withCleanUp = () -> {
            Object result2 = computable.compute();
            NlWriteCommandActionUtil.cleanUp(components);
            return result2;
        };
        return (T)WriteCommandAction.writeCommandAction((Project)model2.getProject(), (PsiFile[])new PsiFile[]{model2.getFile()}).withName(name).compute(() -> withCleanUp.compute());
    }

    @NotNull
    private static NlModel checkComponents(@NotNull List<NlComponent> components) {
        if (components.isEmpty()) {
            throw new IllegalArgumentException();
        }
        NlModel model2 = components.get(0).getModel();
        for (NlComponent component : components.subList(1, components.size())) {
            if (component.getModel() == model2) continue;
            throw new IllegalArgumentException();
        }
        return model2;
    }

    private static void cleanUp(@NotNull List<NlComponent> components) {
        components.forEach(component -> {
            NlWriteCommandActionUtil.cleanUpAttributes(component);
            component.getBackend().reformatAndRearrange();
        });
    }

    private static void cleanUpAttributes(@NotNull NlComponent component) {
        Project project = component.getModel().getProject();
        ViewGroupHandler handler2 = ViewHandlerManager.get(project).findLayoutHandler(component, true);
        if (handler2 == null) {
            return;
        }
        AttributesTransaction transaction = component.startAttributeTransaction();
        handler2.cleanUpAttributes(component, transaction);
        transaction.commit();
    }
}

