/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.emulator.SnapshotProtoException;
import com.android.emulator.SnapshotProtoParser;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.resources.Keyboard;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdNetworkLatency;
import com.android.sdklib.internal.avd.AvdNetworkSpeed;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.avdmanager.AvdConfigurationOptionHelpPanel;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdNameVerifier;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.ChooseDeviceDefinitionPanel;
import com.android.tools.idea.avdmanager.ChooseSystemImagePanel;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.EmulatorAdvFeatures;
import com.android.tools.idea.avdmanager.SkinChooser;
import com.android.tools.idea.avdmanager.StorageField;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.string.StringExpression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.ui.wizard.deprecated.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAvdOptionsStep
extends ModelWizardStep<AvdOptionsModel> {
    private static final String ADVANCED_SETTINGS = "Advanced Settings";
    private static final String SHOW = "Show Advanced Settings";
    private static final String HIDE = "Hide Advanced Settings";
    private static final String FOCUS_OWNER = "focusOwner";
    private static final Map<ScreenOrientation, NamedIcon> ORIENTATIONS = ImmutableMap.of((Object)ScreenOrientation.PORTRAIT, (Object)new NamedIcon("Portrait", StudioIcons.Avd.PORTRAIT), (Object)ScreenOrientation.LANDSCAPE, (Object)new NamedIcon("Landscape", StudioIcons.Avd.LANDSCAPE));
    final AvdManagerConnection connection;
    private JPanel myRoot;
    private ValidatorPanel myValidatorPanel;
    private StudioWizardStepPanel myStudioWizardStepPanel;
    private AvdConfigurationOptionHelpPanel myAvdConfigurationOptionHelpPanel;
    private JBScrollPane myScrollPane;
    private JBLabel myAvdId;
    private JBLabel myRamLabel;
    private JLabel myAvdIdLabel;
    private JBLabel mySpeedLabel;
    private JBLabel myDeviceName;
    private JBLabel myVmHeapLabel;
    private JBLabel mySdCardLabel;
    private JBLabel myCameraLabel;
    private JBLabel myNetworkLabel;
    private JBLabel myLatencyLabel;
    private JBLabel myKeyboardLabel;
    private JBLabel myDeviceDetails;
    private JBLabel myBackCameraLabel;
    private JBLabel mySystemImageName;
    private JBLabel myFrontCameraLabel;
    private JBLabel mySystemImageDetails;
    private JBLabel mySkinDefinitionLabel;
    private JBLabel myInternalStorageLabel;
    private JBLabel myMemoryAndStorageLabel;
    private HyperlinkLabel myHardwareSkinHelpLabel;
    private JComboBox myCoreCount;
    private JComboBox mySpeedCombo;
    private JComboBox myLatencyCombo;
    private SkinChooser mySkinComboBox;
    private JComboBox myBackCameraCombo;
    private JComboBox myFrontCameraCombo;
    private JCheckBox myQemu2CheckBox;
    private JCheckBox myDeviceFrameCheckbox;
    private JCheckBox myEnableComputerKeyboard;
    private StorageField myRamStorage;
    private StorageField myVmHeapStorage;
    private StorageField myInternalStorage;
    private StorageField myBuiltInSdCardStorage;
    private JRadioButton myBuiltInRadioButton;
    private JRadioButton myExternalRadioButton;
    private JRadioButton myNoSDCardRadioButton;
    private ASGallery<ScreenOrientation> myOrientationToggle;
    private JButton myChangeDeviceButton;
    private JButton myChangeSystemImageButton;
    private JButton myShowAdvancedSettingsButton;
    private TextFieldWithBrowseButton myExternalSdCard;
    private JTextField myAvdDisplayName;
    private JBLabel myOrientationLabel;
    private JComboBox myHostGraphics;
    private JPanel myDevicePanel;
    private JPanel myAvdNamePanel;
    private JPanel myImagePanel;
    private JPanel myOrientationPanel;
    private JPanel myCameraPanel;
    private JPanel myNetworkPanel;
    private JPanel myPerformancePanel;
    private JPanel myStoragePanel;
    private JPanel myFramePanel;
    private JPanel myKeyboardPanel;
    private JPanel myQemu2Panel;
    private JPanel myAvdIdRow;
    private JPanel myCustomSkinPanel;
    private JPanel myScrollRootPane;
    private JPanel myBootOptionPanel;
    private JRadioButton myColdBootRadioButton;
    private JRadioButton myFastBootRadioButton;
    private JRadioButton myChooseBootRadioButton;
    private JComboBox myChosenSnapshotComboBox;
    private JBLabel myDeviceFrameTitle;
    private Iterable<JComponent> myAdvancedOptionsComponents;
    private Project myProject;
    private BindingsManager myBindings;
    private ListenerManager myListeners;
    private String myOriginalName;
    private Storage myOriginalSdCard;
    private int mySelectedCoreCount;
    private AvdOptionsModel myModel;
    @NotNull
    private String mySelectedSnapshotFileName;
    private ArrayList<SnapshotListItem> mySnapshotList;
    private final ActionListener myToggleAdvancedSettingsListener;
    private final ItemListener mySnapshotComboListener;
    private ActionListener myChangeSystemImageButtonListener;
    private ActionListener myChangeDeviceButtonListener;
    private PropertyChangeListener myPropertyChangeListener;

    public ConfigureAvdOptionsStep(@Nullable Project project, @NotNull AvdOptionsModel model2) {
        super(model2, "Android Virtual Device (AVD)");
        this.$$$setupUI$$$();
        this.connection = AvdManagerConnection.getDefaultAvdManagerConnection();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.mySelectedSnapshotFileName = "";
        this.myToggleAdvancedSettingsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureAvdOptionsStep.this.isAdvancedPanel()) {
                    ConfigureAvdOptionsStep.this.myShowAdvancedSettingsButton.setText(ConfigureAvdOptionsStep.SHOW);
                    ConfigureAvdOptionsStep.this.setAdvanceSettingsVisible(false);
                } else {
                    ConfigureAvdOptionsStep.this.myShowAdvancedSettingsButton.setText(ConfigureAvdOptionsStep.HIDE);
                    ConfigureAvdOptionsStep.this.setAdvanceSettingsVisible(true);
                }
            }
        };
        this.mySnapshotComboListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                if (ConfigureAvdOptionsStep.this.myChosenSnapshotComboBox.getSelectedIndex() != ConfigureAvdOptionsStep.this.myChosenSnapshotComboBox.getItemCount() - 1) {
                    ConfigureAvdOptionsStep.this.mySelectedSnapshotFileName = ((SnapshotListItem)((ConfigureAvdOptionsStep)ConfigureAvdOptionsStep.this).mySnapshotList.get((int)((ConfigureAvdOptionsStep)ConfigureAvdOptionsStep.this).myChosenSnapshotComboBox.getSelectedIndex())).fileName;
                    ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).chosenSnapshotFile().set(ConfigureAvdOptionsStep.this.mySelectedSnapshotFileName);
                    ConfigureAvdOptionsStep.this.myChooseBootRadioButton.setSelected(true);
                    return;
                }
                this.invokeEmulatorSnapshotControl();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void invokeEmulatorSnapshotControl() {
                File emuOutputFile;
                File paramFile;
                File tempDir;
                block9: {
                    block8: {
                        tempDir = null;
                        paramFile = null;
                        emuOutputFile = null;
                        try {
                            tempDir = AvdManagerConnection.tempFileDirectory();
                            if (tempDir != null) break block8;
                            this.deleteTempFile(emuOutputFile, "Could not delete temporary emulator snapshot output file ");
                            this.deleteTempFile(paramFile, "Could not delete temporary emulator snapshot parameter file ");
                            this.deleteTempFile(tempDir, "Could not delete temporary emulator snapshot directory ");
                            return;
                        }
                        catch (Throwable throwable) {
                            this.deleteTempFile(emuOutputFile, "Could not delete temporary emulator snapshot output file ");
                            this.deleteTempFile(paramFile, "Could not delete temporary emulator snapshot parameter file ");
                            this.deleteTempFile(tempDir, "Could not delete temporary emulator snapshot directory ");
                            throw throwable;
                        }
                    }
                    try {
                        emuOutputFile = File.createTempFile("emu_output_", ".tmp", tempDir);
                        String emuOutputFileInfo = "snapshotTempFile=" + emuOutputFile.getAbsolutePath();
                        paramFile = AvdManagerConnection.writeTempFile(Collections.singletonList(emuOutputFileInfo));
                    }
                    catch (IOException ioEx) {
                        Logger.getInstance(ConfigureAvdOptionsStep.class).info("Could not write temporary file to " + tempDir.getAbsolutePath(), (Throwable)ioEx);
                        this.deleteTempFile(emuOutputFile, "Could not delete temporary emulator snapshot output file ");
                        this.deleteTempFile(paramFile, "Could not delete temporary emulator snapshot parameter file ");
                        this.deleteTempFile(tempDir, "Could not delete temporary emulator snapshot directory ");
                        return;
                    }
                    if (paramFile != null) break block9;
                    this.deleteTempFile(emuOutputFile, "Could not delete temporary emulator snapshot output file ");
                    this.deleteTempFile(paramFile, "Could not delete temporary emulator snapshot parameter file ");
                    this.deleteTempFile(tempDir, "Could not delete temporary emulator snapshot directory ");
                    return;
                }
                if (this.launchEmulatorForSnapshotControl(paramFile)) {
                    this.readEmulatorSnapshotSelection(emuOutputFile);
                }
                ConfigureAvdOptionsStep.this.populateSnapshotList();
                ConfigureAvdOptionsStep.this.refreshSnapshotPulldown();
                this.deleteTempFile(emuOutputFile, "Could not delete temporary emulator snapshot output file ");
                this.deleteTempFile(paramFile, "Could not delete temporary emulator snapshot parameter file ");
                this.deleteTempFile(tempDir, "Could not delete temporary emulator snapshot directory ");
            }

            private boolean launchEmulatorForSnapshotControl(@NotNull File paramFileForEmulator) {
                int exitValue;
                File emulatorBinary = ConfigureAvdOptionsStep.this.connection.getEmulatorBinary();
                if (emulatorBinary == null) {
                    return false;
                }
                GeneralCommandLine commandLine = new GeneralCommandLine();
                commandLine.setExePath(emulatorBinary.getPath());
                commandLine.addParameter("@" + ConfigureAvdOptionsStep.this.myAvdId.getText());
                commandLine.addParameters(new String[]{"-ui-only", "snapshot-control"});
                commandLine.addParameters(new String[]{"-studio-params", paramFileForEmulator.getAbsolutePath()});
                try {
                    CapturingProcessHandler process = new CapturingProcessHandler(commandLine);
                    ProcessOutput output = process.runProcess();
                    exitValue = output.getExitCode();
                }
                catch (ExecutionException execEx) {
                    Logger.getInstance(ConfigureAvdOptionsStep.class).info("Could not launch emulator for snapshot control", (Throwable)execEx);
                    return false;
                }
                return exitValue == 0;
            }

            private void readEmulatorSnapshotSelection(@NotNull File fileToRead) {
                try (FileInputStream inputStream = new FileInputStream(fileToRead);
                     InputStreamReader streamReader = new InputStreamReader(inputStream);
                     BufferedReader reader = new BufferedReader(streamReader);){
                    String inputLine;
                    String keyString = "selectedSnapshotFile=";
                    while ((inputLine = reader.readLine()) != null) {
                        if (!inputLine.startsWith("selectedSnapshotFile=")) continue;
                        String responseName = inputLine.substring("selectedSnapshotFile=".length());
                        if (!responseName.isEmpty()) {
                            ConfigureAvdOptionsStep.this.mySelectedSnapshotFileName = responseName;
                            ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).chosenSnapshotFile().set(ConfigureAvdOptionsStep.this.mySelectedSnapshotFileName);
                        }
                        break;
                    }
                }
                catch (IOException ioEx) {
                    Logger.getInstance(ConfigureAvdOptionsStep.class).info("Could not read snapshot selection from emulator", (Throwable)ioEx);
                }
            }

            private void deleteTempFile(@Nullable File fileToDelete, @NotNull String errorString) {
                if (fileToDelete == null) {
                    return;
                }
                try {
                    if (!fileToDelete.delete()) {
                        Logger.getInstance(ConfigureAvdOptionsStep.class).warn(errorString + fileToDelete.getAbsolutePath());
                    }
                }
                catch (Exception deleteEx) {
                    Logger.getInstance(ConfigureAvdOptionsStep.class).warn(errorString + fileToDelete.getAbsolutePath(), (Throwable)deleteEx);
                }
            }
        };
        this.myChangeSystemImageButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ChooseSystemImagePanel chooseImagePanel = new ChooseSystemImagePanel(ConfigureAvdOptionsStep.this.myProject, ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().getValueOrNull(), ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().getValueOrNull());
                DialogWrapper dialog2 = new DialogWrapper(ConfigureAvdOptionsStep.this.myProject){
                    {
                        super(x0);
                        this.setTitle("Select a System Image");
                        this.init();
                        chooseImagePanel.addSystemImageListener(new Consumer<SystemImageDescription>(){

                            public void consume(SystemImageDescription systemImage) {
                                this.setOKActionEnabled(systemImage != null);
                            }
                        });
                    }

                    @Nullable
                    protected JComponent createCenterPanel() {
                        return chooseImagePanel;
                    }
                };
                if (dialog2.showAndGet()) {
                    SystemImageDescription image = chooseImagePanel.getSystemImage();
                    if (image != null) {
                        ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().setValue(image);
                    }
                    ConfigureAvdOptionsStep.this.myModel.ensureMinimumMemory();
                    ConfigureAvdOptionsStep.this.myOriginalSdCard = ConfigureAvdOptionsStep.this.myModel.sdCardStorage().getValue();
                }
            }
        };
        this.myChangeDeviceButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ChooseDeviceDefinitionPanel chooseDevicePanel = new ChooseDeviceDefinitionPanel(((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().getValueOrNull());
                DialogWrapper dialog2 = new DialogWrapper(ConfigureAvdOptionsStep.this.myProject){
                    {
                        super(x0);
                        this.setTitle("Select a Device");
                        this.init();
                        chooseDevicePanel.addDeviceListener(new Consumer<Device>(){

                            public void consume(Device device) {
                                this.setOKActionEnabled(device != null);
                            }
                        });
                    }

                    @Nullable
                    protected JComponent createCenterPanel() {
                        return chooseDevicePanel;
                    }
                };
                if (dialog2.showAndGet()) {
                    ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().setNullableValue(chooseDevicePanel.getDevice());
                }
            }
        };
        this.myPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value2 = evt.getNewValue();
                if (evt.getNewValue() instanceof JComponent) {
                    JComponent component = (JComponent)value2;
                    if (component.getToolTipText() != null) {
                        ConfigureAvdOptionsStep.this.myAvdConfigurationOptionHelpPanel.setValues(component);
                    } else if (component.getParent() instanceof JComponent) {
                        JComponent parent = (JComponent)component.getParent();
                        if (parent.getToolTipText() != null) {
                            ConfigureAvdOptionsStep.this.myAvdConfigurationOptionHelpPanel.setValues(parent);
                        } else {
                            ConfigureAvdOptionsStep.this.myAvdConfigurationOptionHelpPanel.clearValues();
                        }
                    }
                }
            }
        };
        this.myModel = model2;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRoot);
        this.myStudioWizardStepPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, "Verify Configuration");
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myStudioWizardStepPanel);
        this.myOrientationToggle.setOpaque(false);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myProject = project;
        this.registerAdvancedOptionsVisibility();
        this.myShowAdvancedSettingsButton.setText(SHOW);
        this.setAdvanceSettingsVisible(false);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.initCpuCoreDropDown();
        this.mySelectedSnapshotFileName = (String)((AvdOptionsModel)this.getModel()).chosenSnapshotFile().get();
        this.populateSnapshotList();
        this.refreshSnapshotPulldown();
        this.myChosenSnapshotComboBox.addItemListener(this.mySnapshotComboListener);
        boolean supportsVirtualCamera = EmulatorAdvFeatures.emulatorSupportsVirtualScene(AndroidSdks.getInstance().tryToChooseSdkHandler(), (ProgressIndicator)new StudioLoggerProgressIndicator(ConfigureAvdOptionsStep.class), (ILogger)new LogWrapper(Logger.getInstance(AvdManagerConnection.class)));
        ConfigureAvdOptionsStep.setupCameraComboBox(this.myFrontCameraCombo, false);
        ConfigureAvdOptionsStep.setupCameraComboBox(this.myBackCameraCombo, supportsVirtualCamera);
        this.mySpeedCombo.setModel(new DefaultComboBoxModel<AvdNetworkSpeed>(AvdNetworkSpeed.values()));
        this.myLatencyCombo.setModel(new DefaultComboBoxModel<AvdNetworkLatency>(AvdNetworkLatency.values()));
    }

    private static void setupCameraComboBox(JComboBox comboBox, boolean withVirtualScene) {
        AvdCamera[] allCameras = AvdCamera.values();
        if (!withVirtualScene) {
            ArrayList<AvdCamera> allCamerasButVirtualSceneList = new ArrayList<AvdCamera>(Arrays.asList(allCameras));
            allCamerasButVirtualSceneList.remove(AvdCamera.VIRTUAL_SCENE);
            comboBox.setModel(new DefaultComboBoxModel<Object>(allCamerasButVirtualSceneList.toArray()));
        } else {
            comboBox.setModel(new DefaultComboBoxModel<AvdCamera>(allCameras));
        }
        comboBox.setToolTipText("<html>None - no camera installed for AVD<br>" + (withVirtualScene ? "VirtualScene - use a virtual camera in a simulated environment<br>" : "") + "Emulated - use a simulated camera<br>Device - use host computer webcam or built-in camera</html>");
    }

    private void initCpuCoreDropDown() {
        for (int core = 1; core <= EmulatedProperties.MAX_NUMBER_OF_CORES; ++core) {
            this.myCoreCount.addItem(core);
        }
    }

    @NotNull
    public List<String> getSnapshotNamesList(@NotNull String selectedSnapshotFileName) {
        this.mySelectedSnapshotFileName = selectedSnapshotFileName;
        this.populateSnapshotList();
        ArrayList<String> nameList = new ArrayList<String>();
        this.mySnapshotList.forEach(item -> nameList.add(item.fileName));
        return nameList;
    }

    private void populateSnapshotList() {
        this.mySnapshotList = new ArrayList();
        if (this.myModel == null) {
            return;
        }
        String avdDirPath = this.myModel.getAvdLocation();
        if (avdDirPath == null) {
            return;
        }
        File avdDir = new File(avdDirPath);
        if (!avdDir.isDirectory()) {
            return;
        }
        File snapshotBaseDir = new File(avdDir, "snapshots");
        File[] possibleSnapshotDirs = snapshotBaseDir.listFiles();
        if (possibleSnapshotDirs == null) {
            return;
        }
        for (File snapshotDir : possibleSnapshotDirs) {
            String snapshotFileName;
            File snapshotProtoBuf;
            if (!snapshotDir.isDirectory() || !(snapshotProtoBuf = new File(snapshotDir, "snapshot.pb")).exists() || "default_boot".equals(snapshotFileName = snapshotDir.getName())) continue;
            try {
                SnapshotProtoParser protoParser = new SnapshotProtoParser(snapshotProtoBuf, snapshotFileName);
                String logicalName = protoParser.getLogicalName();
                if (logicalName.isEmpty()) continue;
                this.mySnapshotList.add(new SnapshotListItem(snapshotFileName, logicalName, protoParser.getCreationTime()));
            }
            catch (SnapshotProtoException ssException) {
                Logger.getInstance(ConfigureAvdOptionsStep.class).info("Could not parse Snapshot protobuf: " + snapshotFileName, (Throwable)ssException);
            }
        }
        Collections.sort(this.mySnapshotList);
    }

    private void refreshSnapshotPulldown() {
        if (!AvdWizardUtils.emulatorSupportsSnapshotManagement(AndroidSdks.getInstance().tryToChooseSdkHandler())) {
            if (((Boolean)((AvdOptionsModel)this.getModel()).useChosenSnapshotBoot().get()).booleanValue()) {
                ((AvdOptionsModel)this.getModel()).useChosenSnapshotBoot().set(false);
                ((AvdOptionsModel)this.getModel()).useFastBoot().set(true);
            }
            this.myChosenSnapshotComboBox.setVisible(false);
            this.myChooseBootRadioButton.setVisible(false);
            return;
        }
        CollectionComboBoxModel snapshotModel = new CollectionComboBoxModel();
        this.mySnapshotList.stream().limit(3L).forEach(item -> snapshotModel.add((Object)item.logicalName));
        int numNotShown = this.mySnapshotList.size() - snapshotModel.getSize();
        String finalLine = this.mySnapshotList.isEmpty() ? "(no snapshots)" : (numNotShown == 0 ? "  Details ..." : String.format(Locale.US, "  Details ... (+%d others)", numNotShown));
        snapshotModel.add((Object)finalLine);
        this.myChosenSnapshotComboBox.setModel(snapshotModel);
        this.myChosenSnapshotComboBox.setSelectedIndex(0);
        if (this.mySnapshotList.isEmpty()) {
            this.mySelectedSnapshotFileName = "";
            this.myChosenSnapshotComboBox.setEnabled(false);
            this.myChooseBootRadioButton.setEnabled(false);
            if (((Boolean)((AvdOptionsModel)this.getModel()).useChosenSnapshotBoot().get()).booleanValue()) {
                ((AvdOptionsModel)this.getModel()).useChosenSnapshotBoot().set(false);
                ((AvdOptionsModel)this.getModel()).useFastBoot().set(true);
            }
        } else {
            boolean previousSelectionExists = this.mySelectedSnapshotFileName.equals(this.mySnapshotList.get((int)0).fileName);
            this.mySelectedSnapshotFileName = this.mySnapshotList.get((int)0).fileName;
            this.myChosenSnapshotComboBox.setEnabled(true);
            this.myChooseBootRadioButton.setEnabled(true);
            if (((Boolean)((AvdOptionsModel)this.getModel()).useChosenSnapshotBoot().get()).booleanValue() && !previousSelectionExists) {
                ((AvdOptionsModel)this.getModel()).useChosenSnapshotBoot().set(false);
                ((AvdOptionsModel)this.getModel()).useColdBoot().set(true);
                ((AvdOptionsModel)this.getModel()).chosenSnapshotFile().set(this.mySelectedSnapshotFileName);
            }
        }
    }

    private void populateHostGraphicsDropDown() {
        this.myHostGraphics.removeAllItems();
        GpuMode otherMode = ConfigureAvdOptionsStep.gpuOtherMode(this.getSelectedApiLevel(), this.isIntel(), this.isGoogleApiSelected(), SystemInfo.isMac);
        this.myHostGraphics.addItem(GpuMode.AUTO);
        this.myHostGraphics.addItem(GpuMode.HOST);
        this.myHostGraphics.addItem(otherMode);
    }

    @VisibleForTesting
    static GpuMode gpuOtherMode(int apiLevel, boolean isIntel, boolean isGoogle, boolean isMac) {
        boolean supportGuest = apiLevel >= 23 && isIntel && isGoogle;
        GpuMode otherMode = GpuMode.OFF;
        if (supportGuest) {
            otherMode = GpuMode.SWIFT;
        }
        return otherMode;
    }

    private void updateGpuControlsAfterSystemImageChange() {
        GpuMode mode = ((AvdOptionsModel)this.getModel()).hostGpuMode().getValueOr(GpuMode.AUTO);
        this.populateHostGraphicsDropDown();
        switch (mode) {
            case AUTO: {
                this.myHostGraphics.setSelectedIndex(0);
                break;
            }
            case HOST: {
                this.myHostGraphics.setSelectedIndex(1);
                break;
            }
            default: {
                this.myHostGraphics.setSelectedIndex(2);
            }
        }
    }

    private boolean isGoogleApiSelected() {
        assert (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent());
        SystemImageDescription systemImage = ((AvdOptionsModel)this.getModel()).systemImage().getValue();
        return ConfigureAvdOptionsStep.isGoogleApiTag(systemImage.getTag());
    }

    @VisibleForTesting
    static boolean isGoogleApiTag(IdDisplay tag) {
        return SystemImage.WEAR_TAG.equals((Object)tag) || SystemImage.TV_TAG.equals((Object)tag) || SystemImage.GOOGLE_APIS_TAG.equals((Object)tag);
    }

    private boolean isIntel() {
        return this.supportsMultipleCpuCores();
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        this.addTitles();
        this.addListeners();
        this.addValidators();
        this.bindComponents();
        this.initComponents();
    }

    @Override
    protected void onEntering() {
        this.updateComponents();
        this.myShowAdvancedSettingsButton.setText(SHOW);
        this.setAdvanceSettingsVisible(false);
        this.toggleOptionals((Optional)((AvdOptionsModel)this.getModel()).device().get(), false);
        if (((Boolean)((AvdOptionsModel)this.getModel()).useExternalSdCard().get()).booleanValue()) {
            this.myBuiltInSdCardStorage.setEnabled(false);
            this.myExternalSdCard.setEnabled(true);
        } else if (((Boolean)((AvdOptionsModel)this.getModel()).useBuiltInSdCard().get()).booleanValue()) {
            this.myBuiltInSdCardStorage.setEnabled(true);
            this.myExternalSdCard.setEnabled(false);
        } else {
            this.myExternalSdCard.setEnabled(false);
            this.myBuiltInSdCardStorage.setEnabled(false);
        }
        this.myModel.ensureMinimumMemory();
        this.myOriginalSdCard = this.myModel.sdCardStorage().getValue();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    private void addTitles() {
        this.myAvdId.putClientProperty((Object)"TITLE", (Object)"AVD Id");
        this.myRamStorage.putClientProperty("TITLE", "Device RAM");
        this.myAvdDisplayName.putClientProperty("TITLE", "AVD Name");
        this.myCoreCount.putClientProperty("TITLE", "Number of cores");
        this.mySpeedCombo.putClientProperty("TITLE", "Network Speed");
        this.myBackCameraCombo.putClientProperty("TITLE", "Back Camera");
        this.myLatencyCombo.putClientProperty("TITLE", "Network Latency");
        this.myFrontCameraCombo.putClientProperty("TITLE", "Front Camera");
        this.myQemu2CheckBox.putClientProperty("TITLE", "Number of cores");
        this.myInternalStorage.putClientProperty("TITLE", "Internal Flash");
        this.myHostGraphics.putClientProperty("TITLE", "Graphics Rendering");
        this.myBootOptionPanel.putClientProperty("TITLE", "Boot Option");
        this.myColdBootRadioButton.putClientProperty("TITLE", "Boot Option");
        this.myFastBootRadioButton.putClientProperty("TITLE", "Boot Option");
        this.myChooseBootRadioButton.putClientProperty("TITLE", "Boot Option");
        this.myChosenSnapshotComboBox.putClientProperty("TITLE", "Boot Option");
        this.mySkinComboBox.putClientProperty("TITLE", "Custom Device Frame");
        this.myVmHeapStorage.putClientProperty("TITLE", "Virtual Machine Heap");
        this.myOrientationToggle.putClientProperty((Object)"TITLE", (Object)"Default Orientation");
        this.myBuiltInSdCardStorage.putClientProperty("TITLE", "Built-in SD Card Size");
        this.myDeviceFrameCheckbox.putClientProperty("TITLE", "Enable device frame");
        this.myBuiltInRadioButton.putClientProperty("TITLE", "Built-in SD Card Size");
        this.myEnableComputerKeyboard.putClientProperty("TITLE", "Enable keyboard input");
        this.myExternalSdCard.putClientProperty((Object)"TITLE", (Object)"Location of external SD Card image");
        this.myExternalRadioButton.putClientProperty("TITLE", "Location of external SD Card image");
        this.myNoSDCardRadioButton.putClientProperty("TITLE", "No SD Card");
    }

    private void initComponents() {
        this.myCoreCount.setPreferredSize(this.myRamStorage.getPreferredSizeOfUnitsDropdown());
        this.setAdvanceSettingsVisible(false);
        this.myAvdIdLabel.setLabelFor((Component)this.myAvdId);
        this.myDeviceDetails.setLabelFor((Component)this.myDeviceName);
        this.mySystemImageDetails.setLabelFor((Component)this.mySystemImageName);
        this.myOrientationLabel.setLabelFor(this.myOrientationToggle);
        this.myRamLabel.setLabelFor((Component)this.myRamStorage);
    }

    private void updateComponents() {
        this.myAvdConfigurationOptionHelpPanel.setSystemImageDescription(((AvdOptionsModel)this.getModel()).systemImage().getValueOrNull());
        this.myOrientationToggle.setSelectedElement(((AvdOptionsModel)this.getModel()).selectedAvdOrientation().get());
        if (!((Boolean)((AvdOptionsModel)this.getModel()).isInEditMode().get()).booleanValue() && ((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent() && ((Optional)((AvdOptionsModel)this.getModel()).device().get()).isPresent()) {
            String avdDisplayName = AvdNameVerifier.stripBadCharacters(((AvdOptionsModel)this.getModel()).device().getValue().getDisplayName());
            ((AvdOptionsModel)this.getModel()).avdDisplayName().set(this.connection.uniquifyDisplayName(String.format(Locale.getDefault(), "%1$s API %2$s", avdDisplayName, this.getSelectedApiString())));
        }
        this.myOriginalName = (Boolean)((AvdOptionsModel)this.getModel()).isInEditMode().get() != false ? (String)((AvdOptionsModel)this.getModel()).avdDisplayName().get() : "";
        this.updateSystemImageData();
        this.mySelectedCoreCount = (Boolean)((AvdOptionsModel)this.getModel()).useQemu2().get() != false ? ((AvdOptionsModel)this.getModel()).cpuCoreCount().getValueOr(1) : EmulatedProperties.RECOMMENDED_NUMBER_OF_CORES;
    }

    @VisibleForTesting
    void addListeners() {
        this.myAvdId.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigureAvdOptionsStep.this.myAvdId.requestFocusInWindow();
            }
        });
        this.myShowAdvancedSettingsButton.addActionListener(this.myToggleAdvancedSettingsListener);
        this.myChangeDeviceButton.addActionListener(this.myChangeDeviceButtonListener);
        this.myChangeSystemImageButton.addActionListener(this.myChangeSystemImageButtonListener);
        this.myExternalRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureAvdOptionsStep.this.myExternalSdCard.setEnabled(true);
                ConfigureAvdOptionsStep.this.myBuiltInSdCardStorage.setEnabled(false);
            }
        });
        this.myBuiltInRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureAvdOptionsStep.this.myExternalSdCard.setEnabled(false);
                ConfigureAvdOptionsStep.this.myBuiltInSdCardStorage.setEnabled(true);
            }
        });
        this.myNoSDCardRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureAvdOptionsStep.this.myExternalSdCard.setEnabled(false);
                ConfigureAvdOptionsStep.this.myBuiltInSdCardStorage.setEnabled(false);
            }
        });
        this.myOrientationToggle.setOpaque(false);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(FOCUS_OWNER, this.myPropertyChangeListener);
        this.myListeners.listen(((AvdOptionsModel)this.getModel()).device(), device -> {
            this.toggleOptionals((Optional<Device>)device, true);
            if (device.isPresent()) {
                this.myDeviceName.setIcon(DeviceDefinitionPreview.getIcon(((AvdOptionsModel)this.getModel()).getAvdDeviceData()));
                this.myDeviceName.setText(((AvdOptionsModel)this.getModel()).device().getValue().getDisplayName());
                this.updateDeviceDetails();
            }
        });
        List<AbstractProperty<?>> deviceProperties = AbstractProperty.getAll(((AvdOptionsModel)this.getModel()).getAvdDeviceData());
        deviceProperties.add(((AvdOptionsModel)this.getModel()).systemImage());
        this.myListeners.listenAll(deviceProperties).with(new Runnable(){

            @Override
            public void run() {
                if (((Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().get()).isPresent() && ((Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).getAvdDeviceData().customSkinFile().get()).isPresent()) {
                    File skin = AvdWizardUtils.pathToUpdatedSkins(((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).getAvdDeviceData().customSkinFile().getValue(), ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().getValue(), FileOpUtils.create());
                    if (skin != null) {
                        ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).getAvdDeviceData().customSkinFile().setValue(skin);
                        if (FileUtil.filesEqual((File)skin, (File)AvdWizardUtils.NO_SKIN)) {
                            ConfigureAvdOptionsStep.this.myDeviceFrameCheckbox.setSelected(false);
                        } else {
                            ConfigureAvdOptionsStep.this.myDeviceFrameCheckbox.setSelected(true);
                        }
                    } else {
                        ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).getAvdDeviceData().customSkinFile().setValue(AvdWizardUtils.NO_SKIN);
                        ConfigureAvdOptionsStep.this.myDeviceFrameCheckbox.setSelected(false);
                    }
                }
                Device device = ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().getValueOrNull();
                boolean enabled = true;
                if (device != null && device.getDefaultHardware().getScreen().isFoldable()) {
                    enabled = false;
                    ConfigureAvdOptionsStep.this.myDeviceFrameCheckbox.setSelected(false);
                }
                ConfigureAvdOptionsStep.this.myDeviceFrameCheckbox.setEnabled(enabled);
                ConfigureAvdOptionsStep.this.myDeviceFrameTitle.setEnabled(enabled);
                ConfigureAvdOptionsStep.this.mySkinDefinitionLabel.setEnabled(enabled);
                ConfigureAvdOptionsStep.this.mySkinComboBox.setEnabled(enabled);
            }
        });
        this.myListeners.listen(((AvdOptionsModel)this.getModel()).systemImage(), () -> this.updateSystemImageData());
        this.myListeners.listen(((AvdOptionsModel)this.getModel()).useQemu2(), () -> this.toggleSystemOptionals(true));
        this.myListeners.listen(((AvdOptionsModel)this.getModel()).selectedAvdOrientation(), screenOrientation -> this.myOrientationToggle.setSelectedElement(screenOrientation));
    }

    @VisibleForTesting
    void updateSystemImageData() {
        if (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent()) {
            SystemImageDescription image = ((AvdOptionsModel)this.getModel()).systemImage().getValue();
            String codeName = SdkVersionInfo.getCodeName((int)image.getVersion().getFeatureLevel());
            String displayName = codeName;
            if (displayName == null) {
                displayName = image.getVersion().getCodename();
            }
            if (displayName == null) {
                displayName = "";
            }
            ((AvdOptionsModel)this.getModel()).systemImageName().set(displayName);
            Icon icon2 = null;
            try {
                icon2 = IconLoader.findIcon((String)String.format("/icons/versions/%s_32.png", codeName), AndroidIcons.class);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (icon2 == null) {
                try {
                    icon2 = IconLoader.findIcon((String)"/icons/versions/Default_32.png", AndroidIcons.class);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            this.mySystemImageName.setIcon(icon2);
            ((AvdOptionsModel)this.getModel()).systemImageDetails().set(image.getName() + " " + image.getAbiType());
            this.myAvdConfigurationOptionHelpPanel.setSystemImageDescription(image);
            this.updateGpuControlsAfterSystemImageChange();
            this.toggleSystemOptionals(false);
        }
    }

    @VisibleForTesting
    JBLabel getDeviceFrameTitle() {
        return this.myDeviceFrameTitle;
    }

    @VisibleForTesting
    JCheckBox getDeviceFrameCheckbox() {
        return this.myDeviceFrameCheckbox;
    }

    @VisibleForTesting
    JBLabel getSkinDefinitionLabel() {
        return this.mySkinDefinitionLabel;
    }

    @VisibleForTesting
    SkinChooser getSkinComboBox() {
        return this.mySkinComboBox;
    }

    @VisibleForTesting
    @Nullable
    Icon getSystemImageIcon() {
        return this.mySystemImageName == null ? null : this.mySystemImageName.getIcon();
    }

    private void bindComponents() {
        this.myBindings.bindTwoWay(new TextProperty(this.myAvdDisplayName), ((AvdOptionsModel)this.getModel()).avdDisplayName());
        this.myBindings.bind(new TextProperty((JLabel)this.myAvdId), new StringExpression(new ObservableValue[]{((AvdOptionsModel)this.getModel()).avdDisplayName()}){

            @Override
            @NotNull
            public String get() {
                String displayName = (String)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).avdDisplayName().get();
                ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).avdId().set(StringUtil.isNotEmpty((String)displayName) ? AvdWizardUtils.cleanAvdName(ConfigureAvdOptionsStep.this.connection, displayName, !displayName.equals(ConfigureAvdOptionsStep.this.myOriginalName)) : "");
                return (String)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).avdId().get();
            }
        });
        this.myBindings.bindTwoWay(new TextProperty((JLabel)this.mySystemImageName), ((AvdOptionsModel)this.getModel()).systemImageName());
        this.myBindings.bindTwoWay(new TextProperty((JLabel)this.mySystemImageDetails), ((AvdOptionsModel)this.getModel()).systemImageDetails());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myQemu2CheckBox), ((AvdOptionsModel)this.getModel()).useQemu2());
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myCoreCount), ((AvdOptionsModel)this.getModel()).cpuCoreCount());
        this.myBindings.bindTwoWay(this.myRamStorage.storage(), ((AvdOptionsModel)this.getModel()).getAvdDeviceData().ramStorage());
        this.myBindings.bindTwoWay(this.myVmHeapStorage.storage(), ((AvdOptionsModel)this.getModel()).vmHeapStorage());
        this.myBindings.bindTwoWay(this.myInternalStorage.storage(), ((AvdOptionsModel)this.getModel()).internalStorage());
        this.myBindings.bindTwoWay(this.myBuiltInSdCardStorage.storage(), ObjectProperty.wrap(((AvdOptionsModel)this.getModel()).sdCardStorage()));
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myHostGraphics), ((AvdOptionsModel)this.getModel()).hostGpuMode());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myDeviceFrameCheckbox), ((AvdOptionsModel)this.getModel()).hasDeviceFrame());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myColdBootRadioButton), ((AvdOptionsModel)this.getModel()).useColdBoot());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myFastBootRadioButton), ((AvdOptionsModel)this.getModel()).useFastBoot());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myChooseBootRadioButton), ((AvdOptionsModel)this.getModel()).useChosenSnapshotBoot());
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.mySkinComboBox.getComboBox()), ((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile());
        this.myBindings.bindTwoWay(new SelectedItemProperty(this.myChosenSnapshotComboBox), ((AvdOptionsModel)this.getModel()).getAvdDeviceData().selectedSnapshotFile());
        this.myOrientationToggle.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ScreenOrientation orientation = (ScreenOrientation)ConfigureAvdOptionsStep.this.myOrientationToggle.getSelectedElement();
                if (orientation == null) {
                    ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).selectedAvdOrientation().set(ScreenOrientation.PORTRAIT);
                } else {
                    ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).selectedAvdOrientation().set(orientation);
                }
            }
        });
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return super.isFileVisible(file2, true);
            }
        };
        fileChooserDescriptor2.setHideIgnored(false);
        this.myExternalSdCard.addBrowseFolderListener("Select SD Card", "Select an existing SD card image", this.myProject, fileChooserDescriptor2);
        this.myBindings.bindTwoWay(new TextProperty(this.myExternalSdCard.getTextField()), ((AvdOptionsModel)this.getModel()).externalSdCardLocation());
        this.myBindings.bindTwoWay(ObjectProperty.wrap(new SelectedItemProperty(this.myFrontCameraCombo)), ((AvdOptionsModel)this.getModel()).selectedFrontCamera());
        this.myBindings.bindTwoWay(ObjectProperty.wrap(new SelectedItemProperty(this.myBackCameraCombo)), ((AvdOptionsModel)this.getModel()).selectedBackCamera());
        this.myBindings.bindTwoWay(ObjectProperty.wrap(new SelectedItemProperty(this.mySpeedCombo)), ((AvdOptionsModel)this.getModel()).selectedNetworkSpeed());
        this.myBindings.bindTwoWay(ObjectProperty.wrap(new SelectedItemProperty(this.myLatencyCombo)), ((AvdOptionsModel)this.getModel()).selectedNetworkLatency());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myEnableComputerKeyboard), ((AvdOptionsModel)this.getModel()).enableHardwareKeyboard());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myExternalRadioButton), ((AvdOptionsModel)this.getModel()).useExternalSdCard());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myBuiltInRadioButton), ((AvdOptionsModel)this.getModel()).useBuiltInSdCard());
        this.myBindings.bind(new SelectedProperty(this.myNoSDCardRadioButton), ((AvdOptionsModel)this.getModel()).useBuiltInSdCard().not().and(((AvdOptionsModel)this.getModel()).useExternalSdCard().not()));
    }

    private void addValidators() {
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).getAvdDeviceData().ramStorage(), (Validator)new Validator<Storage>(){

            @NotNull
            public Validator.Result validate(@NotNull Storage ram) {
                return ram.getSizeAsUnit(Storage.Unit.MiB) < 128L ? new Validator.Result(Validator.Severity.ERROR, "RAM must be at least 128 MB. Recommendation is 1 GB.") : Validator.Result.OK;
            }
        }, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).vmHeapStorage(), (Validator)new Validator<Storage>(){

            @NotNull
            public Validator.Result validate(@NotNull Storage heap) {
                return heap.getSizeAsUnit(Storage.Unit.MiB) < 16L ? new Validator.Result(Validator.Severity.ERROR, "VM Heap must be at least 16 MB.") : Validator.Result.OK;
            }
        }, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).internalStorage(), (Validator)new Validator<Storage>(){

            @NotNull
            public Validator.Result validate(@NotNull Storage internalMem) {
                if (!internalMem.lessThan((Object)ConfigureAvdOptionsStep.this.myModel.minInternalMemSize())) {
                    return Validator.Result.OK;
                }
                String errorMessage = ConfigureAvdOptionsStep.this.myModel.isPlayStoreCompatible() ? "Internal storage for Play Store devices must be at least %s." : "Internal storage must be at least %s.";
                return new Validator.Result(Validator.Severity.ERROR, String.format(Locale.US, errorMessage, ConfigureAvdOptionsStep.this.myModel.minInternalMemSize()));
            }
        }, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)((AvdOptionsModel)this.getModel()).externalSdCardLocation(), (Validator)new Validator<String>(){

            @NotNull
            public Validator.Result validate(@NotNull String path2) {
                return (Boolean)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).useExternalSdCard().get() != false && !new File(path2).isFile() ? new Validator.Result(Validator.Severity.ERROR, "The specified SD image file must be a valid image file") : Validator.Result.OK;
            }
        }, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).sdCardStorage(), (Validator)new Validator<Optional<Storage>>(){

            @NotNull
            public Validator.Result validate(@NotNull Optional<Storage> value2) {
                if (ConfigureAvdOptionsStep.this.myOriginalSdCard == null) {
                    ConfigureAvdOptionsStep.this.myOriginalSdCard = ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).sdCardStorage().getValue();
                }
                if (!((Boolean)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).useExternalSdCard().get()).booleanValue() && ((Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).sdCardStorage().get()).isPresent() && ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).sdCardStorage().getValue().lessThan((Object)ConfigureAvdOptionsStep.this.myModel.minSdCardSize())) {
                    String errorMessage = ConfigureAvdOptionsStep.this.myModel.isPlayStoreCompatible() ? "The SD card for Play Store devices must be at least %s." : "The SD card must be at least %s.";
                    return new Validator.Result(Validator.Severity.ERROR, String.format(errorMessage, ConfigureAvdOptionsStep.this.myModel.minSdCardSize()));
                }
                if (!((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).sdCardStorage().getValue().equals((Object)ConfigureAvdOptionsStep.this.myOriginalSdCard)) {
                    return new Validator.Result(Validator.Severity.WARNING, "Modifying the SD card size will erase the card's contents! Click Cancel to abort.");
                }
                return Validator.Result.OK;
            }
        }, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile(), (Validator)new Validator<Optional<File>>(){

            @NotNull
            public Validator.Result validate(@NotNull Optional<File> value2) {
                File layoutFile;
                Validator.Result result2 = Validator.Result.OK;
                if (value2.isPresent() && !FileUtil.filesEqual((File)value2.get(), (File)AvdWizardUtils.NO_SKIN) && !(layoutFile = new File(value2.get(), "layout")).isFile()) {
                    result2 = new Validator.Result(Validator.Severity.ERROR, "The skin directory does not point to a valid skin.");
                }
                return result2;
            }
        }, new ObservableValue[0]);
        this.myOriginalName = (String)((AvdOptionsModel)this.getModel()).avdDisplayName().get();
        this.myValidatorPanel.registerValidator((ObservableValue)((AvdOptionsModel)this.getModel()).avdDisplayName(), (Validator)new Validator<String>(){

            @NotNull
            public Validator.Result validate(@NotNull String value2) {
                value2 = value2.trim();
                Validator.Severity severity = Validator.Severity.OK;
                String errorMessage = "";
                if (value2.isEmpty()) {
                    severity = Validator.Severity.ERROR;
                    errorMessage = "The AVD name cannot be empty.";
                } else if (!AvdNameVerifier.isValid(value2)) {
                    severity = Validator.Severity.ERROR;
                    errorMessage = "The AVD name can contain only the characters " + AvdNameVerifier.humanReadableAllowedCharacters();
                } else if (!value2.equals(ConfigureAvdOptionsStep.this.myOriginalName) && AvdManagerConnection.getDefaultAvdManagerConnection().findAvdWithDisplayName(value2)) {
                    severity = Validator.Severity.ERROR;
                    errorMessage = String.format("An AVD with the name \"%1$s\" already exists.", ((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).avdDisplayName());
                }
                return new Validator.Result(severity, errorMessage);
            }
        }, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)((AvdOptionsModel)this.getModel()).device().isPresent().and(((AvdOptionsModel)this.getModel()).systemImage().isPresent()), (Validator)new Validator<Boolean>(){

            @NotNull
            public Validator.Result validate(@NotNull Boolean deviceAndImageArePresent) {
                if (deviceAndImageArePresent.booleanValue()) {
                    Optional device = (Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().get();
                    Optional systemImage = (Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().get();
                    if (!ChooseSystemImagePanel.systemImageMatchesDevice((SystemImageDescription)systemImage.get(), (Device)device.get())) {
                        return new Validator.Result(Validator.Severity.ERROR, "The selected system image is incompatible with the selected device.");
                    }
                } else {
                    if (!((Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).device().get()).isPresent()) {
                        return new Validator.Result(Validator.Severity.ERROR, "You must select a Device to create an AVD.");
                    }
                    if (!((Optional)((AvdOptionsModel)ConfigureAvdOptionsStep.this.getModel()).systemImage().get()).isPresent()) {
                        return new Validator.Result(Validator.Severity.ERROR, "You must select a System Image to create an AVD.");
                    }
                }
                return Validator.Result.OK;
            }
        }, new ObservableValue[0]);
        this.myValidatorPanel.registerTest((ObservableValue)((AvdOptionsModel)this.getModel()).getAvdDeviceData().compatibleSkinSize(), Validator.Severity.WARNING, "The selected skin is not large enough to view the entire screen.");
    }

    @Override
    protected void onProceeding() {
        boolean hasFrame = (Boolean)((AvdOptionsModel)this.getModel()).hasDeviceFrame().get();
        if (hasFrame && ((Optional)((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile().get()).isPresent()) {
            ((AvdOptionsModel)this.getModel()).backupSkinFile().clear();
        } else {
            ((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile().setValue(AvdWizardUtils.NO_SKIN);
            ((AvdOptionsModel)this.getModel()).backupSkinFile().set(((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile());
        }
        if (this.getSelectedApiLevel() < 16 || ((AvdOptionsModel)this.getModel()).hostGpuMode().getValueOrNull() == GpuMode.OFF) {
            ((AvdOptionsModel)this.getModel()).useHostGpu().set(false);
            ((AvdOptionsModel)this.getModel()).hostGpuMode().setValue(GpuMode.OFF);
        } else {
            ((AvdOptionsModel)this.getModel()).useHostGpu().set(true);
        }
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioWizardStepPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myAvdDisplayName;
    }

    private void setAdvanceSettingsVisible(boolean show) {
        for (JComponent c : this.myAdvancedOptionsComponents) {
            c.setVisible(show);
        }
        this.myBootOptionPanel.setVisible(show && EmulatorAdvFeatures.emulatorSupportsFastBoot(AndroidSdks.getInstance().tryToChooseSdkHandler(), (ProgressIndicator)new StudioLoggerProgressIndicator(ConfigureAvdOptionsStep.class), (ILogger)new LogWrapper(Logger.getInstance(AvdManagerConnection.class))));
        this.toggleSystemOptionals(false);
        this.myScrollRootPane.setPreferredSize(this.myScrollRootPane.getLayout().preferredLayoutSize(this.myScrollRootPane));
    }

    private boolean isAdvancedPanel() {
        return this.myShowAdvancedSettingsButton.getText().equals(HIDE);
    }

    private void enforcePlayStore() {
        boolean deviceIsPresent = (Boolean)((AvdOptionsModel)this.getModel()).device().isPresent().get();
        boolean enable = !this.myModel.isPlayStoreCompatible();
        this.myChangeDeviceButton.setEnabled(enable);
        this.myChangeSystemImageButton.setEnabled(enable && deviceIsPresent);
        this.myHostGraphics.setEnabled(enable);
        this.myQemu2CheckBox.setEnabled(enable);
        this.myRamStorage.setEnabled(enable);
        this.myVmHeapStorage.setEnabled(enable);
        this.myBuiltInRadioButton.setEnabled(enable);
        this.myExternalRadioButton.setEnabled(enable);
        this.myNoSDCardRadioButton.setEnabled(enable);
        Device device = ((AvdOptionsModel)this.getModel()).device().getValueOrNull();
        if (device != null && device.getDefaultHardware().getScreen().isFoldable()) {
            this.mySkinComboBox.setEnabled(false);
        } else {
            this.mySkinComboBox.setEnabled(enable);
        }
        if (!enable) {
            this.myCoreCount.setEnabled(false);
        }
    }

    private void toggleSystemOptionals(boolean useQemu2Changed) {
        boolean showMultiCoreOption = this.isAdvancedPanel() && this.doesSystemImageSupportQemu2();
        this.myQemu2Panel.setVisible(showMultiCoreOption);
        if (showMultiCoreOption) {
            boolean showCores;
            boolean bl = showCores = this.supportsMultipleCpuCores() && (Boolean)((AvdOptionsModel)this.getModel()).useQemu2().get() != false && EmulatedProperties.MAX_NUMBER_OF_CORES > 1;
            if (useQemu2Changed) {
                if (showCores) {
                    ((AvdOptionsModel)this.getModel()).cpuCoreCount().setValue(this.mySelectedCoreCount);
                } else {
                    this.mySelectedCoreCount = ((AvdOptionsModel)this.getModel()).cpuCoreCount().getValueOr(EmulatedProperties.RECOMMENDED_NUMBER_OF_CORES);
                    ((AvdOptionsModel)this.getModel()).cpuCoreCount().setValue(1);
                }
            }
            this.myCoreCount.setEnabled(showCores);
        }
        this.enforcePlayStore();
    }

    private boolean doesSystemImageSupportQemu2() {
        assert (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent());
        return AvdManagerConnection.doesSystemImageSupportQemu2(((AvdOptionsModel)this.getModel()).systemImage().getValue(), FileOpUtils.create());
    }

    private int getSelectedApiLevel() {
        assert (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent());
        AndroidVersion version2 = ((AvdOptionsModel)this.getModel()).systemImage().getValue().getVersion();
        return version2.getApiLevel();
    }

    private void updateDeviceDetails() {
        Dimension dimension2 = ((AvdOptionsModel)this.getModel()).getAvdDeviceData().getDeviceScreenDimension();
        String dimensionString = String.format(Locale.getDefault(), "%dx%d", dimension2.width, dimension2.height);
        AvdDeviceData deviceData = ((AvdOptionsModel)this.getModel()).getAvdDeviceData();
        String densityString = AvdScreenData.getScreenDensity((String)deviceData.deviceId().get(), (Boolean)deviceData.isTv().get(), (Double)deviceData.screenDpi().get(), dimension2.height).getResourceValue();
        String result2 = Joiner.on((char)' ').join((Object)((AvdOptionsModel)this.getModel()).device().getValue().getDefaultHardware().getScreen().getDiagonalLength(), (Object)dimensionString, new Object[]{densityString});
        this.myDeviceDetails.setText(result2);
    }

    private String getSelectedApiString() {
        assert (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent());
        AndroidVersion version2 = ((AvdOptionsModel)this.getModel()).systemImage().getValue().getVersion();
        return version2.getApiString();
    }

    private void registerAdvancedOptionsVisibility() {
        this.myAdvancedOptionsComponents = Lists.newArrayList((Object[])new JComponent[]{this.myStoragePanel, this.myCameraPanel, this.myNetworkPanel, this.myQemu2Panel, this.myKeyboardPanel, this.myCustomSkinPanel, this.myAvdIdRow});
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myPropertyChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(FOCUS_OWNER, this.myPropertyChangeListener);
        }
    }

    private void createUIComponents() {
        Function<ScreenOrientation, Icon> orientationIconFunction = new Function<ScreenOrientation, Icon>(){

            public Icon apply(ScreenOrientation input) {
                return ((NamedIcon)ORIENTATIONS.get(input)).myIcon;
            }
        };
        Function<ScreenOrientation, String> orientationNameFunction = new Function<ScreenOrientation, String>(){

            public String apply(ScreenOrientation input) {
                return ((NamedIcon)ORIENTATIONS.get(input)).myName;
            }
        };
        this.myOrientationToggle = new ASGallery((ListModel)JBList.createDefaultListModel((Object[])new ScreenOrientation[]{ScreenOrientation.PORTRAIT, ScreenOrientation.LANDSCAPE}), (Function)orientationIconFunction, (Function)orientationNameFunction, (Dimension)JBUI.size((int)48, (int)48), null);
        this.myOrientationToggle.setCellMargin((Insets)JBUI.insets((int)5, (int)20, (int)4, (int)20));
        this.myOrientationToggle.setBackground(JBColor.background());
        this.myOrientationToggle.setForeground(JBColor.foreground());
        this.myHardwareSkinHelpLabel = new HyperlinkLabel("How do I create a custom hardware skin?");
        this.myHardwareSkinHelpLabel.setHyperlinkTarget("http://developer.android.com/tools/devices/managing-avds.html#skins");
        this.mySkinComboBox = new SkinChooser(this.myProject, true);
    }

    private boolean supportsMultipleCpuCores() {
        assert (((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent());
        Abi abi = Abi.getEnum((String)((AvdOptionsModel)this.getModel()).systemImage().getValue().getAbiType());
        return abi != null && abi.supportsMultipleCpuCores();
    }

    private void toggleOptionals(@NotNull Optional<Device> device, boolean deviceChange) {
        boolean IsDevicePresent = device.isPresent();
        Hardware deviceDefaultHardware = IsDevicePresent ? device.get().getDefaultHardware() : null;
        this.myFrontCameraCombo.setEnabled(IsDevicePresent && deviceDefaultHardware.getCamera(CameraLocation.FRONT) != null);
        this.myBackCameraCombo.setEnabled(IsDevicePresent && deviceDefaultHardware.getCamera(CameraLocation.BACK) != null);
        this.myOrientationToggle.setEnabled(IsDevicePresent && device.get().getDefaultState().getOrientation() != ScreenOrientation.SQUARE);
        this.myEnableComputerKeyboard.setEnabled(IsDevicePresent && !deviceDefaultHardware.getKeyboard().equals((Object)Keyboard.QWERTY));
        if (deviceChange) {
            ScreenOrientation orientation = IsDevicePresent ? device.get().getDefaultState().getOrientation() : ScreenOrientation.PORTRAIT;
            this.myOrientationToggle.setSelectedElement((Object)orientation);
        }
        File customSkin = ((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile().getValueOrNull();
        File backupSkin = ((AvdOptionsModel)this.getModel()).backupSkinFile().getValueOrNull();
        if (backupSkin != null && customSkin == null) {
            ((AvdOptionsModel)this.getModel()).hasDeviceFrame().set(false);
        }
        File hardwareSkin = null;
        if (IsDevicePresent && ((Optional)((AvdOptionsModel)this.getModel()).systemImage().get()).isPresent()) {
            hardwareSkin = AvdWizardUtils.pathToUpdatedSkins(deviceDefaultHardware.getSkinFile(), ((AvdOptionsModel)this.getModel()).systemImage().getValue(), FileOpUtils.create());
            this.myDeviceName.setIcon(DeviceDefinitionPreview.getIcon(((AvdOptionsModel)this.getModel()).getAvdDeviceData()));
            this.myDeviceName.setText(((AvdOptionsModel)this.getModel()).device().getValue().getDisplayName());
            this.updateDeviceDetails();
        }
        if (customSkin == null) {
            customSkin = backupSkin != null ? backupSkin : hardwareSkin;
        }
        if (customSkin != null) {
            this.mySkinComboBox.getComboBox().setSelectedItem(customSkin);
            ((AvdOptionsModel)this.getModel()).getAvdDeviceData().customSkinFile().setValue(customSkin);
        }
        this.enforcePlayStore();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        AvdConfigurationOptionHelpPanel avdConfigurationOptionHelpPanel;
        JButton jButton;
        JButton jButton2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JBLabel jBLabel3;
        JPanel jPanel2;
        JBLabel jBLabel4;
        JPanel jPanel3;
        JCheckBox jCheckBox2;
        JBLabel jBLabel5;
        JPanel jPanel4;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        StorageField storageField;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        StorageField storageField2;
        StorageField storageField3;
        StorageField storageField4;
        JBLabel jBLabel6;
        JBLabel jBLabel7;
        JBLabel jBLabel8;
        JBLabel jBLabel9;
        JBLabel jBLabel10;
        JPanel jPanel5;
        JComboBox jComboBox;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel6;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JCheckBox jCheckBox3;
        JPanel jPanel7;
        JPanel jPanel8;
        JComboBox jComboBox4;
        JComboBox jComboBox5;
        JBLabel jBLabel11;
        JBLabel jBLabel12;
        JBLabel jBLabel13;
        JPanel jPanel9;
        JComboBox jComboBox6;
        JComboBox jComboBox7;
        JBLabel jBLabel14;
        JBLabel jBLabel15;
        JBLabel jBLabel16;
        JPanel jPanel10;
        JBLabel jBLabel17;
        JPanel jPanel11;
        JButton jButton3;
        JBLabel jBLabel18;
        JBLabel jBLabel19;
        JPanel jPanel12;
        JBLabel jBLabel20;
        JPanel jPanel13;
        JTextField jTextField;
        JPanel jPanel14;
        JPanel jPanel15;
        JBScrollPane jBScrollPane;
        JPanel jPanel16;
        this.createUIComponents();
        this.myRoot = jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel16.setMinimumSize(new Dimension(-1, -1));
        jPanel16.setPreferredSize(new Dimension(-1, -1));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setAutoscrolls(true);
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jBScrollPane.setVerticalScrollBarPolicy(20);
        jPanel16.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myScrollRootPane = jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(11, 1, new Insets(3, 3, 3, 10), -1, -1, false, false));
        jPanel15.setMaximumSize(new Dimension(-1, -1));
        jPanel15.setMinimumSize(new Dimension(-1, -1));
        jPanel15.setPreferredSize(new Dimension(-1, -1));
        jBScrollPane.setViewportView(jPanel15);
        this.myAvdNamePanel = jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel14, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel21 = new JBLabel();
        jBLabel21.setText("AVD Name");
        jPanel14.add((Component)jBLabel21, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAvdDisplayName = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setToolTipText("<html>The name of this AVD.</html>");
        jPanel14.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myAvdIdRow = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel13, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel22 = new JBLabel();
        this.myAvdIdLabel = jBLabel22;
        jBLabel22.setText("AVD Id");
        jPanel13.add((Component)jBLabel22, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAvdId = jBLabel20 = new JBLabel();
        jBLabel20.setToolTipText("<html>Identification name used to save an AVD on disk. This AVD name can also be used with Android command line tools.</html>");
        jPanel13.add((Component)jBLabel20, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myDevicePanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myDeviceName = jBLabel19 = new JBLabel();
        jBLabel19.setText("(Device Name)");
        jPanel12.add((Component)jBLabel19, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel12.add((Component)jSeparator, new GridConstraints(0, 0, 1, 2, 1, 1, 3, 1, null, null, null));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel17, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeviceDetails = jBLabel18 = new JBLabel();
        jBLabel18.setText("No Hardware Profile Selected");
        jPanel17.add((Component)jBLabel18, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myChangeDeviceButton = jButton3 = new JButton();
        jButton3.setText("Change...");
        jPanel17.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myOrientationPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel11, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myOrientationLabel = jBLabel17 = new JBLabel();
        jBLabel17.setEnabled(true);
        jBLabel17.setHorizontalTextPosition(10);
        jBLabel17.setText("<html>Startup orientation</html>");
        jPanel11.add((Component)jBLabel17, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel11.add((Component)jSeparator2, new GridConstraints(0, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        ASGallery<ScreenOrientation> aSGallery = this.myOrientationToggle;
        aSGallery.setToolTipText("<html>Sets the initial orientation of the device. During AVD emulation you can also rotate the device screen. </html>");
        jPanel11.add((Component)aSGallery, new GridConstraints(1, 1, 1, 1, 1, 1, 7, 7, null, null, null));
        this.myCameraPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel10, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myCameraLabel = jBLabel16 = new JBLabel();
        jBLabel16.setEnabled(true);
        jBLabel16.setHorizontalTextPosition(10);
        jBLabel16.setText("Camera");
        jPanel10.add((Component)jBLabel16, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel18, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFrontCameraLabel = jBLabel15 = new JBLabel();
        jBLabel15.setText("Front:");
        jPanel18.add((Component)jBLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBackCameraLabel = jBLabel14 = new JBLabel();
        jBLabel14.setText("Back:");
        jPanel18.add((Component)jBLabel14, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBackCameraCombo = jComboBox7 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("None");
        jComboBox7.setModel(defaultComboBoxModel);
        jPanel18.add(jComboBox7, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myFrontCameraCombo = jComboBox6 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("None");
        jComboBox6.setModel(defaultComboBoxModel2);
        jPanel18.add(jComboBox6, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        JSeparator jSeparator3 = new JSeparator();
        jPanel10.add((Component)jSeparator3, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myNetworkPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel9, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myNetworkLabel = jBLabel13 = new JBLabel();
        jBLabel13.setEnabled(true);
        jBLabel13.setHorizontalTextPosition(10);
        jBLabel13.setText("Network");
        jPanel9.add((Component)jBLabel13, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel19, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySpeedLabel = jBLabel12 = new JBLabel();
        jBLabel12.setText("Speed:");
        jPanel19.add((Component)jBLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLatencyLabel = jBLabel11 = new JBLabel();
        jBLabel11.setText("Latency:");
        jPanel19.add((Component)jBLabel11, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLatencyCombo = jComboBox5 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel3.addElement("None");
        jComboBox5.setModel(defaultComboBoxModel3);
        jComboBox5.setToolTipText("<html>Sets the initial state of the simulated network transfer latency used by AVD. Latency is the delay in processing data across the network. The latency speed can also be adjusted in the emulator.</html>");
        jPanel19.add(jComboBox5, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.mySpeedCombo = jComboBox4 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel4 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel4.addElement("Full");
        jComboBox4.setModel(defaultComboBoxModel4);
        jComboBox4.setToolTipText("<html>Sets the initial state of the simulated network transfer rate used by AVD. The network speed can also be adjusted in the emulator.</html>");
        jPanel19.add(jComboBox4, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        JSeparator jSeparator4 = new JSeparator();
        jPanel9.add((Component)jSeparator4, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myPerformancePanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel8, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel23 = new JBLabel();
        jBLabel23.setEnabled(true);
        jBLabel23.setHorizontalTextPosition(10);
        jBLabel23.setText("<html>Emulated<br>Performance</html>");
        jPanel8.add((Component)jBLabel23, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        JSeparator jSeparator5 = new JSeparator();
        jPanel8.add((Component)jSeparator5, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel20, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myQemu2Panel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel7, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator6 = new JSeparator();
        jPanel7.add((Component)jSeparator6, new GridConstraints(0, 0, 1, 3, 1, 1, 3, 0, null, null, null));
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel21, new GridConstraints(0, 0, 1, 3, 8, 2, 3, 3, null, null, null));
        this.myQemu2CheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Multi-Core CPU");
        jCheckBox3.setToolTipText("<html>Select the number of CPU cores for the emulator to use.</html>");
        jPanel21.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCoreCount = jComboBox3 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel5 = new DefaultComboBoxModel();
        jComboBox3.setModel(defaultComboBoxModel5);
        jComboBox3.setToolTipText("<html>Select the number of CPU cores for the emulator to use.</html>");
        jPanel21.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel22, new GridConstraints(0, 0, 2, 4, 8, 2, 3, 3, null, null, null));
        JBLabel jBLabel24 = new JBLabel();
        jBLabel24.setText("Graphics:");
        jPanel22.add((Component)jBLabel24, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHostGraphics = jComboBox2 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel6 = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel6);
        jComboBox2.setToolTipText("<html>Choose how the graphics should be rendered in the emulator.<br><br><b>Hardware</b><br>Use your computer's graphics card for faster rendering.<br><br><b>Software</b><br>Emulate the graphics in software, use this to work around issues with your computer's graphics card.</html>");
        jPanel22.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBootOptionPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.setToolTipText("<html>Choose how the virtual device should start.<br><br>\n<b>Cold boot</b><br>Start as from a power-up.<br><br>\n<b>Quick boot</b><br>Start from the state that was saved when the device last exited.<br><br>\n<b>Choose from snapshot</b><br>Start from the chosen snapshot.</html>");
        jPanel20.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel25 = new JBLabel();
        jBLabel25.setText("Boot option:");
        jPanel6.add((Component)jBLabel25, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myColdBootRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Cold boot");
        jRadioButton6.setToolTipText("<html>Choose how the virtual device should start.<br><br>\n<b>Cold boot</b><br>Start as from a power-up.<br><br>\n<b>Quick boot</b><br>Start from the state that was saved when the device last exited.<br><br>\n<b>Choose from snapshot</b><br>Start from the chosen snapshot.</html>");
        jPanel6.add((Component)jRadioButton6, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFastBootRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setSelected(true);
        jRadioButton5.setText("Quick boot");
        jRadioButton5.setToolTipText("<html>Choose how the virtual device should start.<br><br>\n<b>Cold boot</b><br>Start as from a power-up.<br><br>\n<b>Quick boot</b><br>Start from the state that was saved when the device last exited.<br><br>\n<b>Choose from snapshot</b><br>Start from the chosen snapshot.</html>");
        jPanel6.add((Component)jRadioButton5, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChooseBootRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        jRadioButton4.setText("Choose from snapshot");
        jRadioButton4.setToolTipText("<html>Choose how the virtual device should start.<br><br>\n<b>Cold boot</b><br>Start as from a power-up.<br><br>\n<b>Quick boot</b><br>Start from the state that was saved when the device last exited.<br><br>\n<b>Choose from snapshot</b><br>Start from the chosen snapshot.</html>");
        jPanel6.add((Component)jRadioButton4, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChosenSnapshotComboBox = jComboBox = new JComboBox();
        jPanel6.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null, 2));
        this.myStoragePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel5, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myMemoryAndStorageLabel = jBLabel10 = new JBLabel();
        jBLabel10.setEnabled(true);
        jBLabel10.setHorizontalTextPosition(10);
        jBLabel10.setText("<html>Memory<br>and<br>Storage</html>");
        jPanel5.add((Component)jBLabel10, new GridConstraints(1, 0, 1, 1, 9, 0, 2, 0, null, null, null));
        JPanel jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel23, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRamLabel = jBLabel9 = new JBLabel();
        jBLabel9.setText("RAM:");
        jPanel23.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVmHeapLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("VM heap:");
        jPanel23.add((Component)jBLabel8, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInternalStorageLabel = jBLabel7 = new JBLabel();
        jBLabel7.setText("Internal Storage:");
        jPanel23.add((Component)jBLabel7, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySdCardLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("SD card:");
        jPanel23.add((Component)jBLabel6, new GridConstraints(3, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myRamStorage = storageField4 = new StorageField();
        storageField4.setToolTipText("<html>The amount of physical RAM on the device.<br>1 MB = 1024 KB<br>1 GB = 1024 MB</html>");
        jPanel23.add((Component)storageField4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myVmHeapStorage = storageField3 = new StorageField();
        storageField3.setToolTipText("<html>The amount of RAM available to Java virtual machine (VM) to allocate to running apps on the device. A larger VM heap allows applications to run longer between garbage collection events.</html>");
        jPanel23.add((Component)storageField3, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myInternalStorage = storageField2 = new StorageField();
        storageField2.setToolTipText("<html>The amount of non-removable space available to store data on the device.</html>");
        jPanel23.add((Component)storageField2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel24, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBuiltInRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Studio-managed");
        jRadioButton3.setToolTipText("<html>The amount of removable space available to store data on the device. We recommend at least 100 MB in order to use the camera in the emulator.</html>");
        jPanel24.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExternalRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("External file");
        jRadioButton2.setToolTipText("<html>Choose a file path to an existing SD Card image. Using an external SD Card is useful when sharing SD Card data (pictures, media, files, etc.) between Android Virtual Devices. See <a>http://d.android.com/tools/help/mksdcard.html</a> for more details. </html>");
        jPanel24.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBuiltInSdCardStorage = storageField = new StorageField();
        storageField.setToolTipText("<html>The amount of removable space available to store data on the device. We recommend at least 100 MB in order to use the camera in the emulator.</html>");
        jPanel24.add((Component)storageField, new GridConstraints(0, 1, 1, 1, 1, 1, 7, 0, null, null, null));
        this.myExternalSdCard = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText("<html>Choose a file path to an existing SD Card image. Using an external SD Card is useful when sharing SD Card data (pictures, media, files, etc.) between Android Virtual Devices. See http://d.android.com/tools/help/mksdcard.html for more details. </html>");
        textFieldWithBrowseButton.setVisible(true);
        jPanel24.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, null, null, null));
        this.myNoSDCardRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("No SDCard");
        jRadioButton.setToolTipText("<html>No SDCard available on this device. The amount of removeable space is 0 on this device. </html>");
        jPanel24.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JSeparator jSeparator7 = new JSeparator();
        jPanel5.add((Component)jSeparator7, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myFramePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel4, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myDeviceFrameTitle = jBLabel5 = new JBLabel();
        jBLabel5.setText("Device Frame");
        jPanel4.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceFrameCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Enable Device Frame");
        jCheckBox2.setToolTipText("<html>Enable a frame around the Android emulator window that mimics the look of a real Android device. Click on Show Advanced Settings for more options.</html>");
        jPanel4.add((Component)jCheckBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JSeparator jSeparator8 = new JSeparator();
        jPanel4.add((Component)jSeparator8, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myCustomSkinPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySkinDefinitionLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Custom skin definition");
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myHardwareSkinHelpLabel;
        hyperlinkLabel.setVisible(true);
        jPanel3.add((Component)hyperlinkLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        SkinChooser skinChooser = this.mySkinComboBox;
        ((JComponent)((Object)skinChooser)).setToolTipText("<html>A collection of images and configuration data that indicates how to populate the window. Each skin can have several \"layouts\" (e.g. \"landscape\" and \"portrait\") corresponding to different orientation / physical configurations of the emulated device.</html>");
        ((Component)((Object)skinChooser)).setVisible(true);
        jPanel3.add((Component)((Object)skinChooser), new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myKeyboardPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel2, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myKeyboardLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Keyboard");
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableComputerKeyboard = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable keyboard input");
        jCheckBox.setToolTipText("<html>Lets you enter text and interact with the AVD using your hardware computer keyboard in addition to the on-screen soft keyboard.</html>");
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JSeparator jSeparator9 = new JSeparator();
        jPanel2.add((Component)jSeparator9, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 7, null, null, null));
        this.myImagePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.mySystemImageName = jBLabel2 = new JBLabel();
        jBLabel2.setText("(Image Name)");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        JSeparator jSeparator10 = new JSeparator();
        jPanel.add((Component)jSeparator10, new GridConstraints(0, 0, 1, 2, 1, 1, 3, 1, null, null, null));
        JPanel jPanel25 = new JPanel();
        jPanel25.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel25, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySystemImageDetails = jBLabel = new JBLabel();
        jBLabel.setText("No System Image Selected");
        jPanel25.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myChangeSystemImageButton = jButton2 = new JButton();
        jButton2.setText("Change...");
        jPanel25.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel15.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myShowAdvancedSettingsButton = jButton = new JButton();
        jButton.setText("");
        jPanel16.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myAvdConfigurationOptionHelpPanel = avdConfigurationOptionHelpPanel = new AvdConfigurationOptionHelpPanel();
        JComponent jComponent = avdConfigurationOptionHelpPanel.$$$getRootComponent$$$();
        jPanel16.add((Component)jComponent, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, new Dimension(350, -1), null, null));
        jBLabel21.setLabelFor(jTextField);
        jBLabel15.setLabelFor(jComboBox6);
        jBLabel14.setLabelFor(jComboBox7);
        jBLabel12.setLabelFor(jComboBox4);
        jBLabel11.setLabelFor(jComboBox5);
        jBLabel24.setLabelFor(jComboBox2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static final class NamedIcon {
        @NotNull
        private final String myName;
        @NotNull
        private final Icon myIcon;

        public NamedIcon(@NotNull String name, @NotNull Icon icon2) {
            this.myName = name;
            this.myIcon = icon2;
        }
    }

    private class SnapshotListItem
    implements Comparable<SnapshotListItem> {
        public String fileName;
        public String logicalName;
        public Long date;

        public SnapshotListItem(@NotNull String theFileName, String theLogicalName, Long theDate) {
            this.fileName = theFileName;
            this.logicalName = theLogicalName;
            this.date = theDate;
        }

        @Override
        public int compareTo(@NotNull SnapshotListItem that) {
            boolean thisIsSelected = ConfigureAvdOptionsStep.this.mySelectedSnapshotFileName.equals(this.fileName);
            boolean thatIsSelected = ConfigureAvdOptionsStep.this.mySelectedSnapshotFileName.equals(that.fileName);
            if (thisIsSelected) {
                return thatIsSelected ? 0 : -1;
            }
            if (thatIsSelected) {
                return 1;
            }
            return this.date.compareTo(that.date);
        }
    }
}

