/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.arsc;

import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.google.common.collect.ImmutableList;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceIdentifier;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeSpecChunk;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class ResourceTypeTableModel
extends AbstractTableModel {
    private final StringPoolChunk myStringPool;
    private final PackageChunk myPackageChunk;
    private final TypeSpecChunk myTypeSpec;
    private final List<TypeChunk> myTypes;

    public ResourceTypeTableModel(@NotNull StringPoolChunk stringPool, @NotNull PackageChunk packageChunk, @NotNull TypeSpecChunk typeSpec) {
        this.myStringPool = stringPool;
        this.myPackageChunk = packageChunk;
        this.myTypeSpec = typeSpec;
        this.myTypes = ImmutableList.copyOf((Collection)packageChunk.getTypeChunks(typeSpec.getId()));
    }

    @Override
    public int getRowCount() {
        return this.myTypeSpec.getResourceCount();
    }

    @Override
    public int getColumnCount() {
        return this.myTypes.size() + 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            BinaryResourceIdentifier id = BinaryResourceIdentifier.create((int)this.myPackageChunk.getId(), (int)this.myTypeSpec.getId(), (int)row);
            return id.toString();
        }
        if (col == 1) {
            String key = "unknown";
            for (TypeChunk type : this.myTypes) {
                TypeChunk.Entry entry = (TypeChunk.Entry)type.getEntries().get(row);
                if (entry == null) continue;
                key = entry.key();
                break;
            }
            return key;
        }
        TypeChunk typeChunk = this.myTypes.get(col - 2);
        if (typeChunk.getEntries().containsKey(row)) {
            TypeChunk.Entry entry = (TypeChunk.Entry)typeChunk.getEntries().get(row);
            BinaryResourceValue value2 = entry.value();
            if (value2 != null) {
                return this.formatValue(value2);
            }
            Map values2 = entry.values();
            if (values2 != null) {
                return values2.values().stream().map(this::formatValue).collect(Collectors.joining(", "));
            }
            return "?";
        }
        return "";
    }

    @NotNull
    private String formatValue(@NotNull BinaryResourceValue value2) {
        if (value2.type() == BinaryResourceValue.Type.STRING) {
            return this.myStringPool.getString(value2.data());
        }
        return BinaryXmlParser.formatValue((BinaryResourceValue)value2, (StringPoolChunk)this.myStringPool);
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "ID";
        }
        if (column == 1) {
            return "Name";
        }
        TypeChunk typeChunk = this.myTypes.get(column - 2);
        return typeChunk.getConfiguration().toString();
    }
}

