/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.paths;

import com.android.tools.idea.apk.paths.PathNode;
import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathNodeParent {
    @NotNull
    private final Map<String, PathNode> myChildrenByPathSegment = new LinkedHashMap<String, PathNode>();

    @Nullable
    final PathNode addChild(@NotNull List<String> segments, int index2, char pathSeparator) {
        if (index2 < segments.size()) {
            String pathSegment = segments.get(index2);
            String path2 = Joiner.on((char)pathSeparator).join(segments.subList(0, index2 + 1));
            PathNode child = this.myChildrenByPathSegment.computeIfAbsent(pathSegment, s -> new PathNode((String)s, path2, this));
            child.addChild(segments, index2 + 1, pathSeparator);
            return child;
        }
        return null;
    }

    @NotNull
    public final Collection<PathNode> getChildren() {
        return this.myChildrenByPathSegment.values();
    }
}

