/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Getter;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AdbOptionsService
implements Getter<AdbOptionsService> {
    public static final int USER_MANAGED_ADB_PORT_DEFAULT = 5038;
    static final int USER_MANAGED_ADB_PORT_MIN_VALUE = 5038;
    static final int USER_MANAGED_ADB_PORT_MAX_VALUE = 65535;
    private static final String USE_LIBUSB = "adb.use.libusb";
    private static final String USE_USER_MANAGED_ADB = "AdbOptionsService.use.user.managed.adb";
    private static final String USER_MANAGED_ADB_PORT = "AdbOptionsService.user.managed.adb.port";
    private static final boolean LIBUSB_DEFAULT = false;
    private static final boolean USE_USER_MANAGED_ADB_DEFAULT = false;
    private final Object LOCK = new Object();
    private List<AdbOptionsListener> myListeners = new SmartList();

    public static AdbOptionsService getInstance() {
        return (AdbOptionsService)ServiceManager.getService(AdbOptionsService.class);
    }

    public AdbOptionsService get() {
        return this;
    }

    public boolean shouldUseLibusb() {
        return PropertiesComponent.getInstance().getBoolean(USE_LIBUSB, false);
    }

    boolean shouldUseUserManagedAdb() {
        return PropertiesComponent.getInstance().getBoolean(USE_USER_MANAGED_ADB, false);
    }

    int getUserManagedAdbPort() {
        return PropertiesComponent.getInstance().getInt(USER_MANAGED_ADB_PORT, 5038);
    }

    public void setAdbConfigs(boolean useLibusb, boolean useUserManagedAdb, int userManagedAdbPort) {
        PropertiesComponent props = PropertiesComponent.getInstance();
        props.setValue(USE_LIBUSB, useLibusb);
        props.setValue(USE_USER_MANAGED_ADB, useUserManagedAdb);
        props.setValue(USER_MANAGED_ADB_PORT, userManagedAdbPort, 5038);
        this.updateListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListeners() {
        ImmutableList listeners;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            listeners = ImmutableList.copyOf(this.myListeners);
        }
        for (AdbOptionsListener listener2 : listeners) {
            listener2.optionsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull AdbOptionsListener listener2) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myListeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull AdbOptionsListener listener2) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myListeners.remove(listener2);
        }
    }

    public static interface AdbOptionsListener {
        public void optionsChanged();
    }
}

