/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.MockupToggleAction;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.mockup.editor.MockUpFileChooser;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.base.Strings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupEditAction
extends AnAction {
    private static final String EDIT_ACTION_TITLE = "Edit Mockup";
    private static final String ADD_ACTION_TITLE = "Add Mockup";
    private final MockupToggleAction myMockupToggleAction;
    private final NlDesignSurface myDesignSurface;

    public MockupEditAction(@NotNull NlDesignSurface designSurface) {
        super(ADD_ACTION_TITLE);
        if (!((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
            this.myMockupToggleAction = null;
            this.myDesignSurface = null;
            return;
        }
        this.myDesignSurface = designSurface;
        this.myMockupToggleAction = new MockupToggleAction(designSurface);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (!((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        NlComponent component = this.getFirstSelectedComponent();
        if (component == null) {
            presentation.setEnabled(false);
        } else if (component.getAttribute("http://schemas.android.com/tools", "mockup") != null) {
            presentation.setText(EDIT_ACTION_TITLE);
        } else {
            presentation.setText(ADD_ACTION_TITLE);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        this.myMockupToggleAction.setSelected(event, true);
        NlComponent component = this.getFirstSelectedComponent();
        if (component == null) {
            return;
        }
        this.myMockupToggleAction.setSelected(event, true);
        MockUpFileChooser.INSTANCE.chooseMockUpFile(component, path2 -> NlWriteCommandActionUtil.run(component, Strings.nullToEmpty((String)event.getPresentation().getText()), () -> {
            component.setAttribute("http://schemas.android.com/tools", "mockup", (String)path2);
            component.setAttribute("http://schemas.android.com/tools", "mockup_crop", "");
        }));
    }

    @Nullable
    public NlComponent getFirstSelectedComponent() {
        NlModel model2 = this.myDesignSurface.getModel();
        if (model2 == null) {
            return null;
        }
        List<NlComponent> selection = this.myDesignSurface.getSelectionModel().getSelection();
        if (selection.isEmpty()) {
            selection = model2.getComponents();
        }
        if (selection.isEmpty()) {
            return null;
        }
        return selection.get(0);
    }
}

