/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidStudioActionRemover
extends AnAction {
    @NotNull
    protected final AnAction myDelegate;

    public AndroidStudioActionRemover(@NotNull AnAction delegate2, @NotNull String backupText) {
        super(delegate2.getTemplatePresentation().getTextWithMnemonic(), delegate2.getTemplatePresentation().getDescription(), delegate2.getTemplatePresentation().getIcon());
        this.myDelegate = delegate2;
        Presentation presentation = this.getTemplatePresentation();
        if (StringUtil.isEmpty((String)presentation.getText())) {
            presentation.setText(backupText);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myDelegate.actionPerformed(e);
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project != null && AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        this.copyTextAndIcon(this.getTemplatePresentation(), this.myDelegate.getTemplatePresentation());
        this.myDelegate.update(e);
    }

    protected void copyTextAndIcon(@NotNull Presentation source, @NotNull Presentation destination) {
        destination.setText(source.getTextWithMnemonic());
        destination.setIcon(source.getIcon());
    }
}

