/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.ProjectConfigurationData;
import com.android.build.attribution.data.TaskContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.SuccessResult;
import org.gradle.tooling.events.configuration.ProjectConfigurationFinishEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationStartEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationSuccessResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000fH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R-\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/android/build/attribution/analyzers/ProjectConfigurationAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "warningsFilter", "Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "(Lcom/android/build/attribution/BuildAttributionWarningsFilter;Lcom/android/build/attribution/data/TaskContainer;Lcom/android/build/attribution/data/PluginContainer;)V", "applyPluginEventPrefix", "", "pluginsConfigurationDataMap", "Ljava/util/HashMap;", "Lcom/android/build/attribution/data/PluginData;", "", "Lkotlin/collections/HashMap;", "getPluginsConfigurationDataMap", "()Ljava/util/HashMap;", "projectConfigurationBuilder", "Lcom/android/build/attribution/data/ProjectConfigurationData$Builder;", "projectsConfigurationData", "Ljava/util/ArrayList;", "Lcom/android/build/attribution/data/ProjectConfigurationData;", "Lkotlin/collections/ArrayList;", "getProjectsConfigurationData", "()Ljava/util/ArrayList;", "getWarningsFilter", "()Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "getFirstConfigurationStepInParentEvents", "Lorg/gradle/tooling/events/OperationDescriptor;", "descriptor", "onBuildFailure", "", "onBuildStart", "onBuildSuccess", "receiveEvent", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "updatePluginConfigurationTime", "plugin", "configurationTimeMs", "intellij.android.build-attribution"})
public final class ProjectConfigurationAnalyzer
extends BaseAnalyzer
implements BuildEventsAnalyzer {
    private final String applyPluginEventPrefix;
    @NotNull
    private final HashMap<PluginData, Long> pluginsConfigurationDataMap;
    @NotNull
    private final ArrayList<ProjectConfigurationData> projectsConfigurationData;
    private ProjectConfigurationData.Builder projectConfigurationBuilder;
    @NotNull
    private final BuildAttributionWarningsFilter warningsFilter;

    @NotNull
    public final HashMap<PluginData, Long> getPluginsConfigurationDataMap() {
        return this.pluginsConfigurationDataMap;
    }

    @NotNull
    public final ArrayList<ProjectConfigurationData> getProjectsConfigurationData() {
        return this.projectsConfigurationData;
    }

    private final void updatePluginConfigurationTime(PluginData plugin, long configurationTimeMs) {
        long currentConfigurationTime = ((Number)this.pluginsConfigurationDataMap.getOrDefault(plugin, 0L)).longValue();
        ((Map)this.pluginsConfigurationDataMap).put(plugin, currentConfigurationTime + configurationTimeMs);
        ProjectConfigurationData.Builder builder2 = this.projectConfigurationBuilder;
        if (builder2 == null) {
            Intrinsics.throwNpe();
        }
        builder2.addPluginConfigurationData(plugin, configurationTimeMs);
    }

    @Override
    public void receiveEvent(@NotNull ProgressEvent event) {
        if (event instanceof ProjectConfigurationStartEvent) {
            this.projectConfigurationBuilder = new ProjectConfigurationData.Builder(((ProjectConfigurationStartEvent)event).getDescriptor().getProject().getProjectPath());
        } else if (this.projectConfigurationBuilder != null) {
            if (event instanceof ProjectConfigurationFinishEvent && ((ProjectConfigurationFinishEvent)event).getResult() instanceof ProjectConfigurationSuccessResult) {
                ProjectConfigurationData.Builder builder2 = this.projectConfigurationBuilder;
                if (builder2 == null) {
                    Intrinsics.throwNpe();
                }
                this.projectsConfigurationData.add(builder2.build(((ProjectConfigurationFinishEvent)event).getResult().getEndTime() - ((ProjectConfigurationFinishEvent)event).getResult().getStartTime()));
                this.projectConfigurationBuilder = null;
            } else if (event instanceof FinishEvent && ((FinishEvent)event).getResult() instanceof SuccessResult) {
                if (StringsKt.startsWith$default((String)((FinishEvent)event).getDescriptor().getName(), (String)this.applyPluginEventPrefix, (boolean)false, (int)2, null)) {
                    Object object = ((FinishEvent)event).getDescriptor().getParent();
                    if (object == null || (object = object.getName()) == null || !StringsKt.startsWith$default((String)object, (String)this.applyPluginEventPrefix, (boolean)false, (int)2, null)) {
                        String string = ((FinishEvent)event).getDescriptor().getName();
                        int n = this.applyPluginEventPrefix.length() + 1;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        String pluginName = string3;
                        ProjectConfigurationData.Builder builder3 = this.projectConfigurationBuilder;
                        if (builder3 == null) {
                            Intrinsics.throwNpe();
                        }
                        PluginData plugin = this.getPlugin(PluginData.PluginType.BINARY_PLUGIN, pluginName, builder3.getProjectPath());
                        long pluginConfigurationTime = ((FinishEvent)event).getResult().getEndTime() - ((FinishEvent)event).getResult().getStartTime();
                        this.updatePluginConfigurationTime(plugin, pluginConfigurationTime);
                        OperationDescriptor configurationStepDescriptor = this.getFirstConfigurationStepInParentEvents(((FinishEvent)event).getDescriptor());
                        if (configurationStepDescriptor != null) {
                            ProjectConfigurationData.Builder builder4 = this.projectConfigurationBuilder;
                            if (builder4 == null) {
                                Intrinsics.throwNpe();
                            }
                            builder4.subtractConfigurationStepTime(configurationStepDescriptor, pluginConfigurationTime);
                        }
                    }
                } else {
                    boolean bl;
                    block17: {
                        ProjectConfigurationData.ConfigurationStep.Type[] $this$any$iv = ProjectConfigurationData.ConfigurationStep.Type.values();
                        boolean $i$f$any = false;
                        ProjectConfigurationData.ConfigurationStep.Type[] typeArray = $this$any$iv;
                        int n = typeArray.length;
                        for (int j = 0; j < n; ++j) {
                            ProjectConfigurationData.ConfigurationStep.Type element$iv;
                            ProjectConfigurationData.ConfigurationStep.Type it = element$iv = typeArray[j];
                            boolean bl2 = false;
                            if (!it.isDescriptorOfType(((FinishEvent)event).getDescriptor())) continue;
                            bl = true;
                            break block17;
                        }
                        bl = false;
                    }
                    if (bl && this.getFirstConfigurationStepInParentEvents(((FinishEvent)event).getDescriptor().getParent()) == null) {
                        ProjectConfigurationData.Builder builder5 = this.projectConfigurationBuilder;
                        if (builder5 == null) {
                            Intrinsics.throwNpe();
                        }
                        builder5.addConfigurationStepTime(((FinishEvent)event).getDescriptor(), ((FinishEvent)event).getResult().getEndTime() - ((FinishEvent)event).getResult().getStartTime());
                    }
                }
            }
        }
    }

    private final OperationDescriptor getFirstConfigurationStepInParentEvents(OperationDescriptor descriptor2) {
        boolean bl;
        block4: {
            if (descriptor2 == null) {
                return null;
            }
            OperationDescriptor configurationStepDescriptor = this.getFirstConfigurationStepInParentEvents(descriptor2.getParent());
            if (configurationStepDescriptor != null) {
                return configurationStepDescriptor;
            }
            ProjectConfigurationData.ConfigurationStep.Type[] $this$any$iv = ProjectConfigurationData.ConfigurationStep.Type.values();
            boolean $i$f$any = false;
            ProjectConfigurationData.ConfigurationStep.Type[] typeArray = $this$any$iv;
            int n = typeArray.length;
            for (int j = 0; j < n; ++j) {
                ProjectConfigurationData.ConfigurationStep.Type element$iv;
                ProjectConfigurationData.ConfigurationStep.Type it = element$iv = typeArray[j];
                boolean bl2 = false;
                if (!it.isDescriptorOfType(descriptor2)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return descriptor2;
        }
        return null;
    }

    @Override
    public void onBuildStart() {
        super.onBuildStart();
        this.projectsConfigurationData.clear();
        this.pluginsConfigurationDataMap.clear();
        this.projectConfigurationBuilder = null;
    }

    @Override
    public void onBuildSuccess() {
    }

    @Override
    public void onBuildFailure() {
        this.projectsConfigurationData.clear();
        this.pluginsConfigurationDataMap.clear();
        this.projectConfigurationBuilder = null;
    }

    @Override
    @NotNull
    public BuildAttributionWarningsFilter getWarningsFilter() {
        return this.warningsFilter;
    }

    public ProjectConfigurationAnalyzer(@NotNull BuildAttributionWarningsFilter warningsFilter, @NotNull TaskContainer taskContainer, @NotNull PluginContainer pluginContainer) {
        super(taskContainer, pluginContainer);
        this.warningsFilter = warningsFilter;
        this.applyPluginEventPrefix = "Apply plugin";
        this.pluginsConfigurationDataMap = new HashMap();
        this.projectsConfigurationData = new ArrayList();
    }
}

