/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.vnc;

import com.google.gct.testing.vnc.BlankVncViewerCallback;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class BlankVncViewer
extends JApplet
implements Runnable {
    private final String myConfigurationName;
    private final BlankVncViewerCallback myBlankVncViewerCallback;
    private JFrame blankFrame;
    private WindowListener exitListener;

    public BlankVncViewer(String configurationName, BlankVncViewerCallback blankVncViewerCallback) {
        this.myConfigurationName = configurationName;
        this.myBlankVncViewerCallback = blankVncViewerCallback;
        this.exitListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int confirm = JOptionPane.showOptionDialog(BlankVncViewer.this.blankFrame, "Are you sure you want to close the window? Closing the window will delete the Firebase instance.", "Exit Confirmation", 0, 3, null, null, null);
                if (confirm == 0) {
                    System.out.println("Exiting blank VNC Viewer");
                    BlankVncViewer.this.myBlankVncViewerCallback.viewerClosed();
                    BlankVncViewer.this.blankFrame.setDefaultCloseOperation(2);
                }
            }
        };
    }

    @Override
    public void run() {
        this.blankFrame = new JFrame("Launching Firebase Device");
        this.blankFrame.setDefaultCloseOperation(0);
        this.blankFrame.addWindowListener(this.exitListener);
        JLabel infoLabel = new JLabel("Launching " + this.myConfigurationName, 0);
        infoLabel.setPreferredSize(new Dimension(600, 100));
        this.blankFrame.getContentPane().add((Component)infoLabel, "Center");
        this.blankFrame.pack();
        this.blankFrame.setVisible(true);
    }

    public void closeWindow() {
        this.blankFrame.removeWindowListener(this.exitListener);
        this.blankFrame.setDefaultCloseOperation(2);
        this.blankFrame.dispatchEvent(new WindowEvent(this.blankFrame, 201));
    }

    public static BlankVncViewer showBlankVncViewer(String configurationName, BlankVncViewerCallback blankVncViewerCallback) {
        BlankVncViewer blankViewer = new BlankVncViewer(configurationName, blankVncViewerCallback);
        SwingUtilities.invokeLater(blankViewer);
        return blankViewer;
    }
}

