/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.google.api.services.testing.model.TestMatrix;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gct.testing.CloudMatrixExecutionCancellator;
import com.google.gct.testing.CloudResultsLoader;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.ConfigurationResult;
import com.google.gct.testing.results.GoogleCloudTestingResultParser;
import com.intellij.execution.process.ProcessHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class CloudResultsAdapter {
    private final String cloudProjectId;
    private final CloudResultsLoader loader;
    private final GoogleCloudTestingResultParser resultParser;
    private final List<String> expectedConfigurationInstances;
    private final Map<String, ConfigurationResult> results = new HashMap<String, ConfigurationResult>();
    private final Set<ConfigurationResult> publishedConfigurations = new HashSet<ConfigurationResult>();
    private final Set<ConfigurationResult> markedAsPendingConfigurations = new HashSet<ConfigurationResult>();
    private final Set<ConfigurationResult> markedAsFinishedConfigurations = new HashSet<ConfigurationResult>();
    private final PollingTicker pollingTicker;

    public CloudResultsAdapter(String cloudProjectId, String bucketName, String uniquePrefix, ProcessHandler processHandler, GoogleCloudTestingResultParser resultParser, List<String> expectedConfigurationInstances, String testRunId, @Nullable TestMatrix testMatrix, @Nullable CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        this.cloudProjectId = cloudProjectId;
        this.loader = new CloudResultsLoader(cloudProjectId, resultParser.getTestRunListener(), processHandler, bucketName, uniquePrefix, testMatrix);
        this.resultParser = resultParser;
        this.expectedConfigurationInstances = expectedConfigurationInstances;
        this.pollingTicker = new PollingTicker(matrixExecutionCancellator);
        resultParser.getTestRunListener().setTestRunId(testRunId);
    }

    public void startPolling() {
        new Thread(this.pollingTicker).start();
    }

    public Map<String, ConfigurationResult> getResults() {
        return this.results;
    }

    private boolean poll() {
        boolean newDataReceived = this.loader.updateResults(this.results);
        if (newDataReceived) {
            this.pollingTicker.resetTimeout();
        }
        for (ConfigurationResult result : this.results.values()) {
            if (this.markedAsPendingConfigurations.contains(result)) continue;
            this.markedAsPendingConfigurations.add(result);
            this.resultParser.getTestRunListener().testConfigurationStarted(result.getConfigurationInstance().getResultsViewerDisplayString());
        }
        int completedConfigurationInstances = Lists.newArrayList((Iterable)Iterables.filter(this.results.values(), (Predicate)new Predicate<ConfigurationResult>(){

            public boolean apply(ConfigurationResult result) {
                return result.isNoProgressExpected();
            }
        })).size();
        for (ConfigurationResult result : this.results.values()) {
            if (!result.hasResult() || this.publishedConfigurations.contains(result)) continue;
            byte[] inputBytes = this.getParserInput(result);
            this.resultParser.addOutput(inputBytes, 0, inputBytes.length);
            this.publishedConfigurations.add(result);
        }
        for (ConfigurationResult result : this.results.values()) {
            if (!result.isComplete() && !result.isInfrastructureFailure() && !result.isTriggeringError() || this.markedAsFinishedConfigurations.contains(result)) continue;
            this.markedAsFinishedConfigurations.add(result);
            CloudTestingUtils.ConfigurationStopReason stopReason = result.isComplete() ? CloudTestingUtils.ConfigurationStopReason.FINISHED : (result.isInfrastructureFailure() ? CloudTestingUtils.ConfigurationStopReason.INFRASTRUCTURE_FAILURE : CloudTestingUtils.ConfigurationStopReason.TRIGGERING_ERROR);
            this.resultParser.getTestRunListener().stopTestConfiguration(result.getConfigurationInstance().getResultsViewerDisplayString(), stopReason, result.getTestDuration());
        }
        return completedConfigurationInstances >= this.expectedConfigurationInstances.size();
    }

    private void timeoutResultProcessing(boolean allResultsArrived) {
        if (!allResultsArrived) {
            for (String configurationInstance : this.expectedConfigurationInstances) {
                this.resultParser.getTestRunListener().stopTestConfiguration(configurationInstance, CloudTestingUtils.ConfigurationStopReason.TIMED_OUT, -1L);
            }
        }
        this.resultParser.flush();
    }

    private byte[] getParserInput(ConfigurationResult result) {
        String resultString = result.getResult();
        if (resultString.indexOf("\r\n") == -1 && resultString.indexOf(10) != -1) {
            resultString = resultString.replaceAll("\\n", "\r\n");
        }
        String configurationName = "\nINSTRUMENTATION_STATUS: configuration=" + result.getConfigurationInstance().getResultsViewerDisplayString() + "\r\n";
        String classNamePrefix = "INSTRUMENTATION_STATUS: class=";
        return ("\n" + resultString).replaceAll("\\n" + classNamePrefix, configurationName + classNamePrefix).substring(1).getBytes();
    }

    class PollingTicker
    implements Runnable {
        private static final long INITIAL_TIMEOUT = 600000L;
        private static final long DYNAMIC_TIMEOUT = 1800000L;
        private static final int POLLING_INTERVAL = 3000;
        private long stopTime;
        private final CloudMatrixExecutionCancellator matrixExecutionCancellator;

        public PollingTicker(CloudMatrixExecutionCancellator matrixExecutionCancellator) {
            this.matrixExecutionCancellator = matrixExecutionCancellator;
        }

        public void resetTimeout() {
            long newStopTime = System.currentTimeMillis() + 1800000L;
            if (newStopTime > this.stopTime) {
                this.stopTime = newStopTime;
            }
        }

        @Override
        public void run() {
            boolean allResultsArrived = false;
            this.stopTime = System.currentTimeMillis() + 600000L;
            while (!(System.currentTimeMillis() >= this.stopTime || this.matrixExecutionCancellator != null && this.matrixExecutionCancellator.isCancelled() || (allResultsArrived = CloudResultsAdapter.this.poll()))) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            CloudResultsAdapter.this.timeoutResultProcessing(allResultsArrived);
        }
    }
}

