/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.importers.ftrace;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.importers.ImportFeedback;
import trebuchet.importers.Importer;
import trebuchet.importers.ImporterFactory;
import trebuchet.importers.ftrace.FtraceImporterState;
import trebuchet.importers.ftrace.FtraceLine;
import trebuchet.io.DataSlice;
import trebuchet.io.GenericByteBuffer;
import trebuchet.io.StreamingLineReader;
import trebuchet.io.StreamingReader;
import trebuchet.model.fragments.ModelFragment;
import trebuchet.util.StringSearchKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0015J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Ltrebuchet/importers/ftrace/FtraceImporter;", "Ltrebuchet/importers/Importer;", "feedback", "Ltrebuchet/importers/ImportFeedback;", "(Ltrebuchet/importers/ImportFeedback;)V", "coreStartedRegex", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getFeedback", "()Ltrebuchet/importers/ImportFeedback;", "foundHeader", "", "getFoundHeader", "()Z", "setFoundHeader", "(Z)V", "ftraceParserCallback", "Lkotlin/Function1;", "Ltrebuchet/importers/ftrace/FtraceLine;", "", "lineReaderCallback", "Ltrebuchet/io/DataSlice;", "parser", "Ltrebuchet/importers/ftrace/FtraceLine$Parser;", "getParser", "()Ltrebuchet/importers/ftrace/FtraceLine$Parser;", "state", "Ltrebuchet/importers/ftrace/FtraceImporterState;", "getState", "()Ltrebuchet/importers/ftrace/FtraceImporterState;", "setState", "(Ltrebuchet/importers/ftrace/FtraceImporterState;)V", "handleLine", "line", "import", "Ltrebuchet/model/fragments/ModelFragment;", "stream", "Ltrebuchet/io/StreamingReader;", "Factory", "intellij.android.profilers.atrace"})
public final class FtraceImporter
implements Importer {
    private boolean foundHeader;
    @NotNull
    private FtraceImporterState state;
    @NotNull
    private final FtraceLine.Parser parser;
    private final Function1<DataSlice, Unit> lineReaderCallback;
    private Function1<? super FtraceLine, Unit> ftraceParserCallback;
    private final Pattern coreStartedRegex;
    @NotNull
    private final ImportFeedback feedback;

    public final boolean getFoundHeader() {
        return this.foundHeader;
    }

    public final void setFoundHeader(boolean bl) {
        this.foundHeader = bl;
    }

    @NotNull
    public final FtraceImporterState getState() {
        return this.state;
    }

    public final void setState(@NotNull FtraceImporterState ftraceImporterState) {
        this.state = ftraceImporterState;
    }

    @NotNull
    public final FtraceLine.Parser getParser() {
        return this.parser;
    }

    @Override
    @Nullable
    public ModelFragment import(@NotNull StreamingReader stream) {
        StreamingLineReader lineReader = new StreamingLineReader(1024, stream);
        this.foundHeader = false;
        lineReader.forEachLine(this.lineReaderCallback);
        return this.state.finish();
    }

    public final void handleLine(@NotNull DataSlice line) {
        block8: {
            DataSlice this_$iv;
            if (line.getBuffer().length < 2) {
                return;
            }
            DataSlice dataSlice = line;
            int i$iv = 1;
            boolean $i$f$get = false;
            if (this_$iv.getBuffer()[this_$iv.getStartIndex() + i$iv] == (byte)35 && this.coreStartedRegex.matcher(line.toString()).matches()) {
                this.state = new FtraceImporterState(this.feedback);
                this.ftraceParserCallback = (Function1)new Function1<FtraceLine, Unit>(this.state){

                    public final void invoke(@NotNull FtraceLine p1) {
                        ((FtraceImporterState)this.receiver).importLine(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(FtraceImporterState.class);
                    }

                    public final String getName() {
                        return "importLine";
                    }

                    public final String getSignature() {
                        return "importLine(Ltrebuchet/importers/ftrace/FtraceLine;)V";
                    }
                };
            } else {
                this_$iv = line;
                i$iv = 0;
                $i$f$get = false;
                if (this_$iv.getBuffer()[this_$iv.getStartIndex() + i$iv] == (byte)35) {
                    this.foundHeader = true;
                } else if (this.foundHeader) {
                    try {
                        this.parser.parseLine(line, this.ftraceParserCallback);
                    }
                    catch (Exception ex) {
                        CharSequence charSequence = line.toString();
                        boolean bl = false;
                        if (!(!StringsKt.isBlank((CharSequence)charSequence))) break block8;
                        this.feedback.reportImportWarning("Failed to parse: '" + line + '\'');
                        this.feedback.reportImportException(ex);
                    }
                }
            }
        }
    }

    @NotNull
    public final ImportFeedback getFeedback() {
        return this.feedback;
    }

    public FtraceImporter(@NotNull ImportFeedback feedback) {
        this.feedback = feedback;
        this.state = new FtraceImporterState(this.feedback);
        this.parser = new FtraceLine.Parser(this.state.getStringCache());
        this.lineReaderCallback = (Function1)new Function1<DataSlice, Unit>(this){

            public final void invoke(@NotNull DataSlice p1) {
                ((FtraceImporter)this.receiver).handleLine(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(FtraceImporter.class);
            }

            public final String getName() {
                return "handleLine";
            }

            public final String getSignature() {
                return "handleLine(Ltrebuchet/io/DataSlice;)V";
            }
        };
        this.ftraceParserCallback = (Function1)new Function1<FtraceLine, Unit>(this.state){

            public final void invoke(@NotNull FtraceLine p1) {
                ((FtraceImporterState)this.receiver).importLine(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(FtraceImporterState.class);
            }

            public final String getName() {
                return "importLine";
            }

            public final String getSignature() {
                return "importLine(Ltrebuchet/importers/ftrace/FtraceLine;)V";
            }
        };
        this.coreStartedRegex = Pattern.compile("^#+ CPU \\d buffer started #+");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Ltrebuchet/importers/ftrace/FtraceImporter$Factory;", "Ltrebuchet/importers/ImporterFactory;", "()V", "importerFor", "Ltrebuchet/importers/Importer;", "buffer", "Ltrebuchet/io/GenericByteBuffer;", "feedback", "Ltrebuchet/importers/ImportFeedback;", "intellij.android.profilers.atrace"})
    public static final class Factory
    implements ImporterFactory {
        public static final Factory INSTANCE;

        @Override
        @Nullable
        public Importer importerFor(@NotNull GenericByteBuffer buffer, @NotNull ImportFeedback feedback) {
            if (StringSearchKt.contains(buffer, "# tracer: nop\n", 1000)) {
                return new FtraceImporter(feedback);
            }
            return null;
        }

        private Factory() {
        }

        static {
            Factory factory;
            INSTANCE = factory = new Factory();
        }
    }
}

