/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public interface SessionArtifact<T extends GeneratedMessageV3>
extends Updatable {
    public static final String CAPTURING_SUBTITLE = "Recording...";

    @NotNull
    public StudioProfilers getProfilers();

    @NotNull
    public Common.Session getSession();

    @NotNull
    public T getArtifactProto();

    @NotNull
    public Common.SessionMetaData getSessionMetaData();

    @NotNull
    public String getName();

    public long getTimestampNs();

    public boolean isOngoing();

    default public boolean canExport() {
        return false;
    }

    public void onSelect();

    default public void export(@NotNull OutputStream outputStream) {
    }

    default public void update(long elapseNs) {
    }

    public static void navigateTimelineToOngoingCapture(@NotNull StreamingTimeline timeline, long startTimeUs) {
        double viewRange90PercentLength = 0.9 * timeline.getViewRange().getLength();
        double currentOngoingCaptureLength = timeline.getDataRange().getMax() - (double)startTimeUs;
        if (currentOngoingCaptureLength > viewRange90PercentLength) {
            timeline.zoom(currentOngoingCaptureLength - viewRange90PercentLength);
        }
        timeline.setStreaming(true);
        timeline.setIsPaused(false);
    }
}

