/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.httpdata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedMap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class HttpData {
    private final long myId;
    private final long myRequestStartTimeUs;
    private final long myRequestCompleteTimeUs;
    private final long myResponseStartTimeUs;
    private final long myResponseCompleteTimeUs;
    private final long myConnectionEndTimeUs;
    @NotNull
    private final String myUrl;
    @NotNull
    private final String myMethod;
    @NotNull
    private final String myTrace;
    @NotNull
    private final List<JavaThread> myThreads;
    @NotNull
    private final RequestHeader myRequestHeader;
    @NotNull
    private final ResponseHeader myResponseHeader;
    @NotNull
    private final String myRequestPayloadId;
    @NotNull
    private final String myResponsePayloadId;
    private final int myResponsePayloadSize;

    private HttpData(@NotNull Builder builder) {
        this.myId = builder.myId;
        this.myRequestStartTimeUs = builder.myRequestStartTimeUs;
        this.myRequestCompleteTimeUs = builder.myRequestCompleteTimeUs;
        this.myResponseStartTimeUs = builder.myResponseStartTimeUs;
        this.myResponseCompleteTimeUs = builder.myResponseCompleteTimeUs;
        this.myConnectionEndTimeUs = builder.myConnectionEndTimeUs;
        this.myUrl = builder.myUrl;
        this.myMethod = builder.myMethod;
        this.myTrace = builder.myTrace;
        this.myThreads = builder.myThreads;
        this.myResponsePayloadSize = builder.myResponsePayloadSize;
        this.myRequestPayloadId = builder.myRequestPayloadId;
        this.myResponsePayloadId = builder.myResponsePayloadId;
        this.myRequestHeader = new RequestHeader(builder.myRequestFields);
        this.myResponseHeader = new ResponseHeader(builder.myResponseFields);
    }

    public long getId() {
        return this.myId;
    }

    public long getRequestStartTimeUs() {
        return this.myRequestStartTimeUs;
    }

    public long getRequestCompleteTimeUs() {
        return this.myRequestCompleteTimeUs;
    }

    public long getResponseStartTimeUs() {
        return this.myResponseStartTimeUs;
    }

    public long getResponseCompleteTimeUs() {
        return this.myResponseCompleteTimeUs;
    }

    public long getConnectionEndTimeUs() {
        return this.myConnectionEndTimeUs;
    }

    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @NotNull
    public String getMethod() {
        return this.myMethod;
    }

    @NotNull
    public String getTrace() {
        return this.myTrace;
    }

    @NotNull
    public List<JavaThread> getJavaThreads() {
        return this.myThreads;
    }

    @NotNull
    public String getRequestPayloadId() {
        return this.myRequestPayloadId;
    }

    @NotNull
    public String getResponsePayloadId() {
        return this.myResponsePayloadId;
    }

    public int getResponsePayloadSize() {
        return this.myResponsePayloadSize;
    }

    @NotNull
    public RequestHeader getRequestHeader() {
        return this.myRequestHeader;
    }

    @NotNull
    public ResponseHeader getResponseHeader() {
        return this.myResponseHeader;
    }

    @NotNull
    public static String getUrlName(@NotNull String url) {
        try {
            String lastName;
            String name;
            URI uri = URI.create(URLEncoder.encode(url, "UTF-8"));
            String string = name = uri.getPath() != null ? StringUtil.trimTrailing((String)uri.getPath(), (char)'/') : "";
            if (name.isEmpty()) {
                return uri.getHost();
            }
            String string2 = name = name.lastIndexOf(47) != -1 ? name.substring(name.lastIndexOf(47) + 1) : name;
            if (uri.getQuery() != null) {
                name = name + "?" + uri.getQuery();
            }
            do {
                lastName = name;
            } while (!(name = URLUtil.decode((String)name)).equals(lastName));
            return name;
        }
        catch (UnsupportedEncodingException | IllegalArgumentException ignored) {
            int lastSlash = url.lastIndexOf(47, url.length() - 2);
            if (lastSlash >= 0) {
                return url.substring(lastSlash + 1);
            }
            return url;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpData data = (HttpData)o;
        return this.myId == data.myId;
    }

    public int hashCode() {
        return Objects.hash(this.myId);
    }

    public static final class Builder {
        private final long myId;
        private final long myRequestStartTimeUs;
        private final long myRequestCompleteTimeUs;
        private final long myResponseStartTimeUs;
        private final long myResponseCompleteTimeUs;
        private final long myConnectionEndTimeUs;
        private String myUrl = "";
        private String myMethod = "";
        private String myResponseFields = "";
        private String myRequestFields = "";
        private String myResponsePayloadId = "";
        private String myRequestPayloadId = "";
        private int myResponsePayloadSize;
        private String myTrace = "";
        private List<JavaThread> myThreads = new ArrayList<JavaThread>();

        public Builder(long id, long requestStartTimeUs, long requestCompleteTimeUs, long responseStartTimeUs, long responseCompleteTimeUs, long connectionEndTimeUs, List<JavaThread> threads) {
            this.myId = id;
            this.myRequestStartTimeUs = requestStartTimeUs;
            this.myRequestCompleteTimeUs = requestCompleteTimeUs;
            this.myResponseStartTimeUs = responseStartTimeUs;
            this.myResponseCompleteTimeUs = responseCompleteTimeUs;
            this.myConnectionEndTimeUs = connectionEndTimeUs;
            assert (!threads.isEmpty()) : "HttpData.Builder must be initialized with at least one thread";
            threads.forEach(this::addJavaThread);
        }

        @VisibleForTesting
        public Builder(@NotNull HttpData template) {
            this(template.getId(), template.getRequestStartTimeUs(), template.getRequestCompleteTimeUs(), template.getResponseStartTimeUs(), template.getResponseCompleteTimeUs(), template.getConnectionEndTimeUs(), template.getJavaThreads());
            this.setUrl(template.getUrl());
            this.setMethod(template.getMethod());
            this.setTrace(template.getTrace());
        }

        @NotNull
        public Builder setUrl(@NotNull String url) {
            this.myUrl = url;
            return this;
        }

        @NotNull
        public Builder setMethod(@NotNull String method) {
            this.myMethod = method;
            return this;
        }

        @NotNull
        public Builder setTrace(@NotNull String trace) {
            this.myTrace = trace;
            return this;
        }

        @NotNull
        public Builder addJavaThread(@NotNull JavaThread thread2) {
            if (this.myThreads.stream().noneMatch(t -> t.getId() == thread2.getId())) {
                this.myThreads.add(thread2);
            }
            return this;
        }

        @NotNull
        public Builder setResponseFields(@NotNull String responseFields) {
            this.myResponseFields = responseFields;
            return this;
        }

        @NotNull
        public Builder setResponsePayloadId(@NotNull String payloadId) {
            this.myResponsePayloadId = payloadId;
            return this;
        }

        @NotNull
        public Builder setResponsePayloadSize(int payloadSize) {
            this.myResponsePayloadSize = payloadSize;
            return this;
        }

        @NotNull
        public Builder setRequestPayloadId(@NotNull String payloadId) {
            this.myRequestPayloadId = payloadId;
            return this;
        }

        @NotNull
        public Builder setRequestFields(@NotNull String requestFields) {
            this.myRequestFields = requestFields;
            return this;
        }

        @NotNull
        public HttpData build() {
            return new HttpData(this);
        }
    }

    public static final class JavaThread {
        private final long myId;
        @NotNull
        private final String myName;

        public JavaThread(long id, @NotNull String name) {
            this.myId = id;
            this.myName = name;
        }

        public long getId() {
            return this.myId;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }
    }

    public static final class RequestHeader
    extends Header {
        @NotNull
        private final String myRawFields;
        @NotNull
        private final ImmutableSortedMap<String, String> myFields;

        RequestHeader(String fields) {
            this.myRawFields = fields;
            this.myFields = new ImmutableSortedMap.Builder(String.CASE_INSENSITIVE_ORDER).putAll(RequestHeader.parseHeaderFields(fields)).build();
        }

        @NotNull
        public String getRawFields() {
            return this.myRawFields;
        }

        @Override
        @NotNull
        public ImmutableSortedMap<String, String> getFields() {
            return this.myFields;
        }
    }

    public static final class ResponseHeader
    extends Header {
        private static final String STATUS_CODE_NAME = "response-status-code";
        public static final int NO_STATUS_CODE = -1;
        @NotNull
        private final String myRawFields;
        @NotNull
        private final ImmutableSortedMap<String, String> myFields;
        private int myStatusCode = -1;

        ResponseHeader(String fields) {
            Map<String, String> fieldsMap;
            String[] tokens;
            this.myRawFields = fields;
            fields = fields.trim();
            if (fields.isEmpty()) {
                this.myFields = new ImmutableSortedMap.Builder(String.CASE_INSENSITIVE_ORDER).build();
                return;
            }
            String[] firstLineSplit = fields.split("\\n", 2);
            String status = firstLineSplit[0].trim();
            if (!status.isEmpty() && (status = (tokens = status.split("=", 2))[tokens.length - 1].trim()).startsWith("HTTP/1.")) {
                this.myStatusCode = Integer.parseInt(status.split(" ")[1]);
                String string = fields = firstLineSplit.length > 1 ? firstLineSplit[1] : "";
            }
            if ((fieldsMap = ResponseHeader.parseHeaderFields(fields)).containsKey(STATUS_CODE_NAME)) {
                String statusCode = fieldsMap.remove(STATUS_CODE_NAME);
                this.myStatusCode = Integer.parseInt(statusCode);
            }
            assert (this.myStatusCode != -1) : String.format("Unexpected http response (%s)", fields);
            this.myFields = new ImmutableSortedMap.Builder(String.CASE_INSENSITIVE_ORDER).putAll(fieldsMap).build();
        }

        public int getStatusCode() {
            return this.myStatusCode;
        }

        @NotNull
        public String getRawFields() {
            return this.myRawFields;
        }

        @Override
        @NotNull
        public ImmutableSortedMap<String, String> getFields() {
            return this.myFields;
        }
    }

    public static abstract class Header {
        private static final String FIELD_CONTENT_ENCODING = "content-encoding";
        private static final String FIELD_CONTENT_TYPE = "content-type";
        public static final String FIELD_CONTENT_LENGTH = "content-length";

        @NotNull
        public abstract ImmutableSortedMap<String, String> getFields();

        @NotNull
        public String getField(@NotNull String key) {
            return (String)this.getFields().getOrDefault((Object)key, (Object)"");
        }

        @NotNull
        public String getContentEncoding() {
            return this.getField(FIELD_CONTENT_ENCODING);
        }

        @NotNull
        public ContentType getContentType() {
            return new ContentType(this.getField(FIELD_CONTENT_TYPE));
        }

        public int getContentLength() {
            String contentLength = this.getField(FIELD_CONTENT_LENGTH);
            return contentLength.isEmpty() ? -1 : Integer.parseInt(contentLength);
        }

        @NotNull
        protected static Map<String, String> parseHeaderFields(@NotNull String fields) {
            HashMap<String, String> fieldsMap = new HashMap<String, String>();
            Arrays.stream(fields.split("\\n")).filter(line -> !line.trim().isEmpty()).forEach(line -> {
                String[] keyAndValue = line.split("=", 2);
                assert (keyAndValue.length == 2) : String.format("Unexpected http header field (%s)", line);
                fieldsMap.put(keyAndValue[0].trim(), StringUtil.trimEnd((String)keyAndValue[1].trim(), (char)';'));
            });
            return fieldsMap;
        }
    }

    public static final class ContentType {
        public static final String APPLICATION_FORM_MIME_TYPE = "application/x-www-form-urlencoded";
        @NotNull
        private final String myContentType;

        public ContentType(@NotNull String contentType) {
            this.myContentType = contentType;
        }

        public boolean isEmpty() {
            return this.myContentType.isEmpty();
        }

        @NotNull
        public String getMimeType() {
            return this.myContentType.split(";")[0];
        }

        @NotNull
        public String getContentType() {
            return this.myContentType;
        }

        public String toString() {
            return this.getContentType();
        }

        public boolean isFormData() {
            return this.getMimeType().equalsIgnoreCase(APPLICATION_FORM_MIME_TYPE);
        }
    }
}

