/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.network.NetworkOpenConnectionsDataSeries;
import com.android.tools.profilers.network.NetworkUsage;
import org.jetbrains.annotations.NotNull;

public class DetailedNetworkUsage
extends NetworkUsage {
    @NotNull
    private final Range myConnectionsRange;
    @NotNull
    private final RangedContinuousSeries myConnectionSeries;

    public DetailedNetworkUsage(@NotNull StudioProfilers profilers) {
        super(profilers);
        Range viewRange = profilers.getTimeline().getViewRange();
        this.myConnectionsRange = new Range(0.0, 5.0);
        this.myConnectionSeries = new RangedContinuousSeries("Connections", viewRange, this.myConnectionsRange, DetailedNetworkUsage.createOpenConnectionsSeries(profilers));
        this.add(this.myConnectionSeries);
    }

    @NotNull
    private static DataSeries<Long> createOpenConnectionsSeries(@NotNull StudioProfilers profilers) {
        if (profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            return new UnifiedEventDataSeries<Long>(profilers.getClient().getTransportClient(), profilers.getSession().getStreamId(), profilers.getSession().getPid(), Common.Event.Kind.NETWORK_CONNECTION_COUNT, 0, UnifiedEventDataSeries.fromFieldToDataExtractor(event -> event.getNetworkConnections().getNumConnections()));
        }
        NetworkServiceGrpc.NetworkServiceBlockingStub client = profilers.getClient().getNetworkClient();
        return new NetworkOpenConnectionsDataSeries(client, profilers.getSession());
    }

    @NotNull
    public Range getConnectionsRange() {
        return this.myConnectionsRange;
    }

    @NotNull
    public RangedContinuousSeries getConnectionSeries() {
        return this.myConnectionSeries;
    }
}

