/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.chart;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.profilers.ChartTooltipViewBase;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet;
import com.android.tools.profilers.memory.chart.ClassifierSetHNode;
import com.android.tools.profilers.memory.chart.VisualizationTooltipModel;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/memory/chart/MemoryVisualizationTooltipView;", "Lcom/android/tools/profilers/ChartTooltipViewBase;", "Lcom/android/tools/profilers/memory/chart/ClassifierSetHNode;", "chart", "Lcom/android/tools/adtui/chart/hchart/HTreeChart;", "tooltipRoot", "Ljavax/swing/JLayeredPane;", "model", "Lcom/android/tools/profilers/memory/chart/VisualizationTooltipModel;", "(Lcom/android/tools/adtui/chart/hchart/HTreeChart;Ljavax/swing/JLayeredPane;Lcom/android/tools/profilers/memory/chart/VisualizationTooltipModel;)V", "showTooltip", "", "node", "intellij.android.profilers.ui"})
public final class MemoryVisualizationTooltipView
extends ChartTooltipViewBase<ClassifierSetHNode> {
    private final VisualizationTooltipModel model;

    @Override
    public void showTooltip(@NotNull ClassifierSetHNode node) {
        this.getTooltipContainer().removeAll();
        JLabel nameLabel = new JLabel(node.getName());
        nameLabel.setFont(TooltipView.TOOLTIP_BODY_FONT);
        nameLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        String formattedNumber = this.model.getVisualizationModel().formatter().getFormattedString(this.model.getCaptureRange().getLength(), (double)node.getDuration(), this.model.getVisualizationModel().isSizeAxis());
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        CharSequence charSequence = "%s: %s";
        Object object = new Object[]{this.model.getVisualizationModel().isSizeAxis() ? "Size" : "Count", formattedNumber};
        boolean bl = false;
        String string = String.format((String)charSequence, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
        JLabel totalLabel = new JLabel(string);
        this.getTooltipContainer().add((Component)nameLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        if (node.getData() instanceof NativeCallStackSet) {
            ClassifierSet classifierSet = node.getData();
            if (classifierSet == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet");
            }
            NativeCallStackSet nativeCallStackSet = (NativeCallStackSet)classifierSet;
            JPanel jPanel = this.getTooltipContainer();
            charSequence = StringCompanionObject.INSTANCE;
            object = "Module: %s";
            Object[] objectArray = new Object[]{nativeCallStackSet.getModuleName()};
            boolean bl2 = false;
            String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            jPanel.add((Component)new JLabel(string2), new TabularLayout.Constraint(this.getTooltipContainer().getComponentCount(), 0, 0, 4, null));
            charSequence = nativeCallStackSet.getFileName();
            boolean bl3 = false;
            if (charSequence.length() > 0) {
                JPanel jPanel2 = this.getTooltipContainer();
                charSequence = StringCompanionObject.INSTANCE;
                String string3 = "File: %s";
                objectArray = new Object[]{nativeCallStackSet.getFileName()};
                bl2 = false;
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                jPanel2.add((Component)new JLabel(string4), new TabularLayout.Constraint(this.getTooltipContainer().getComponentCount(), 0, 0, 4, null));
            }
        }
        this.getTooltipContainer().add((Component)AdtUiUtils.createHorizontalSeparator(), new TabularLayout.Constraint(this.getTooltipContainer().getComponentCount(), 0, 0, 4, null));
        this.getTooltipContainer().add((Component)totalLabel, new TabularLayout.Constraint(this.getTooltipContainer().getComponentCount(), 0, 0, 4, null));
    }

    public MemoryVisualizationTooltipView(@NotNull HTreeChart<ClassifierSetHNode> chart, @NotNull JLayeredPane tooltipRoot, @NotNull VisualizationTooltipModel model) {
        super(chart, tooltipRoot);
        this.model = model;
    }
}

