/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeAllocationMethodSet;
import com.android.tools.profilers.memory.adapters.classifiers.NativeCallStackSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NativeFunctionClassifier
extends Classifier {
    @NotNull
    private final Map<Memory.AllocationStack.StackFrame, NativeCallStackSet> myFunctions = new LinkedHashMap<Memory.AllocationStack.StackFrame, NativeCallStackSet>();
    @NotNull
    private final Map<String, NativeAllocationMethodSet> myAllocations = new LinkedHashMap<String, NativeAllocationMethodSet>();
    private final int myDepth;

    NativeFunctionClassifier(int depth) {
        this.myDepth = depth;
    }

    @Override
    @Nullable
    public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
        Memory.AllocationStack.StackFrame function = this.getFrameAtCurrentDepth(instance);
        if (function != null) {
            NativeCallStackSet methodSet = this.myFunctions.get(function);
            if (methodSet == null && createIfAbsent) {
                methodSet = new NativeCallStackSet(function, this.myDepth + 1);
                this.myFunctions.put(function, methodSet);
            }
            return methodSet;
        }
        String name = instance.getClassEntry().getClassName();
        NativeAllocationMethodSet allocation = this.myAllocations.get(name);
        if (allocation == null && createIfAbsent) {
            allocation = new NativeAllocationMethodSet(name);
            this.myAllocations.put(name, allocation);
        }
        return allocation;
    }

    @Nullable
    private Memory.AllocationStack.StackFrame getFrameAtCurrentDepth(@NotNull InstanceObject instance) {
        int stackDepth = instance.getCallStackDepth();
        Memory.AllocationStack stack = instance.getAllocationCallStack();
        if (stackDepth <= 0 || this.myDepth >= stackDepth || stack == null) {
            return null;
        }
        int frameIndex = stackDepth - this.myDepth - 1;
        Memory.AllocationStack.StackFrameWrapper fullStack = stack.getFullStack();
        Memory.AllocationStack.StackFrame stackFrame = fullStack.getFrames(frameIndex);
        return stackFrame;
    }

    @Override
    @NotNull
    public List<ClassifierSet> getFilteredClassifierSets() {
        return Stream.concat(this.myFunctions.values().stream(), this.myAllocations.values().stream()).filter(child -> !child.getIsFiltered()).collect(Collectors.toList());
    }

    @Override
    @NotNull
    protected List<ClassifierSet> getAllClassifierSets() {
        return Stream.concat(this.myFunctions.values().stream(), this.myAllocations.values().stream()).collect(Collectors.toList());
    }
}

