/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.google.common.base.Strings;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSet
extends ClassifierSet {
    @NotNull
    private final MethodSetInfo myMethodInfo;
    @NotNull
    private final CaptureObject myCaptureObject;
    private final int myCallstackDepth;

    @NotNull
    public static Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        return new MethodClassifier(captureObject, 0);
    }

    public MethodSet(@NotNull CaptureObject captureObject, @NotNull MethodSetInfo methodInfo, int callstackDepth) {
        super(() -> methodInfo.getName());
        this.myCaptureObject = captureObject;
        this.myMethodInfo = methodInfo;
        this.myCallstackDepth = callstackDepth;
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        return new MethodClassifier(this.myCaptureObject, this.myCallstackDepth);
    }

    @NotNull
    public String getClassName() {
        return this.myMethodInfo.getClassName();
    }

    @NotNull
    public String getMethodName() {
        return this.myMethodInfo.getMethodName();
    }

    private static final class MethodSetInfo {
        static final long INVALID_METHOD_ID = -1L;
        @NotNull
        private final CaptureObject myCaptureObject;
        private long myMethodId;
        @Nullable
        private String myClassName;
        @Nullable
        private String myMethodName;
        private boolean myResolvedNames;
        private int myHashCode;

        MethodSetInfo(@NotNull CaptureObject captureObject, @NotNull String className, @NotNull String methodName) {
            this.myCaptureObject = captureObject;
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myMethodId = -1L;
            this.myHashCode = Arrays.hashCode(new int[]{this.myClassName.hashCode(), this.myMethodName.hashCode()});
            this.myResolvedNames = true;
        }

        MethodSetInfo(@NotNull CaptureObject captureObject, long methodId) {
            this.myCaptureObject = captureObject;
            this.myMethodId = methodId;
            this.myHashCode = Long.hashCode(this.myMethodId);
            this.myResolvedNames = false;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodSetInfo)) {
                return false;
            }
            MethodSetInfo other = (MethodSetInfo)obj;
            if (this.myMethodId == -1L) {
                return StringUtil.equals((CharSequence)this.myClassName, (CharSequence)other.myClassName) && StringUtil.equals((CharSequence)this.myMethodName, (CharSequence)other.myMethodName);
            }
            return this.myMethodId == other.myMethodId;
        }

        @NotNull
        String getName() {
            this.resolveNames();
            StringBuilder builder = new StringBuilder();
            if (this.myMethodName != null) {
                builder.append(this.myMethodName).append("()");
            } else {
                builder.append("<unknown method>");
            }
            if (!Strings.isNullOrEmpty((String)this.myClassName)) {
                builder.append(" (").append(this.myClassName).append(")");
            }
            return builder.toString();
        }

        @NotNull
        String getClassName() {
            this.resolveNames();
            return this.myClassName;
        }

        @NotNull
        String getMethodName() {
            this.resolveNames();
            return this.myMethodName;
        }

        private void resolveNames() {
            if (this.myResolvedNames) {
                return;
            }
            assert (this.myMethodId != -1L);
            Memory.AllocationStack.StackFrame frameInfo = this.myCaptureObject.getStackFrame(this.myMethodId);
            assert (frameInfo != null);
            this.myClassName = frameInfo.getClassName();
            this.myMethodName = frameInfo.getMethodName();
            this.myResolvedNames = true;
        }
    }

    private static final class MethodClassifier
    extends Classifier {
        @NotNull
        private final CaptureObject myCaptureObject;
        @NotNull
        private final Map<MethodSetInfo, MethodSet> myStackLineMap = new LinkedHashMap<MethodSetInfo, MethodSet>();
        @NotNull
        private final Map<ClassDb.ClassEntry, ClassSet> myClassMap = new LinkedHashMap<ClassDb.ClassEntry, ClassSet>();
        private final int myDepth;

        private MethodClassifier(@NotNull CaptureObject captureObject, int depth) {
            this.myCaptureObject = captureObject;
            this.myDepth = depth;
        }

        @Override
        @Nullable
        public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
            MethodSetInfo methodInfo = this.getMethodInfo(instance);
            if (methodInfo != null) {
                MethodSet methodSet = this.myStackLineMap.get(methodInfo);
                if (methodSet == null && createIfAbsent) {
                    methodSet = new MethodSet(this.myCaptureObject, methodInfo, this.myDepth + 1);
                    this.myStackLineMap.put(methodInfo, methodSet);
                }
                return methodSet;
            }
            ClassDb.ClassEntry classEntry = instance.getClassEntry();
            ClassSet classSet = this.myClassMap.get(classEntry);
            if (classSet == null && createIfAbsent) {
                classSet = new ClassSet(classEntry);
                this.myClassMap.put(classEntry, classSet);
            }
            return classSet;
        }

        @Nullable
        private MethodSetInfo getMethodInfo(@NotNull InstanceObject instance) {
            int stackDepth = instance.getCallStackDepth();
            if (stackDepth <= 0 || this.myDepth >= stackDepth) {
                return null;
            }
            int frameIndex = stackDepth - this.myDepth - 1;
            Memory.AllocationStack stack = instance.getAllocationCallStack();
            if (stack != null) {
                switch (stack.getFrameCase()) {
                    case FULL_STACK: {
                        Memory.AllocationStack.StackFrameWrapper fullStack = stack.getFullStack();
                        Memory.AllocationStack.StackFrame stackFrame = fullStack.getFrames(frameIndex);
                        return new MethodSetInfo(this.myCaptureObject, stackFrame.getClassName(), stackFrame.getMethodName());
                    }
                    case ENCODED_STACK: {
                        Memory.AllocationStack.EncodedFrameWrapper smallStack = stack.getEncodedStack();
                        Memory.AllocationStack.EncodedFrame smallFrame = smallStack.getFrames(frameIndex);
                        return new MethodSetInfo(this.myCaptureObject, smallFrame.getMethodId());
                    }
                }
                throw new UnsupportedOperationException();
            }
            assert (frameIndex >= 0 && frameIndex < stackDepth);
            CodeLocation location = instance.getAllocationCodeLocations().get(frameIndex);
            return new MethodSetInfo(this.myCaptureObject, Strings.nullToEmpty((String)location.getClassName()), Strings.nullToEmpty((String)location.getMethodName()));
        }

        @Override
        @NotNull
        public List<ClassifierSet> getFilteredClassifierSets() {
            return Stream.concat(this.myStackLineMap.values().stream(), this.myClassMap.values().stream()).filter(child -> !child.getIsFiltered()).collect(Collectors.toList());
        }

        @Override
        @NotNull
        protected List<ClassifierSet> getAllClassifierSets() {
            return Stream.concat(this.myStackLineMap.values().stream(), this.myClassMap.values().stream()).collect(Collectors.toList());
        }
    }
}

