/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.CachedFunction;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassifierSet
implements MemoryObject {
    @Nullable
    private String myName;
    @Nullable
    private Supplier<String> myNameSupplier = null;
    @NotNull
    protected final Set<InstanceObject> mySnapshotInstances = new LinkedHashSet<InstanceObject>(0);
    @NotNull
    protected final Set<InstanceObject> myDeltaInstances = new LinkedHashSet<InstanceObject>(0);
    @Nullable
    protected Classifier myClassifier = null;
    private int myObjectSetCount = 0;
    private int myFilteredObjectSetCount = 0;
    private int mySnapshotObjectCount = 0;
    private int myDeltaAllocations = 0;
    private int myDeltaDeallocations = 0;
    private long myDeltaAllocationsSize = 0L;
    private long myDeltaDeallocationsSize = 0L;
    private long myTotalNativeSize = 0L;
    private long myTotalShallowSize = 0L;
    private long myTotalRetainedSize = 0L;
    private int myInstancesWithStackInfoCount = 0;
    protected int myFilterMatchCount = 0;
    private final CachedFunction<CaptureObjectInstanceFilter, Integer> myInstanceFilterMatchCounter = new CachedFunction(this::countInstanceFilterMatch, new IdentityHashMap());
    protected boolean myIsFiltered;
    protected boolean myIsMatched;
    protected boolean myNeedsRefiltering;

    public ClassifierSet(@NotNull String name) {
        this.myName = name;
    }

    public ClassifierSet(@NotNull Supplier<String> nameSupplier) {
        this.myNameSupplier = nameSupplier;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            assert (this.myNameSupplier != null);
            this.myName = this.myNameSupplier.get();
        }
        return this.myName;
    }

    public final boolean isEmpty() {
        return this.mySnapshotObjectCount == 0 && this.myDeltaAllocations == 0 && this.myDeltaDeallocations == 0;
    }

    public final int getTotalObjectCount() {
        return this.mySnapshotObjectCount + this.myDeltaAllocations - this.myDeltaDeallocations;
    }

    public final int getTotalObjectSetCount() {
        return this.myObjectSetCount;
    }

    public final int getFilteredObjectSetCount() {
        return this.myFilteredObjectSetCount;
    }

    public final int getDeltaAllocationCount() {
        return this.myDeltaAllocations;
    }

    public final int getDeltaDeallocationCount() {
        return this.myDeltaDeallocations;
    }

    public final long getTotalRetainedSize() {
        return this.myTotalRetainedSize;
    }

    public final long getTotalShallowSize() {
        return this.myTotalShallowSize;
    }

    public final long getTotalNativeSize() {
        return this.myTotalNativeSize;
    }

    public final int getFilterMatchCount() {
        return this.myFilterMatchCount;
    }

    public final long getAllocationSize() {
        return this.myDeltaAllocationsSize;
    }

    public final long getDeallocationSize() {
        return this.myDeltaDeallocationsSize;
    }

    public final long getTotalRemainingSize() {
        return this.getAllocationSize() - this.getDeallocationSize();
    }

    public final int getInstanceFilterMatchCount(CaptureObjectInstanceFilter filter) {
        return this.myInstanceFilterMatchCounter.invoke(filter);
    }

    public void addSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        this.changeSnapshotInstanceObject(instanceObject, true, Set::add);
    }

    public void removeSnapshotInstanceObject(@NotNull InstanceObject instanceObject) {
        this.changeSnapshotInstanceObject(instanceObject, false, Set::remove);
    }

    private void changeSnapshotInstanceObject(@NotNull InstanceObject instanceObject, boolean isAdding, BiConsumer<Set<InstanceObject>, InstanceObject> handler) {
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            ClassifierSet classifierSet = this.myClassifier.getClassifierSet(instanceObject, isAdding);
            assert (classifierSet != null);
            classifierSet.changeSnapshotInstanceObject(instanceObject, isAdding, handler);
        } else {
            assert (isAdding == !this.mySnapshotInstances.contains(instanceObject));
            handler.accept(this.mySnapshotInstances, instanceObject);
        }
        int unit = isAdding ? 1 : -1;
        this.mySnapshotObjectCount += unit;
        this.myTotalNativeSize += (long)unit * ClassifierSet.validOrZero(instanceObject.getNativeSize());
        this.myTotalShallowSize += (long)unit * ClassifierSet.validOrZero(instanceObject.getShallowSize());
        this.myTotalRetainedSize += (long)unit * ClassifierSet.validOrZero(instanceObject.getRetainedSize());
        if (!instanceObject.isCallStackEmpty()) {
            this.myInstancesWithStackInfoCount += unit;
        }
        this.myInstanceFilterMatchCounter.invalidate();
        this.myNeedsRefiltering = true;
    }

    public boolean addDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.changeDeltaInstanceInformation(instanceObject, true, true, Set::add);
    }

    public boolean freeDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.changeDeltaInstanceInformation(instanceObject, false, true, Set::add);
    }

    public boolean removeAddedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.changeDeltaInstanceInformation(instanceObject, true, false, Set::remove);
    }

    public boolean removeFreedDeltaInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.changeDeltaInstanceInformation(instanceObject, false, false, Set::remove);
    }

    private boolean changeDeltaInstanceInformation(@NotNull InstanceObject instanceObject, boolean isAllocation, boolean isAdding, BiConsumer<Set<InstanceObject>, InstanceObject> handler) {
        int unit;
        boolean instanceChanged = false;
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            ClassifierSet classifierSet = this.myClassifier.getClassifierSet(instanceObject, isAdding);
            assert (classifierSet != null);
            instanceChanged = classifierSet.changeDeltaInstanceInformation(instanceObject, isAllocation, isAdding, handler);
        } else if ((isAdding || !instanceObject.hasTimeData()) && isAdding == !this.myDeltaInstances.contains(instanceObject)) {
            handler.accept(this.myDeltaInstances, instanceObject);
            instanceChanged = true;
        }
        int n = unit = isAdding ? 1 : -1;
        if (isAllocation) {
            this.myDeltaAllocations += unit * instanceObject.getInstanceCount();
            this.myDeltaAllocationsSize += (long)(unit * instanceObject.getShallowSize());
        } else {
            this.myDeltaDeallocations += unit * instanceObject.getInstanceCount();
            this.myDeltaDeallocationsSize += (long)(unit * instanceObject.getShallowSize());
        }
        int factor = unit * (isAllocation ? 1 : -1);
        this.myTotalNativeSize += (long)factor * ClassifierSet.validOrZero(instanceObject.getNativeSize());
        this.myTotalShallowSize += (long)factor * ClassifierSet.validOrZero(instanceObject.getShallowSize());
        this.myTotalRetainedSize += (long)factor * ClassifierSet.validOrZero(instanceObject.getRetainedSize());
        if (instanceChanged && !instanceObject.isCallStackEmpty()) {
            this.myInstancesWithStackInfoCount += unit;
            this.myNeedsRefiltering = true;
        }
        if (instanceChanged) {
            this.myInstanceFilterMatchCounter.invalidate();
        }
        return instanceChanged;
    }

    public void clearClassifierSets() {
        this.mySnapshotInstances.clear();
        this.myDeltaInstances.clear();
        this.myClassifier = this.createSubClassifier();
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myObjectSetCount = 0;
        this.myFilteredObjectSetCount = 0;
        this.myFilterMatchCount = 0;
    }

    public int getInstancesCount() {
        return (int)this.getInstancesStream().count();
    }

    @NotNull
    public Stream<InstanceObject> getInstancesStream() {
        return this.getStreamOf(me -> Stream.concat(me.mySnapshotInstances.stream(), me.myDeltaInstances.stream()).distinct());
    }

    @NotNull
    protected Stream<InstanceObject> getDeltaInstanceStream() {
        return this.getStreamOf(me -> me.myDeltaInstances.stream());
    }

    @NotNull
    protected Stream<InstanceObject> getSnapshotInstanceStream() {
        return this.getStreamOf(me -> me.mySnapshotInstances.stream());
    }

    public Stream<InstanceObject> getFilterMatches() {
        return this.getStreamOf(me -> me.getIsMatched() ? me.getInstancesStream() : Stream.empty());
    }

    private Stream<InstanceObject> getStreamOf(Function<ClassifierSet, Stream<InstanceObject>> extractor) {
        return this.myClassifier == null ? extractor.apply(this) : Stream.concat(this.myClassifier.getAllClassifierSets().stream().flatMap(sub -> sub.getStreamOf(extractor)), extractor.apply(this));
    }

    public boolean hasStackInfo() {
        return this.myInstancesWithStackInfoCount > 0;
    }

    @NotNull
    public List<ClassifierSet> getChildrenClassifierSets() {
        this.ensurePartition();
        assert (this.myClassifier != null);
        return this.myClassifier.getFilteredClassifierSets();
    }

    @Nullable
    public ClassifierSet findContainingClassifierSet(@NotNull InstanceObject target) {
        boolean instancesContainsTarget = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).anyMatch(target::equals);
        if (instancesContainsTarget && this.myClassifier != null) {
            return this;
        }
        if (instancesContainsTarget || this.myClassifier != null) {
            List<ClassifierSet> childrenClassifierSets = this.getChildrenClassifierSets();
            boolean stillContainsTarget = Stream.concat(this.mySnapshotInstances.stream(), this.myDeltaInstances.stream()).anyMatch(target::equals);
            if (instancesContainsTarget && stillContainsTarget) {
                return this;
            }
            for (ClassifierSet set : childrenClassifierSets) {
                ClassifierSet result = set.findContainingClassifierSet(target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public ClassifierSet findClassifierSet(@NotNull Predicate<ClassifierSet> pred) {
        if (pred.test(this)) {
            return this;
        }
        if (this.myClassifier != null) {
            return this.getChildrenClassifierSets().stream().map(s -> s.findClassifierSet(pred)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    public boolean isSupersetOf(Set<InstanceObject> targetSet) {
        return this.getNonMembers(targetSet).isEmpty();
    }

    private Set<InstanceObject> getNonMembers(Set<InstanceObject> instances) {
        Set<InstanceObject> remainders = Collections.newSetFromMap(new IdentityHashMap());
        for (InstanceObject inst : instances) {
            if (this.myDeltaInstances.contains(inst) || this.mySnapshotInstances.contains(inst)) continue;
            remainders.add(inst);
        }
        if (this.myClassifier != null && !remainders.isEmpty()) {
            for (ClassifierSet child : this.myClassifier.getAllClassifierSets()) {
                remainders.retainAll(child.getNonMembers(remainders));
                if (!remainders.isEmpty()) continue;
                return remainders;
            }
        }
        return remainders;
    }

    protected void ensurePartition() {
        if (this.myClassifier == null) {
            this.myClassifier = this.createSubClassifier();
            this.myClassifier.partition(this.mySnapshotInstances, this.myDeltaInstances);
        }
    }

    @NotNull
    protected abstract Classifier createSubClassifier();

    public boolean getIsFiltered() {
        return this.isEmpty() || this.myIsFiltered;
    }

    public boolean getIsMatched() {
        return this.myIsMatched;
    }

    protected void applyFilter(@NotNull Filter filter, boolean hasMatchedAncestor, boolean filterChanged) {
        if (!filterChanged && !this.myNeedsRefiltering) {
            return;
        }
        this.myIsFiltered = true;
        this.ensurePartition();
        this.mySnapshotObjectCount = 0;
        this.myDeltaAllocations = 0;
        this.myDeltaDeallocations = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalNativeSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
        this.myObjectSetCount = this.myClassifier.getAllClassifierSets().size();
        this.myFilteredObjectSetCount = 0;
        this.myIsMatched = this.matches(filter);
        int n = this.myFilterMatchCount = this.myIsMatched ? 1 : 0;
        assert (this.myClassifier != null);
        for (ClassifierSet classifierSet : this.myClassifier.getAllClassifierSets()) {
            classifierSet.applyFilter(filter, hasMatchedAncestor || this.myIsMatched, filterChanged);
            this.myObjectSetCount += classifierSet.myObjectSetCount;
            if (classifierSet.getIsFiltered()) continue;
            this.myIsFiltered = false;
            this.mySnapshotObjectCount += classifierSet.mySnapshotObjectCount;
            this.myDeltaAllocations += classifierSet.myDeltaAllocations;
            this.myDeltaDeallocations += classifierSet.myDeltaDeallocations;
            this.myTotalShallowSize += classifierSet.myTotalShallowSize;
            this.myTotalNativeSize += classifierSet.myTotalNativeSize;
            this.myTotalRetainedSize += classifierSet.myTotalRetainedSize;
            this.myInstancesWithStackInfoCount += classifierSet.myInstancesWithStackInfoCount;
            this.myFilterMatchCount += classifierSet.myFilterMatchCount;
            ++this.myFilteredObjectSetCount;
        }
        this.myNeedsRefiltering = false;
    }

    protected boolean matches(@NotNull Filter filter) {
        return filter.matches(this.getName());
    }

    private int countInstanceFilterMatch(CaptureObjectInstanceFilter filter) {
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            return this.myClassifier.getAllClassifierSets().stream().mapToInt(s -> s.getInstanceFilterMatchCount(filter)).sum();
        }
        int total = 0;
        for (InstanceObject inst : this.myDeltaInstances) {
            if (!((Boolean)filter.getInstanceTest().invoke((Object)inst)).booleanValue()) continue;
            ++total;
        }
        for (InstanceObject inst : this.mySnapshotInstances) {
            if (this.myDeltaInstances.contains(inst) || !((Boolean)filter.getInstanceTest().invoke((Object)inst)).booleanValue()) continue;
            ++total;
        }
        return total;
    }

    private static long validOrZero(long value) {
        return value == -1L ? 0L : value;
    }
}

