/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.JniReferenceInstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.ThreadId;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveAllocationInstanceObject
implements InstanceObject {
    @NotNull
    private final LiveAllocationCaptureObject myCaptureObject;
    @NotNull
    private final ClassDb.ClassEntry myClassEntry;
    @NotNull
    private final ValueObject.ValueType myValueType;
    private long myAllocTime = Long.MIN_VALUE;
    private long myDeallocTime = Long.MAX_VALUE;
    private final long mySize;
    private final int myHeapId;
    @Nullable
    private Memory.AllocationStack myCallstack;
    @Nullable
    private final ThreadId myThreadId;
    @Nullable
    private TLongObjectHashMap<JniReferenceInstanceObject> myJniRefs = null;

    public LiveAllocationInstanceObject(@NotNull LiveAllocationCaptureObject captureObject, @NotNull ClassDb.ClassEntry classEntry, @Nullable ThreadId threadId, @Nullable Memory.AllocationStack callstack, long size, int heapId) {
        this.myCaptureObject = captureObject;
        this.myClassEntry = classEntry;
        this.mySize = size;
        this.myHeapId = heapId;
        this.myThreadId = threadId == null ? ThreadId.INVALID_THREAD_ID : threadId;
        this.myCallstack = callstack;
        this.myValueType = "java.lang.String".equals(classEntry.getClassName()) ? ValueObject.ValueType.STRING : (classEntry.getClassName().endsWith("[]") ? ValueObject.ValueType.ARRAY : ValueObject.ValueType.OBJECT);
    }

    @Override
    public long getAllocTime() {
        return this.myAllocTime;
    }

    public void setDeallocTime(long deallocTime) {
        this.myDeallocTime = deallocTime;
    }

    public void setAllocationTime(long allocTime) {
        this.myAllocTime = allocTime;
    }

    @Override
    public long getDeallocTime() {
        return this.myDeallocTime;
    }

    @Override
    public boolean hasTimeData() {
        return this.hasAllocTime() || this.hasDeallocTime();
    }

    @Override
    public boolean hasAllocTime() {
        return this.myAllocTime != Long.MIN_VALUE;
    }

    @Override
    public boolean hasDeallocTime() {
        return this.myDeallocTime != Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    public int getHeapId() {
        return this.myHeapId;
    }

    @Override
    public int getShallowSize() {
        return (int)this.mySize;
    }

    @Override
    @Nullable
    public Memory.AllocationStack getAllocationCallStack() {
        return this.myCallstack;
    }

    @Override
    @NotNull
    public List<CodeLocation> getAllocationCodeLocations() {
        ArrayList<CodeLocation> codeLocations = new ArrayList<CodeLocation>();
        if (this.myCallstack != null && this.myCallstack.getFrameCase() == Memory.AllocationStack.FrameCase.ENCODED_STACK) {
            Memory.AllocationStack.EncodedFrameWrapper encodedFrames = this.myCallstack.getEncodedStack();
            for (Memory.AllocationStack.EncodedFrame frame : encodedFrames.getFramesList()) {
                Memory.AllocationStack.StackFrame resolvedFrame = this.myCaptureObject.getStackFrame(frame.getMethodId());
                CodeLocation.Builder builder = new CodeLocation.Builder(resolvedFrame.getClassName()).setMethodName(resolvedFrame.getMethodName()).setLineNumber(frame.getLineNumber() - 1);
                codeLocations.add(builder.build());
            }
        }
        return codeLocations;
    }

    @Override
    @NotNull
    public ThreadId getAllocationThreadId() {
        return this.myThreadId;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        return this.myClassEntry;
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        return this.myValueType;
    }

    @Override
    @NotNull
    public String getValueText() {
        return this.myClassEntry.getSimpleClassName();
    }

    @Nullable
    public JniReferenceInstanceObject getJniRefByValue(long refValue) {
        if (this.myJniRefs == null) {
            return null;
        }
        return (JniReferenceInstanceObject)this.myJniRefs.get(refValue);
    }

    public void addJniRef(@NotNull JniReferenceInstanceObject ref) {
        if (this.myJniRefs == null) {
            this.myJniRefs = new TLongObjectHashMap();
        }
        this.myJniRefs.put(ref.getRefValue(), (Object)ref);
    }

    public void removeJniRef(@NotNull JniReferenceInstanceObject ref) {
        if (this.myJniRefs == null) {
            return;
        }
        this.myJniRefs.remove(ref.getRefValue());
    }
}

