/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.JniReferenceInstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationInstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongObjectHashMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveAllocationCaptureObject
implements CaptureObject {
    private static final long QUERY_BUFFER_NS = TimeUnit.SECONDS.toNanos(5L);
    @VisibleForTesting
    static final String SAMPLING_INFO_MESSAGE = "Selected region does not have full tracking. Data may be inaccurate.";
    @NotNull
    private final MemoryProfilerStage myStage;
    @VisibleForTesting
    final ExecutorService myExecutorService;
    private final ClassDb myClassDb;
    private final TIntObjectHashMap<LiveAllocationInstanceObject> myInstanceMap;
    private final TIntObjectHashMap<Memory.AllocationStack> myCallstackMap;
    @NotNull
    private final TLongObjectHashMap<Memory.NativeCallStack.NativeFrame> myNativeFrameMap;
    private final TLongObjectHashMap<Memory.AllocationStack.StackFrame> myMethodIdMap;
    private final TIntObjectHashMap<ThreadId> myThreadIdMap;
    private final TreeMap<Long, Memory.MemoryMap.MemoryRegion> myJniMemoryRegionMap;
    private final ProfilerClient myClient;
    private final Common.Session mySession;
    private final long myCaptureStartTime;
    private final List<HeapSet> myHeapSets;
    private final AspectObserver myAspectObserver;
    private final boolean myEnableJniRefsTracking;
    private long myContextEndTimeNs = Long.MIN_VALUE;
    private long myPreviousQueryStartTimeNs = Long.MIN_VALUE;
    private long myPreviousQueryEndTimeNs = Long.MIN_VALUE;
    private long myLastSeenTimestampNs = Long.MIN_VALUE;
    private Range myQueryRange;
    private Future myCurrentTask;
    @Nullable
    private String myInfoMessage;

    private static Logger getLogger() {
        return Logger.getInstance(LiveAllocationCaptureObject.class);
    }

    public LiveAllocationCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session session, long captureStartTime, @Nullable ExecutorService loadService, @NotNull MemoryProfilerStage stage) {
        this.myExecutorService = loadService == null ? Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("profiler-live-allocation").build()) : loadService;
        this.myClassDb = new ClassDb();
        this.myInstanceMap = new TIntObjectHashMap();
        this.myCallstackMap = new TIntObjectHashMap();
        this.myNativeFrameMap = new TLongObjectHashMap();
        this.myMethodIdMap = new TLongObjectHashMap();
        this.myThreadIdMap = new TIntObjectHashMap();
        this.myJniMemoryRegionMap = new TreeMap();
        this.myClient = client;
        this.mySession = session;
        this.myCaptureStartTime = captureStartTime;
        this.myAspectObserver = new AspectObserver();
        this.myStage = stage;
        this.myHeapSets = new ArrayList<HeapSet>(Arrays.asList(new HeapSet(this, "default", 0), new HeapSet(this, "image", 1), new HeapSet(this, "zygote", 2), new HeapSet(this, "app", 3)));
        this.myEnableJniRefsTracking = stage.getStudioProfilers().getIdeServices().getFeatureConfig().isJniReferenceTrackingEnabled();
        if (this.myEnableJniRefsTracking) {
            this.myHeapSets.add(new HeapSet(this, "JNI", 4));
        }
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.mySession;
    }

    @Override
    @NotNull
    public MemoryServiceGrpc.MemoryServiceBlockingStub getClient() {
        return this.myClient.getMemoryClient();
    }

    @Override
    @NotNull
    public String getName() {
        return "Live Allocation";
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return null;
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isMemorySnapshotEnabled()) {
            return ImmutableList.of((Object)((Object)CaptureObject.ClassifierAttribute.LABEL), (Object)((Object)CaptureObject.ClassifierAttribute.ALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.DEALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.TOTAL_COUNT), (Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_SIZE));
        }
        return ImmutableList.of((Object)((Object)CaptureObject.ClassifierAttribute.LABEL), (Object)((Object)CaptureObject.ClassifierAttribute.ALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.DEALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_SIZE));
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        return ImmutableList.of((Object)((Object)CaptureObject.InstanceAttribute.LABEL), (Object)((Object)CaptureObject.InstanceAttribute.ALLOCATION_TIME), (Object)((Object)CaptureObject.InstanceAttribute.DEALLOCATION_TIME));
    }

    @Override
    @Nullable
    public String getInfoMessage() {
        return this.myInfoMessage;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        if (this.myHeapSets.get(0).getInstancesCount() > 0) {
            return this.myHeapSets;
        }
        return this.myHeapSets.subList(1, this.myHeapSets.size());
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        return this.myHeapSets.get(heapId);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        return this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity());
    }

    @Override
    public long getStartTimeNs() {
        return this.myCaptureStartTime;
    }

    @Override
    public long getEndTimeNs() {
        return Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public ClassDb getClassDatabase() {
        return this.myClassDb;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        assert (queryRange != null);
        assert (queryJoiner != null);
        this.myQueryRange = queryRange;
        this.myQueryRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, () -> this.loadTimeRange(this.myQueryRange, queryJoiner));
        this.loadTimeRange(this.myQueryRange, queryJoiner);
        return true;
    }

    @Override
    @Nullable
    public Memory.AllocationStack.StackFrame getStackFrame(long methodId) {
        return (Memory.AllocationStack.StackFrame)this.myMethodIdMap.get(methodId);
    }

    @Override
    public boolean isDoneLoading() {
        return true;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public void unload() {
        this.myQueryRange.removeDependencies(this.myAspectObserver);
        this.myExecutorService.shutdownNow();
    }

    private void updateAllocationContexts(long endTimeNs) {
        if (this.myContextEndTimeNs >= endTimeNs) {
            return;
        }
        List<Memory.BatchAllocationContexts> contextsList = this.getAllocationContexts(this.myContextEndTimeNs, endTimeNs);
        for (Memory.BatchAllocationContexts contexts : contextsList) {
            for (Memory.AllocatedClass klass : contexts.getClassesList()) {
                this.myClassDb.registerClass(klass.getClassId(), klass.getClassName());
            }
            contexts.getMethodsList().forEach(method -> {
                if (!this.myMethodIdMap.containsKey(method.getMethodId())) {
                    this.myMethodIdMap.put(method.getMethodId(), method);
                }
            });
            contexts.getEncodedStacksList().forEach(callStack -> {
                if (!this.myCallstackMap.contains(callStack.getStackId())) {
                    this.myCallstackMap.put(callStack.getStackId(), callStack);
                }
            });
            contexts.getThreadInfosList().forEach(thread2 -> {
                if (!this.myThreadIdMap.contains(thread2.getThreadId())) {
                    this.myThreadIdMap.put(thread2.getThreadId(), (Object)new ThreadId(thread2.getThreadName()));
                }
            });
            contexts.getMemoryMap().getRegionsList().forEach(region -> this.myJniMemoryRegionMap.put(region.getStartAddress(), (Memory.MemoryMap.MemoryRegion)region));
            this.myContextEndTimeNs = Math.max(this.myContextEndTimeNs, contexts.getTimestamp());
        }
    }

    private void loadTimeRange(@NotNull Range queryRange, @NotNull Executor joiner) {
        try {
            if (queryRange.isEmpty()) {
                return;
            }
            if (this.myCurrentTask != null) {
                this.myCurrentTask.cancel(false);
            }
            this.myCurrentTask = this.myExecutorService.submit(() -> {
                boolean clear2;
                long newStartTimeNs = TimeUnit.MICROSECONDS.toNanos((long)queryRange.getMin());
                long newEndTimeNs = TimeUnit.MICROSECONDS.toNanos((long)queryRange.getMax());
                if (newStartTimeNs == this.myPreviousQueryStartTimeNs && newEndTimeNs == this.myPreviousQueryEndTimeNs) {
                    return null;
                }
                boolean hasNonFullTrackingRegion = !MemoryProfiler.hasOnlyFullAllocationTrackingWithinRegion(this.myStage.getStudioProfilers(), this.mySession, TimeUnit.NANOSECONDS.toMicros(newStartTimeNs), TimeUnit.NANOSECONDS.toMicros(newEndTimeNs));
                joiner.execute(() -> this.myStage.getCaptureSelection().getAspect().changed((Enum)CaptureSelectionAspect.CURRENT_HEAP_UPDATING));
                this.updateAllocationContexts(newEndTimeNs);
                ArrayList<InstanceObject> snapshotList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetSnapshotList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> deltaAllocationList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetDeltaAllocationList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> deltaFreeList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetDeltaFreeList = new ArrayList<InstanceObject>();
                boolean bl = clear2 = this.myPreviousQueryEndTimeNs <= newStartTimeNs || newEndTimeNs <= this.myPreviousQueryStartTimeNs;
                if (clear2) {
                    this.myInstanceMap.clear();
                    this.queryJavaInstanceSnapshot(newStartTimeNs, snapshotList);
                    this.queryJniReferencesSnapshot(newStartTimeNs, snapshotList);
                    this.queryJavaInstanceDelta(newStartTimeNs, newEndTimeNs, deltaAllocationList, deltaFreeList, false);
                    this.queryJniReferencesDelta(newStartTimeNs, newEndTimeNs, deltaAllocationList, deltaFreeList, false);
                } else {
                    ArrayList<InstanceObject> leftAllocations = new ArrayList<InstanceObject>();
                    ArrayList<InstanceObject> leftDeallocations = new ArrayList<InstanceObject>();
                    if (newStartTimeNs < this.myPreviousQueryStartTimeNs) {
                        this.queryJavaInstanceDelta(newStartTimeNs, this.myPreviousQueryStartTimeNs, leftAllocations, leftDeallocations, false);
                        this.queryJniReferencesDelta(newStartTimeNs, this.myPreviousQueryStartTimeNs, leftAllocations, leftDeallocations, false);
                        deltaAllocationList.addAll(leftAllocations);
                        deltaFreeList.addAll(leftDeallocations);
                        resetSnapshotList.addAll(leftAllocations);
                        snapshotList.addAll(leftDeallocations);
                    } else if (newStartTimeNs > this.myPreviousQueryStartTimeNs) {
                        this.queryJavaInstanceDelta(this.myPreviousQueryStartTimeNs, newStartTimeNs, leftAllocations, leftDeallocations, true);
                        this.queryJniReferencesDelta(this.myPreviousQueryStartTimeNs, newStartTimeNs, leftAllocations, leftDeallocations, true);
                        resetDeltaAllocationList.addAll(leftAllocations);
                        resetDeltaFreeList.addAll(leftDeallocations);
                        snapshotList.addAll(leftAllocations);
                        resetSnapshotList.addAll(leftDeallocations);
                    }
                    ArrayList<InstanceObject> rightAllocations = new ArrayList<InstanceObject>();
                    ArrayList<InstanceObject> rightDeallocations = new ArrayList<InstanceObject>();
                    if (newEndTimeNs < this.myPreviousQueryEndTimeNs) {
                        this.queryJavaInstanceDelta(newEndTimeNs, this.myPreviousQueryEndTimeNs, rightAllocations, rightDeallocations, true);
                        this.queryJniReferencesDelta(newEndTimeNs, this.myPreviousQueryEndTimeNs, rightAllocations, rightDeallocations, true);
                        resetDeltaAllocationList.addAll(rightAllocations);
                        resetDeltaFreeList.addAll(rightDeallocations);
                    } else if (newEndTimeNs > this.myPreviousQueryEndTimeNs) {
                        this.queryJavaInstanceDelta(this.myPreviousQueryEndTimeNs, newEndTimeNs, rightAllocations, rightDeallocations, false);
                        this.queryJniReferencesDelta(this.myPreviousQueryEndTimeNs, newEndTimeNs, rightAllocations, rightDeallocations, false);
                        deltaAllocationList.addAll(rightAllocations);
                        deltaFreeList.addAll(rightDeallocations);
                    }
                }
                this.myPreviousQueryStartTimeNs = newStartTimeNs;
                this.myPreviousQueryEndTimeNs = Math.min(newEndTimeNs, this.myLastSeenTimestampNs);
                MemoryCaptureSelection selection2 = this.myStage.getCaptureSelection();
                joiner.execute(() -> {
                    selection2.getAspect().changed((Enum)CaptureSelectionAspect.CURRENT_HEAP_UPDATED);
                    if (clear2 || deltaAllocationList.size() + deltaFreeList.size() + resetDeltaAllocationList.size() + resetDeltaFreeList.size() > 0) {
                        if (clear2) {
                            this.myHeapSets.forEach(heap -> heap.clearClassifierSets());
                            if (selection2.getSelectedClassSet() != null) {
                                selection2.selectClassSet(ClassSet.EMPTY_SET);
                            }
                        }
                        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isMemorySnapshotEnabled()) {
                            snapshotList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addSnapshotInstanceObject((InstanceObject)instance));
                            resetSnapshotList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeSnapshotInstanceObject((InstanceObject)instance));
                        }
                        deltaAllocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addDeltaInstanceObject((InstanceObject)instance));
                        deltaFreeList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).freeDeltaInstanceObject((InstanceObject)instance));
                        resetDeltaAllocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeAddedDeltaInstanceObject((InstanceObject)instance));
                        resetDeltaFreeList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeFreedDeltaInstanceObject((InstanceObject)instance));
                        this.myInfoMessage = hasNonFullTrackingRegion ? SAMPLING_INFO_MESSAGE : null;
                        selection2.refreshSelectedHeap();
                    }
                });
                return null;
            });
        }
        catch (RejectedExecutionException e) {
            LiveAllocationCaptureObject.getLogger().debug((Throwable)e);
        }
    }

    @NotNull
    private LiveAllocationInstanceObject getOrCreateInstanceObject(int tag, int classTag, int stackId, int threadId, long size, int heapId) {
        LiveAllocationInstanceObject instance = (LiveAllocationInstanceObject)this.myInstanceMap.get(tag);
        if (instance == null) {
            ClassDb.ClassEntry entry = this.myClassDb.getEntry(classTag);
            Memory.AllocationStack callstack = null;
            if (stackId != 0) {
                assert (this.myCallstackMap.containsKey(stackId));
                callstack = (Memory.AllocationStack)this.myCallstackMap.get(stackId);
            }
            ThreadId thread2 = null;
            if (threadId != 0) {
                assert (this.myThreadIdMap.containsKey(threadId));
                thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
            }
            instance = new LiveAllocationInstanceObject(this, entry, thread2, callstack, size, heapId);
            this.myInstanceMap.put(tag, (Object)instance);
        }
        return instance;
    }

    @Nullable
    private JniReferenceInstanceObject getOrCreateJniRefObject(int tag, long refValue) {
        LiveAllocationInstanceObject referencedObject = (LiveAllocationInstanceObject)this.myInstanceMap.get(tag);
        if (referencedObject == null) {
            return null;
        }
        JniReferenceInstanceObject result = referencedObject.getJniRefByValue(refValue);
        if (result == null) {
            result = new JniReferenceInstanceObject(this, referencedObject, tag, refValue);
            referencedObject.addJniRef(result);
        }
        return result;
    }

    private void queryJavaInstanceSnapshot(long snapshotTimeNs, @NotNull List<InstanceObject> snapshotList) {
        long sessionStartNs = this.mySession.getStartTimestamp();
        List<Memory.BatchAllocationEvents> eventsList = this.getAllocationEvents(sessionStartNs, snapshotTimeNs);
        LinkedHashMap<Integer, LiveAllocationInstanceObject> liveInstanceMap = new LinkedHashMap<Integer, LiveAllocationInstanceObject>();
        for (Memory.BatchAllocationEvents events : eventsList) {
            Iterator itr = events.getEventsList().stream().filter(evt -> evt.getTimestamp() < snapshotTimeNs).sorted(Comparator.comparingLong(Memory.AllocationEvent::getTimestamp)).iterator();
            while (itr.hasNext()) {
                Memory.AllocationEvent event = (Memory.AllocationEvent)itr.next();
                switch (event.getEventCase()) {
                    case ALLOC_DATA: {
                        Memory.AllocationEvent.Allocation allocation = event.getAllocData();
                        LiveAllocationInstanceObject instance = this.getOrCreateInstanceObject(allocation.getTag(), allocation.getClassTag(), allocation.getStackId(), allocation.getThreadId(), allocation.getSize(), allocation.getHeapId());
                        instance.setAllocationTime(event.getTimestamp());
                        liveInstanceMap.put(allocation.getTag(), instance);
                        break;
                    }
                    case FREE_DATA: {
                        Memory.AllocationEvent.Deallocation deallocation = event.getFreeData();
                        liveInstanceMap.remove(deallocation.getTag());
                        this.myInstanceMap.remove(deallocation.getTag());
                        break;
                    }
                }
            }
        }
        snapshotList.addAll(liveInstanceMap.values());
    }

    private void queryJniReferencesSnapshot(long snapshotTimeNs, @NotNull List<InstanceObject> snapshotList) {
        if (!this.myEnableJniRefsTracking) {
            return;
        }
        long sessionStartNs = this.mySession.getStartTimestamp();
        List<Memory.BatchJNIGlobalRefEvent> eventsList = this.getJniRefEvents(sessionStartNs, snapshotTimeNs);
        LinkedHashMap<Long, JniReferenceInstanceObject> instanceMap = new LinkedHashMap<Long, JniReferenceInstanceObject>();
        for (Memory.BatchJNIGlobalRefEvent events : eventsList) {
            Iterator itr = events.getEventsList().stream().filter(evt -> evt.getTimestamp() < snapshotTimeNs).sorted(Comparator.comparingLong(Memory.JNIGlobalReferenceEvent::getTimestamp)).iterator();
            while (itr.hasNext()) {
                Memory.JNIGlobalReferenceEvent event = (Memory.JNIGlobalReferenceEvent)itr.next();
                switch (event.getEventType()) {
                    case CREATE_GLOBAL_REF: {
                        JniReferenceInstanceObject refObject = this.getOrCreateJniRefObject(event.getObjectTag(), event.getRefValue());
                        if (refObject == null) break;
                        if (event.hasBacktrace()) {
                            refObject.setAllocationBacktrace(event.getBacktrace());
                        }
                        int threadId = event.getThreadId();
                        ThreadId thread2 = ThreadId.INVALID_THREAD_ID;
                        if (threadId != 0) {
                            assert (this.myThreadIdMap.containsKey(threadId));
                            thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
                        }
                        refObject.setAllocThreadId(thread2);
                        refObject.setAllocationTime(event.getTimestamp());
                        instanceMap.put(refObject.getRefValue(), refObject);
                        break;
                    }
                    case DELETE_GLOBAL_REF: {
                        JniReferenceInstanceObject refObject = (JniReferenceInstanceObject)instanceMap.remove(event.getRefValue());
                        if (refObject == null || !this.myInstanceMap.containsKey(event.getObjectTag())) break;
                        ((LiveAllocationInstanceObject)this.myInstanceMap.get(event.getObjectTag())).removeJniRef(refObject);
                    }
                }
            }
        }
        snapshotList.addAll(instanceMap.values());
    }

    private void queryJavaInstanceDelta(long startTimeNs, long endTimeNs, @NotNull List<InstanceObject> allocationList, @NotNull List<InstanceObject> deallocationList, boolean resetInstance) {
        if (startTimeNs == endTimeNs) {
            return;
        }
        List<Memory.BatchAllocationEvents> eventsList = this.getAllocationEvents(startTimeNs, endTimeNs);
        for (Memory.BatchAllocationEvents events : eventsList) {
            Iterator itr = events.getEventsList().stream().filter(evt -> evt.getTimestamp() >= startTimeNs && evt.getTimestamp() < endTimeNs).sorted(Comparator.comparingLong(Memory.AllocationEvent::getTimestamp)).iterator();
            while (itr.hasNext()) {
                Memory.AllocationEvent event = (Memory.AllocationEvent)itr.next();
                switch (event.getEventCase()) {
                    case ALLOC_DATA: {
                        Memory.AllocationEvent.Allocation allocation = event.getAllocData();
                        LiveAllocationInstanceObject instance = this.getOrCreateInstanceObject(allocation.getTag(), allocation.getClassTag(), allocation.getStackId(), allocation.getThreadId(), allocation.getSize(), allocation.getHeapId());
                        instance.setAllocationTime(resetInstance ? Long.MIN_VALUE : event.getTimestamp());
                        allocationList.add(instance);
                        break;
                    }
                    case FREE_DATA: {
                        Memory.AllocationEvent.Deallocation deallocation = event.getFreeData();
                        assert (this.myInstanceMap.containsKey(deallocation.getTag()));
                        LiveAllocationInstanceObject instance = (LiveAllocationInstanceObject)this.myInstanceMap.get(deallocation.getTag());
                        instance.setDeallocTime(resetInstance ? Long.MAX_VALUE : event.getTimestamp());
                        deallocationList.add(instance);
                        break;
                    }
                }
            }
        }
    }

    private void queryJniReferencesDelta(long startTimeNs, long endTimeNs, @NotNull List<InstanceObject> allocationList, @NotNull List<InstanceObject> deallocatoinList, boolean resetInstance) {
        if (!this.myEnableJniRefsTracking || startTimeNs == endTimeNs) {
            return;
        }
        List<Memory.BatchJNIGlobalRefEvent> eventsList = this.getJniRefEvents(startTimeNs, endTimeNs);
        for (Memory.BatchJNIGlobalRefEvent events : eventsList) {
            Iterator itr = events.getEventsList().stream().filter(evt -> evt.getTimestamp() >= startTimeNs && evt.getTimestamp() < endTimeNs).sorted(Comparator.comparingLong(Memory.JNIGlobalReferenceEvent::getTimestamp)).iterator();
            block5: while (itr.hasNext()) {
                Memory.JNIGlobalReferenceEvent event = (Memory.JNIGlobalReferenceEvent)itr.next();
                JniReferenceInstanceObject refObject = this.getOrCreateJniRefObject(event.getObjectTag(), event.getRefValue());
                if (refObject == null) continue;
                int threadId = event.getThreadId();
                ThreadId thread2 = ThreadId.INVALID_THREAD_ID;
                if (threadId != 0) {
                    assert (this.myThreadIdMap.containsKey(threadId));
                    thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
                }
                switch (event.getEventType()) {
                    case CREATE_GLOBAL_REF: {
                        if (resetInstance) {
                            refObject.setAllocationTime(Long.MIN_VALUE);
                        } else {
                            refObject.setAllocationTime(event.getTimestamp());
                            if (event.hasBacktrace()) {
                                refObject.setAllocationBacktrace(event.getBacktrace());
                            }
                            refObject.setAllocThreadId(thread2);
                        }
                        allocationList.add(refObject);
                        continue block5;
                    }
                    case DELETE_GLOBAL_REF: {
                        if (resetInstance) {
                            refObject.setAllocationTime(Long.MAX_VALUE);
                        } else {
                            refObject.setDeallocTime(event.getTimestamp());
                            if (event.hasBacktrace()) {
                                refObject.setDeallocationBacktrace(event.getBacktrace());
                            }
                            refObject.setDeallocThreadId(thread2);
                        }
                        deallocatoinList.add(refObject);
                        continue block5;
                    }
                }
                assert (false);
            }
        }
    }

    @NotNull
    Memory.NativeCallStack resolveNativeBacktrace(@Nullable Memory.NativeBacktrace backtrace) {
        if (backtrace == null || backtrace.getAddressesCount() == 0) {
            return Memory.NativeCallStack.getDefaultInstance();
        }
        Memory.NativeCallStack.Builder builder = Memory.NativeCallStack.newBuilder();
        Iterator iterator = backtrace.getAddressesList().iterator();
        while (iterator.hasNext()) {
            long address = (Long)iterator.next();
            if (!this.myNativeFrameMap.containsKey(address)) {
                String module = "";
                long offset = 0L;
                Memory.MemoryMap.MemoryRegion region = this.getRegionByAddress(address);
                if (region != null) {
                    module = region.getName();
                    offset = region.getFileOffset() + (address - region.getStartAddress());
                }
                Memory.NativeCallStack.NativeFrame unsymbolizedFrame = Memory.NativeCallStack.NativeFrame.newBuilder().setAddress(address).setModuleName(module).setModuleOffset(offset).build();
                Memory.NativeCallStack.NativeFrame symbolizedFrame = this.myStage.getStudioProfilers().getIdeServices().getNativeFrameSymbolizer().symbolize(this.myStage.getStudioProfilers().getSessionsManager().getSelectedSessionMetaData().getProcessAbi(), unsymbolizedFrame);
                this.myNativeFrameMap.put(address, (Object)symbolizedFrame);
            }
            builder.addFrames((Memory.NativeCallStack.NativeFrame)this.myNativeFrameMap.get(address));
        }
        return builder.build();
    }

    @Nullable
    private Memory.MemoryMap.MemoryRegion getRegionByAddress(long address) {
        Map.Entry<Long, Memory.MemoryMap.MemoryRegion> entry = this.myJniMemoryRegionMap.floorEntry(address);
        if (entry == null) {
            return null;
        }
        Memory.MemoryMap.MemoryRegion region = entry.getValue();
        if (address >= region.getStartAddress() && address < region.getEndAddress()) {
            return region;
        }
        return null;
    }

    @NotNull
    private List<Memory.BatchAllocationContexts> getAllocationContexts(long startTimeNs, long endTimeNs) {
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(this.buildEventGroupRequest(Common.Event.Kind.MEMORY_ALLOC_CONTEXTS, startTimeNs, endTimeNs + QUERY_BUFFER_NS));
            assert (response.getGroupsCount() <= 1);
            return response.getGroupsCount() == 1 ? response.getGroups(0).getEventsList().stream().map(event -> event.getMemoryAllocContexts().getContexts()).collect(Collectors.toList()) : Collections.emptyList();
        }
        MemoryProfiler.AllocationContextsResponse response = this.getClient().getAllocationContexts(MemoryProfiler.AllocationContextsRequest.newBuilder().setSession(this.mySession).setStartTime(startTimeNs).setEndTime(endTimeNs + QUERY_BUFFER_NS).build());
        return response.getContextsList();
    }

    @NotNull
    private List<Memory.BatchAllocationEvents> getAllocationEvents(long startTimeNs, long endTimeNs) {
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(this.buildEventGroupRequest(Common.Event.Kind.MEMORY_ALLOC_EVENTS, startTimeNs - QUERY_BUFFER_NS, endTimeNs + QUERY_BUFFER_NS));
            assert (response.getGroupsCount() <= 1);
            return response.getGroupsCount() == 1 ? this.getEventsAndUpdateSeenTimestamp(response.getGroups(0).getEventsList().stream().map(event -> event.getMemoryAllocEvents().getEvents()).collect(Collectors.toList()), Memory.BatchAllocationEvents::getTimestamp) : Collections.emptyList();
        }
        MemoryProfiler.AllocationEventsResponse response = this.getClient().getAllocationEvents(MemoryProfiler.AllocationSnapshotRequest.newBuilder().setSession(this.mySession).setStartTime(startTimeNs - QUERY_BUFFER_NS).setEndTime(endTimeNs + QUERY_BUFFER_NS).build());
        List eventsList = response.getEventsList();
        return this.getEventsAndUpdateSeenTimestamp(eventsList, Memory.BatchAllocationEvents::getTimestamp);
    }

    @NotNull
    private List<Memory.BatchJNIGlobalRefEvent> getJniRefEvents(long startTimeNs, long endTimeNs) {
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(this.buildEventGroupRequest(Common.Event.Kind.MEMORY_JNI_REF_EVENTS, startTimeNs - QUERY_BUFFER_NS, endTimeNs + QUERY_BUFFER_NS));
            assert (response.getGroupsCount() <= 1);
            return response.getGroupsCount() == 1 ? this.getEventsAndUpdateSeenTimestamp(response.getGroups(0).getEventsList().stream().map(event -> event.getMemoryJniRefEvents().getEvents()).collect(Collectors.toList()), Memory.BatchJNIGlobalRefEvent::getTimestamp) : Collections.emptyList();
        }
        MemoryProfiler.JNIGlobalRefsEventsRequest request = MemoryProfiler.JNIGlobalRefsEventsRequest.newBuilder().setSession(this.mySession).setStartTime(startTimeNs - QUERY_BUFFER_NS).setEndTime(endTimeNs + QUERY_BUFFER_NS).build();
        List eventsList = this.getClient().getJNIGlobalRefsEvents(request).getEventsList();
        return this.getEventsAndUpdateSeenTimestamp(eventsList, Memory.BatchJNIGlobalRefEvent::getTimestamp);
    }

    @NotNull
    private Transport.GetEventGroupsRequest buildEventGroupRequest(Common.Event.Kind kind, long startTimeNs, long endTimeNs) {
        return Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setKind(kind).setFromTimestamp(startTimeNs).setToTimestamp(endTimeNs).build();
    }

    private <T> List<T> getEventsAndUpdateSeenTimestamp(List<T> eventList, Function<T, Long> timestampFunc) {
        for (T event : eventList) {
            this.myLastSeenTimestampNs = Math.max(timestampFunc.apply(event), this.myLastSeenTimestampNs);
        }
        return eventList;
    }
}

