/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class LegacyAllocationsInstanceObject
implements InstanceObject {
    @NotNull
    static final Map<String, ValueObject.ValueType> ourTypeMap = ImmutableMap.builder().put((Object)"boolean", (Object)ValueObject.ValueType.BOOLEAN).put((Object)"byte", (Object)ValueObject.ValueType.BYTE).put((Object)"char", (Object)ValueObject.ValueType.CHAR).put((Object)"short", (Object)ValueObject.ValueType.SHORT).put((Object)"int", (Object)ValueObject.ValueType.INT).put((Object)"long", (Object)ValueObject.ValueType.LONG).put((Object)"float", (Object)ValueObject.ValueType.FLOAT).put((Object)"double", (Object)ValueObject.ValueType.DOUBLE).build();
    @NotNull
    private final Memory.AllocationEvent.Allocation myEvent;
    @NotNull
    private final ClassDb.ClassEntry myAllocationClassEntry;
    @NotNull
    private final Memory.AllocationStack myCallStack;
    @NotNull
    private final ValueObject.ValueType myValueType;
    @NotNull
    private final ThreadId myThreadId;

    public LegacyAllocationsInstanceObject(@NotNull Memory.AllocationEvent.Allocation event, @NotNull ClassDb.ClassEntry allocationClassEntry, @NotNull Memory.AllocationStack callStack) {
        this.myEvent = event;
        this.myAllocationClassEntry = allocationClassEntry;
        this.myCallStack = callStack;
        this.myThreadId = new ThreadId(event.getThreadId());
        String className = this.myAllocationClassEntry.getClassName();
        this.myValueType = className.contains(".") ? (className.equals("java.lang.String") ? ValueObject.ValueType.STRING : ValueObject.ValueType.OBJECT) : (this.myAllocationClassEntry.getClassName().endsWith("[]") ? ValueObject.ValueType.ARRAY : ourTypeMap.getOrDefault(className, ValueObject.ValueType.OBJECT));
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    public int getHeapId() {
        return 0;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        return this.myAllocationClassEntry;
    }

    @Override
    public int getShallowSize() {
        return (int)this.myEvent.getSize();
    }

    @Override
    @NotNull
    public ThreadId getAllocationThreadId() {
        return this.myThreadId;
    }

    @Override
    @NotNull
    public Memory.AllocationStack getAllocationCallStack() {
        return this.myCallStack;
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        return this.myValueType;
    }

    @Override
    @NotNull
    public String getValueText() {
        return this.myAllocationClassEntry.getSimpleClassName();
    }
}

