/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import icons.StudioIcons;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/profilers/memory/ValueColumnRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "setIconColorized", "icon", "Ljavax/swing/Icon;", "Companion", "intellij.android.profilers.ui"})
public class ValueColumnRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private static final SimpleTextAttributes STRING_ATTRIBUTES;
    public static final Companion Companion;

    public void customizeCellRenderer(@NotNull JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof MemoryObjectTreeNode)) {
            this.append(value.toString());
        } else if (!(((MemoryObjectTreeNode)value).getAdapter() instanceof ValueObject)) {
            this.append(((MemoryObjectTreeNode)value).getAdapter().getName());
        } else {
            Object t = ((MemoryObjectTreeNode)value).getAdapter();
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.profilers.memory.adapters.ValueObject");
            }
            ValueObject valueObject = (ValueObject)t;
            this.setIconColorized(Companion.getValueObjectIcon(valueObject));
            this.setTextAlign(2);
            String name = valueObject.getName();
            this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
            CharSequence charSequence = name;
            boolean bl = false;
            this.append(charSequence.length() == 0 ? "" : " = ");
            String valueText = valueObject.getValueText();
            this.append(valueText, SimpleTextAttributes.REGULAR_ATTRIBUTES, valueText);
            CharSequence charSequence2 = valueText;
            boolean bl2 = false;
            this.append(charSequence2.length() == 0 ? "" : " ");
            String toStringText = valueObject.getToStringText();
            this.append(toStringText, valueObject.getValueType() == ValueObject.ValueType.STRING ? STRING_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES, toStringText);
        }
    }

    private final void setIconColorized(Icon icon) {
        this.setIcon(this.mySelected && this.isFocused() ? ColoredIconGenerator.generateWhiteIcon((Icon)icon) : icon);
    }

    static {
        Companion = new Companion(null);
        STRING_ATTRIBUTES = new SimpleTextAttributes(1, new Color(0, 128, 0));
    }

    @JvmStatic
    public static final Icon getValueObjectIcon(@NotNull ValueObject $this$getValueObjectIcon) {
        return Companion.getValueObjectIcon($this$getValueObjectIcon);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b*\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0014\u0010\f\u001a\n \r*\u0004\u0018\u00010\b0\b*\u00020\u000eH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/profilers/memory/ValueColumnRenderer$Companion;", "", "()V", "STRING_ATTRIBUTES", "Lcom/intellij/ui/SimpleTextAttributes;", "getSTRING_ATTRIBUTES", "()Lcom/intellij/ui/SimpleTextAttributes;", "getStackedIcon", "Ljavax/swing/Icon;", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "stackedIcon", "nonStackedIcon", "getValueObjectIcon", "kotlin.jvm.PlatformType", "Lcom/android/tools/profilers/memory/adapters/ValueObject;", "intellij.android.profilers.ui"})
    public static final class Companion {
        @NotNull
        public final SimpleTextAttributes getSTRING_ATTRIBUTES() {
            return STRING_ATTRIBUTES;
        }

        @JvmStatic
        public final Icon getValueObjectIcon(@NotNull ValueObject $this$getValueObjectIcon) {
            ValueObject valueObject = $this$getValueObjectIcon;
            return valueObject instanceof FieldObject ? (((FieldObject)$this$getValueObjectIcon).getValueType() == ValueObject.ValueType.ARRAY ? this.getStackedIcon(((FieldObject)$this$getValueObjectIcon).getAsInstance(), StudioIcons.Profiler.Overlays.ARRAY_STACK, AllIcons.Debugger.Db_array) : (((FieldObject)$this$getValueObjectIcon).getValueType().getIsPrimitive() ? AllIcons.Debugger.Db_primitive : this.getStackedIcon(((FieldObject)$this$getValueObjectIcon).getAsInstance(), StudioIcons.Profiler.Overlays.FIELD_STACK, PlatformIcons.FIELD_ICON))) : (valueObject instanceof ReferenceObject ? (((ReferenceObject)$this$getValueObjectIcon).getReferenceInstance().getIsRoot() ? AllIcons.Hierarchy.Subtypes : (((ReferenceObject)$this$getValueObjectIcon).getReferenceInstance().getValueType() == ValueObject.ValueType.ARRAY ? this.getStackedIcon(((ReferenceObject)$this$getValueObjectIcon).getReferenceInstance(), StudioIcons.Profiler.Overlays.ARRAY_STACK, AllIcons.Debugger.Db_array) : this.getStackedIcon(((ReferenceObject)$this$getValueObjectIcon).getReferenceInstance(), StudioIcons.Profiler.Overlays.FIELD_STACK, PlatformIcons.FIELD_ICON))) : (valueObject instanceof InstanceObject ? this.getStackedIcon((InstanceObject)$this$getValueObjectIcon, StudioIcons.Profiler.Overlays.INTERFACE_STACK, PlatformIcons.INTERFACE_ICON) : PlatformIcons.INTERFACE_ICON));
        }

        private final Icon getStackedIcon(InstanceObject $this$getStackedIcon, Icon stackedIcon, Icon nonStackedIcon) {
            return $this$getStackedIcon == null || $this$getStackedIcon.getCallStackDepth() == 0 ? nonStackedIcon : stackedIcon;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

