/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionListener;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.memory.AllocationInfosDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.BaseMemoryProfilerStage;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureObjectLoader;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.HeapDumpSampleDataSeries;
import com.android.tools.profilers.memory.HeapDumpStage;
import com.android.tools.profilers.memory.LegacyGcStatsDataSeries;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryStageLegends;
import com.android.tools.profilers.memory.NativeAllocationSamplesSeries;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfilerStage
extends BaseMemoryProfilerStage
implements CodeNavigator.Listener {
    private static final String HAS_USED_MEMORY_CAPTURE = "memory.used.capture";
    public static final String LIVE_ALLOCATION_SAMPLING_PREF = "memory.live.allocation.mode";
    public static final LiveAllocationSamplingMode DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE = LiveAllocationSamplingMode.SAMPLED;
    static final BaseAxisFormatter MEMORY_AXIS_FORMATTER = new MemoryAxisFormatter(1, 5, 5);
    static final BaseAxisFormatter OBJECT_COUNT_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 5, 5, "");
    public static final int MEMORY_HPROF_SAFE_FACTOR = Math.max(1, Math.min(Integer.getInteger("profiler.memory.hprof.safeFactor", 10), 1000));
    private final DetailedMemoryUsage myDetailedMemoryUsage;
    private final ClampedAxisComponentModel myMemoryAxis;
    private final ClampedAxisComponentModel myObjectsAxis;
    private final MemoryStageLegends myLegends;
    private final MemoryStageLegends myTooltipLegends;
    private final EaseOutModel myInstructionsEaseOutModel;
    private final boolean myIsMemoryCaptureOnly;
    @NotNull
    private final Common.Session mySessionData;
    private DurationDataModel<GcDurationData> myGcStatsModel;
    @NotNull
    private AspectModel<MemoryProfilerAspect> myAspect = new AspectModel();
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    private final DurationDataModel<CaptureDurationData<CaptureObject>> myHeapDumpDurations;
    private final DurationDataModel<CaptureDurationData<CaptureObject>> myAllocationDurations;
    private final DurationDataModel<CaptureDurationData<CaptureObject>> myNativeAllocationDurations;
    private final EventMonitor myEventMonitor;
    private final RangeSelectionModel myRangeSelectionModel;
    private boolean myTrackingAllocations;
    private final CaptureElapsedTimeUpdatable myCaptureElapsedTimeUpdatable = new CaptureElapsedTimeUpdatable();
    private long myPendingLegacyAllocationStartTimeNs = -1L;
    private boolean myNativeAllocationTracking = false;
    @NotNull
    private final AllocationSamplingRateDataSeries myAllocationSamplingRateDataSeries;
    @NotNull
    private final DurationDataModel<AllocationSamplingRateDurationData> myAllocationSamplingRateDurations;
    @NotNull
    private final AllocationSamplingRateUpdatable myAllocationSamplingRateUpdatable;
    @NotNull
    private LiveAllocationSamplingMode myLiveAllocationSamplingMode;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryProfilerStage.class);
    }

    public MemoryProfilerStage(@NotNull StudioProfilers profilers) {
        this(profilers, new CaptureObjectLoader());
    }

    public MemoryProfilerStage(final @NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
        super(profilers, loader);
        this.myIsMemoryCaptureOnly = profilers.getSessionsManager().getSelectedSessionMetaData().getType() == Common.SessionMetaData.SessionType.MEMORY_CAPTURE;
        this.mySessionData = profilers.getSession();
        this.myClient = profilers.getClient().getMemoryClient();
        FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        HeapDumpSampleDataSeries heapDumpSeries = new HeapDumpSampleDataSeries(profilers.getClient(), this.mySessionData, featureTracker, this.getStudioProfilers().getIdeServices());
        AllocationInfosDataSeries allocationSeries = new AllocationInfosDataSeries(profilers.getClient(), this.mySessionData, featureTracker, this);
        NativeAllocationSamplesSeries nativeSampleSeries = new NativeAllocationSamplesSeries(profilers.getClient(), this.mySessionData, featureTracker, this);
        Range viewRange = this.getTimeline().getViewRange();
        this.myHeapDumpDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)heapDumpSeries));
        this.myAllocationDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)allocationSeries));
        this.myNativeAllocationDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)nativeSampleSeries));
        Object gcSeries = this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled() ? new UnifiedEventDataSeries(this.getStudioProfilers().getClient().getTransportClient(), this.mySessionData.getStreamId(), this.mySessionData.getPid(), Common.Event.Kind.MEMORY_GC, 0, events -> ContainerUtil.map((Collection)events, evt -> new SeriesData(TimeUnit.NANOSECONDS.toMicros(evt.getTimestamp()), (Object)new GcDurationData(TimeUnit.NANOSECONDS.toMicros(evt.getMemoryGc().getDuration()))))) : new LegacyGcStatsDataSeries(this.myClient, this.mySessionData);
        this.myGcStatsModel = new DurationDataModel(new RangedSeries(viewRange, gcSeries));
        this.myAllocationSamplingRateDataSeries = new AllocationSamplingRateDataSeries(this.getStudioProfilers().getClient(), this.mySessionData, this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled());
        this.myAllocationSamplingRateDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.myAllocationSamplingRateDataSeries));
        this.myDetailedMemoryUsage = new DetailedMemoryUsage(profilers, this);
        this.myHeapDumpDurations.setRenderSeriesPredicate((data, series) -> !series.getName().equals(this.myDetailedMemoryUsage.getObjectsSeries().getName()));
        this.myGcStatsModel.setAttachedSeries(this.myDetailedMemoryUsage.getObjectsSeries(), Interpolatable.SegmentInterpolator);
        this.myGcStatsModel.setAttachPredicate(data -> !this.isLiveAllocationTrackingReady() || MemoryProfiler.hasOnlyFullAllocationTrackingWithinRegion(this.getStudioProfilers(), this.mySessionData, data.x, data.x));
        this.myAllocationSamplingRateDurations.setAttachedSeries(this.myDetailedMemoryUsage.getObjectsSeries(), Interpolatable.SegmentInterpolator);
        this.myAllocationSamplingRateDurations.setAttachPredicate(data -> ((AllocationSamplingRateDurationData)data.value).getPreviousRate() != null && ((AllocationSamplingRateDurationData)data.value).getPreviousRate().getSamplingNumInterval() == LiveAllocationSamplingMode.FULL.getValue() || ((AllocationSamplingRateDurationData)data.value).getCurrentRate().getSamplingNumInterval() == LiveAllocationSamplingMode.FULL.getValue());
        this.myAllocationSamplingRateDurations.setRenderSeriesPredicate((data, series) -> !series.getName().equals(this.myDetailedMemoryUsage.getObjectsSeries().getName()) || !this.isLiveAllocationTrackingReady() || ((AllocationSamplingRateDurationData)data.value).getCurrentRate().getSamplingNumInterval() == LiveAllocationSamplingMode.FULL.getValue());
        this.myAllocationSamplingRateUpdatable = new AllocationSamplingRateUpdatable();
        this.myMemoryAxis = new ClampedAxisComponentModel.Builder(this.myDetailedMemoryUsage.getMemoryRange(), MEMORY_AXIS_FORMATTER).build();
        this.myObjectsAxis = new ClampedAxisComponentModel.Builder(this.myDetailedMemoryUsage.getObjectsRange(), OBJECT_COUNT_AXIS_FORMATTER).build();
        this.myLegends = new MemoryStageLegends(this, this.getTimeline().getDataRange(), false);
        this.myTooltipLegends = new MemoryStageLegends(this, this.getTimeline().getTooltipRange(), true);
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myEventMonitor = new EventMonitor(profilers);
        if (this.getStudioProfilers().getSessionsManager().isSessionAlive() && this.isLiveAllocationTrackingSupported()) {
            long currentRangeMax = TimeUnit.MICROSECONDS.toNanos((long)profilers.getTimeline().getDataRange().getMax());
            if (!this.isLiveAllocationTrackingReady()) {
                TransportEventListener listener = new TransportEventListener(Common.Event.Kind.MEMORY_ALLOC_SAMPLING, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> true, () -> this.mySessionData.getStreamId(), () -> this.mySessionData.getPid(), null, () -> currentRangeMax, event -> {
                    this.myAspect.changed((Enum)MemoryProfilerAspect.LIVE_ALLOCATION_STATUS);
                    return true;
                });
                this.getStudioProfilers().getTransportPoller().registerListener(listener);
            }
        }
        this.myRangeSelectionModel = new RangeSelectionModel(this.getTimeline().getSelectionRange(), this.getTimeline().getViewRange());
        this.myRangeSelectionModel.addConstraint(this.myAllocationDurations);
        this.myRangeSelectionModel.addConstraint(this.myNativeAllocationDurations);
        this.myRangeSelectionModel.addConstraint(this.myHeapDumpDurations);
        this.myRangeSelectionModel.addListener(new RangeSelectionListener(){

            public void selectionCreated() {
                MemoryProfilerStage.this.selectCaptureFromSelectionRange();
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
                profilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(MemoryProfilerStage.HAS_USED_MEMORY_CAPTURE, true);
                MemoryProfilerStage.this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
            }

            public void selectionCleared() {
                MemoryProfilerStage.this.selectCaptureFromSelectionRange();
            }
        });
        this.myLiveAllocationSamplingMode = LiveAllocationSamplingMode.getModeFromFrequency(profilers.getIdeServices().getPersistentProfilerPreferences().getInt(LIVE_ALLOCATION_SAMPLING_PREF, DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE.getValue()));
        this.myAllocationSamplingRateUpdatable.update(0L);
        this.getStudioProfilers().getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::stopRecordingOnSessionStop);
    }

    void stopRecordingOnSessionStop() {
        boolean isAlive = this.getStudioProfilers().getSessionsManager().isSessionAlive();
        if (!isAlive && this.myNativeAllocationTracking) {
            this.toggleNativeAllocationTracking();
        }
    }

    public boolean hasUserUsedMemoryCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_MEMORY_CAPTURE, false);
    }

    public DetailedMemoryUsage getDetailedMemoryUsage() {
        return this.myDetailedMemoryUsage;
    }

    @Override
    public void enter() {
        this.getLoader().start();
        this.myEventMonitor.enter();
        this.forEachUpdatable(arg_0 -> ((Updater)this.getStudioProfilers().getUpdater()).register(arg_0));
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
        this.updateAllocationTrackingStatus();
        this.updateNativeAllocationTrackingStatus();
    }

    @Override
    public void exit() {
        this.enableSelectLatestCapture(false, null);
        this.myEventMonitor.exit();
        this.forEachUpdatable(arg_0 -> ((Updater)this.getStudioProfilers().getUpdater()).unregister(arg_0));
        this.selectCaptureDuration(null, null);
        this.getLoader().stop();
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.myRangeSelectionModel.clearListeners();
    }

    private void forEachUpdatable(Consumer<Updatable> f) {
        for (Updatable u : new Updatable[]{this.myDetailedMemoryUsage, this.myHeapDumpDurations, this.myAllocationDurations, this.myNativeAllocationDurations, this.myMemoryAxis, this.myObjectsAxis, this.myGcStatsModel, this.myAllocationSamplingRateDurations, this.myCaptureElapsedTimeUpdatable, this.myAllocationSamplingRateUpdatable}) {
            f.accept(u);
        }
    }

    public RangeSelectionModel getRangeSelectionModel() {
        return this.myRangeSelectionModel;
    }

    private void selectCaptureFromSelectionRange() {
        if (!this.getUpdateCaptureOnSelection()) {
            return;
        }
        this.setUpdateCaptureOnSelection(false);
        Range selectionRange = this.getTimeline().getSelectionRange();
        this.selectCaptureDuration(this.getIntersectingCaptureDuration(selectionRange), SwingUtilities::invokeLater);
        this.setUpdateCaptureOnSelection(true);
    }

    public void enableSelectLatestCapture(boolean enable, @Nullable Executor loadJoiner) {
        if (enable) {
            this.getTimeline().getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> this.queryAndSelectCaptureObject(loadJoiner == null ? MoreExecutors.directExecutor() : loadJoiner));
        } else {
            this.getTimeline().getDataRange().removeDependencies((AspectObserver)this);
        }
    }

    public boolean isMemoryCaptureOnly() {
        return this.myIsMemoryCaptureOnly;
    }

    private void queryAndSelectCaptureObject(@NotNull Executor loadJoiner) {
        Range dataRange = this.getTimeline().getDataRange();
        if (this.getPendingCaptureStartTime() != -1L) {
            ArrayList series = new ArrayList(this.getAllocationInfosDurations().getSeries().getSeriesForRange(dataRange));
            series.addAll(this.getHeapDumpSampleDurations().getSeries().getSeriesForRange(dataRange));
            series.addAll(this.getNativeAllocationInfosDurations().getSeries().getSeriesForRange(dataRange));
            long pendingCaptureStartTimeUs = TimeUnit.NANOSECONDS.toMicros(this.getPendingCaptureStartTime());
            SeriesData captureToSelect = null;
            for (int i2 = series.size() - 1; i2 >= 0; --i2) {
                if (((SeriesData)series.get((int)i2)).x != pendingCaptureStartTimeUs) continue;
                captureToSelect = (SeriesData)series.get(i2);
                break;
            }
            if (captureToSelect != null && (((CaptureDurationData)((Object)captureToSelect.value)).getDurationUs() != Long.MAX_VALUE || ((CaptureDurationData)((Object)captureToSelect.value)).getSelectableWhenMaxDuration())) {
                long x = captureToSelect.x;
                if (this.getHeapDumpSampleDurations().getSeries().getSeriesForRange(dataRange).stream().anyMatch(s -> s.x == x)) {
                    this.myAspect.changed((Enum)MemoryProfilerAspect.HEAP_DUMP_FINISHED);
                }
                this.selectCaptureDuration((CaptureDurationData)((Object)captureToSelect.value), loadJoiner);
            }
        }
    }

    public void setPendingCaptureStartTimeGuarded(long pendingCaptureStartTime) {
        assert (this.myIsMemoryCaptureOnly);
        super.setPendingCaptureStartTime(pendingCaptureStartTime);
    }

    @NotNull
    public AspectModel<MemoryProfilerAspect> getAspect() {
        return this.myAspect;
    }

    private Transport.ExecuteResponse startNativeAllocationTracking() {
        IdeProfilerServices ide = this.getStudioProfilers().getIdeServices();
        ide.getFeatureTracker().trackRecordAllocations();
        this.getStudioProfilers().setMemoryLiveAllocationEnabled(false);
        Common.Process process = this.getStudioProfilers().getProcess();
        String traceFilePath = String.format(Locale.getDefault(), "%s/%s.trace", "/data/local/tmp/perfd", process.getName());
        Commands.Command dumpCommand = Commands.Command.newBuilder().setStreamId(this.mySessionData.getStreamId()).setPid(this.mySessionData.getPid()).setType(Commands.Command.CommandType.START_NATIVE_HEAP_SAMPLE).setStartNativeSample(Memory.StartNativeSample.newBuilder().setSamplingIntervalBytes(ide.getNativeMemorySamplingRateForCurrentConfig()).setSharedMemoryBufferBytes(0x4000000).setAbiCpuArch(process.getAbiCpuArch()).setTempPath(traceFilePath).setAppName(process.getName())).build();
        return this.getStudioProfilers().getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(dumpCommand).build());
    }

    private Transport.ExecuteResponse stopNativeAllocationTracking(long startTime) {
        this.getStudioProfilers().setMemoryLiveAllocationEnabled(true);
        Commands.Command dumpCommand = Commands.Command.newBuilder().setStreamId(this.mySessionData.getStreamId()).setPid(this.mySessionData.getPid()).setType(Commands.Command.CommandType.STOP_NATIVE_HEAP_SAMPLE).setStopNativeSample(Memory.StopNativeSample.newBuilder().setStartTime(startTime)).build();
        return this.getStudioProfilers().getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(dumpCommand).build());
    }

    public void toggleNativeAllocationTracking() {
        assert (this.getStudioProfilers().getProcess() != null);
        Transport.ExecuteResponse response = !this.myNativeAllocationTracking ? this.startNativeAllocationTracking() : this.stopNativeAllocationTracking(this.getPendingCaptureStartTime());
        TransportEventListener statusListener = new TransportEventListener(Common.Event.Kind.MEMORY_NATIVE_SAMPLE_STATUS, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> this.mySessionData.getStreamId(), () -> this.mySessionData.getPid(), event -> {
            this.nativeAllocationTrackingStart(event.getMemoryNativeTrackingStatus());
            return true;
        });
        this.getStudioProfilers().getTransportPoller().registerListener(statusListener);
    }

    private void nativeAllocationTrackingStart(@NotNull Memory.MemoryNativeTrackingData status) {
        switch (status.getStatus()) {
            case SUCCESS: {
                this.myNativeAllocationTracking = true;
                this.setPendingCaptureStartTime(status.getStartTime());
                this.myTrackingAllocations = true;
                this.myPendingLegacyAllocationStartTimeNs = status.getStartTime();
                break;
            }
            case IN_PROGRESS: {
                this.myNativeAllocationTracking = true;
                this.myTrackingAllocations = true;
                MemoryProfilerStage.getLogger().debug(String.format(Locale.getDefault(), "A heap dump for %d is already in progress.", this.mySessionData.getPid()));
                break;
            }
            case FAILURE: {
                MemoryProfilerStage.getLogger().error(status.getFailureMessage());
            }
            case NOT_RECORDING: 
            case UNSPECIFIED: 
            case UNRECOGNIZED: {
                this.myNativeAllocationTracking = false;
                this.myTrackingAllocations = false;
            }
        }
        this.myAspect.changed((Enum)MemoryProfilerAspect.TRACKING_ENABLED);
    }

    public void requestHeapDump() {
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            assert (this.getStudioProfilers().getProcess() != null);
            Commands.Command dumpCommand = Commands.Command.newBuilder().setStreamId(this.mySessionData.getStreamId()).setPid(this.mySessionData.getPid()).setType(Commands.Command.CommandType.HEAP_DUMP).build();
            Transport.ExecuteResponse response = this.getStudioProfilers().getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(dumpCommand).build());
            TransportEventListener statusListener = new TransportEventListener(Common.Event.Kind.MEMORY_HEAP_DUMP_STATUS, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> this.mySessionData.getStreamId(), () -> this.mySessionData.getPid(), event -> {
                this.handleHeapDumpStart(event.getMemoryHeapdumpStatus().getStatus());
                return true;
            });
            this.getStudioProfilers().getTransportPoller().registerListener(statusListener);
        } else {
            MemoryProfiler.TriggerHeapDumpResponse response = this.myClient.triggerHeapDump(MemoryProfiler.TriggerHeapDumpRequest.newBuilder().setSession(this.mySessionData).build());
            this.handleHeapDumpStart(response.getStatus());
        }
        this.getTimeline().setStreaming(true);
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_MEMORY_CAPTURE, true);
        this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
    }

    private void handleHeapDumpStart(@NotNull Memory.HeapDumpStatus status) {
        switch (status.getStatus()) {
            case SUCCESS: {
                this.setPendingCaptureStartTime(status.getStartTime());
                this.myAspect.changed((Enum)MemoryProfilerAspect.HEAP_DUMP_STARTED);
                break;
            }
            case IN_PROGRESS: {
                MemoryProfilerStage.getLogger().debug(String.format(Locale.getDefault(), "A heap dump for %d is already in progress.", this.mySessionData.getPid()));
                break;
            }
        }
    }

    public void forceGarbageCollection() {
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.ExecuteResponse executeResponse = this.getStudioProfilers().getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(Commands.Command.newBuilder().setStreamId(this.mySessionData.getStreamId()).setPid(this.mySessionData.getPid()).setType(Commands.Command.CommandType.GC)).build());
        } else {
            MemoryProfiler.ForceGarbageCollectionResponse forceGarbageCollectionResponse = this.myClient.forceGarbageCollection(MemoryProfiler.ForceGarbageCollectionRequest.newBuilder().setSession(this.mySessionData).build());
        }
    }

    public DurationDataModel<CaptureDurationData<CaptureObject>> getHeapDumpSampleDurations() {
        return this.myHeapDumpDurations;
    }

    public void trackAllocations(boolean enable) {
        MemoryProfiler.trackAllocations(this.getStudioProfilers(), this.mySessionData, enable, status -> {
            switch (status.getStatus()) {
                case SUCCESS: {
                    this.myTrackingAllocations = enable;
                    this.setPendingCaptureStartTime(status.getStartTime());
                    this.myPendingLegacyAllocationStartTimeNs = enable ? status.getStartTime() : -1L;
                    break;
                }
                case IN_PROGRESS: {
                    this.myTrackingAllocations = true;
                    break;
                }
                case NOT_ENABLED: {
                    this.myTrackingAllocations = false;
                    break;
                }
            }
            this.myAspect.changed((Enum)MemoryProfilerAspect.TRACKING_ENABLED);
            if (this.myTrackingAllocations) {
                this.getTimeline().setStreaming(true);
                this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_MEMORY_CAPTURE, true);
                this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
            }
        });
    }

    public boolean isTrackingAllocations() {
        return this.myTrackingAllocations;
    }

    public long getAllocationTrackingElapsedTimeNs() {
        if (this.myTrackingAllocations) {
            try {
                Transport.TimeResponse timeResponse = this.getStudioProfilers().getClient().getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(this.mySessionData.getStreamId()).build());
                return timeResponse.getTimestampNs() - this.myPendingLegacyAllocationStartTimeNs;
            }
            catch (StatusRuntimeException exception) {
                MemoryProfilerStage.getLogger().warn((Throwable)exception);
            }
        }
        return -1L;
    }

    @Nullable
    public CaptureDurationData<? extends CaptureObject> getIntersectingCaptureDuration(@NotNull Range range) {
        CaptureDurationData durationData = null;
        double overlap = 0.0;
        ArrayList series = new ArrayList(this.getAllocationInfosDurations().getSeries().getSeriesForRange(range));
        series.addAll(this.getHeapDumpSampleDurations().getSeries().getSeriesForRange(range));
        series.addAll(this.getNativeAllocationInfosDurations().getSeries().getSeriesForRange(range));
        for (SeriesData data : series) {
            long duration = ((CaptureDurationData)((Object)data.value)).getDurationUs();
            if (duration == Long.MAX_VALUE && !((CaptureDurationData)((Object)data.value)).getSelectableWhenMaxDuration()) continue;
            long dataMax = duration == Long.MAX_VALUE ? duration : data.x + duration;
            double intersectionLen = range.getIntersectionLength((double)data.x, (double)dataMax);
            if (!range.intersectsWith((double)data.x, (double)dataMax) || !(intersectionLen >= overlap)) continue;
            durationData = (CaptureDurationData)((Object)data.value);
            overlap = intersectionLen;
        }
        return durationData;
    }

    @Nullable
    private Common.Device getDeviceForSelectedSession() {
        StudioProfilers profilers = this.getStudioProfilers();
        Common.Stream stream = profilers.getStream(profilers.getSession().getStreamId());
        if (stream.getType() == Common.Stream.Type.DEVICE) {
            return stream.getDevice();
        }
        return null;
    }

    public boolean isNativeAllocationSamplingEnabled() {
        Common.Device device = this.getDeviceForSelectedSession();
        return this.getStudioProfilers().getIdeServices().getFeatureConfig().isNativeMemorySampleEnabled() && device != null && device.getFeatureLevel() >= 29;
    }

    public boolean isLiveAllocationTrackingSupported() {
        Common.Device device = this.getDeviceForSelectedSession();
        return this.getStudioProfilers().getIdeServices().getFeatureConfig().isLiveAllocationsEnabled() && device != null && device.getFeatureLevel() >= 26;
    }

    public boolean isLiveAllocationTrackingReady() {
        return MemoryProfiler.isUsingLiveAllocation(this.getStudioProfilers(), this.mySessionData);
    }

    @NotNull
    public DurationDataModel<CaptureDurationData<CaptureObject>> getAllocationInfosDurations() {
        return this.myAllocationDurations;
    }

    @NotNull
    public DurationDataModel<CaptureDurationData<CaptureObject>> getNativeAllocationInfosDurations() {
        return this.myNativeAllocationDurations;
    }

    @VisibleForTesting
    public void selectCaptureDuration(@Nullable CaptureDurationData<? extends CaptureObject> durationData, @Nullable Executor joiner) {
        StudioProfilers profilers = this.getStudioProfilers();
        if (durationData != null && durationData.isHeapDumpData() && this.getStudioProfilers().getIdeServices().getFeatureConfig().isSeparateHeapDumpUiEnabled()) {
            profilers.setStage(new HeapDumpStage(profilers, this.getLoader(), durationData, joiner));
        } else {
            this.doSelectCaptureDuration(durationData, joiner);
        }
    }

    @NotNull
    DurationDataModel<AllocationSamplingRateDurationData> getAllocationSamplingRateDurations() {
        return this.myAllocationSamplingRateDurations;
    }

    @NotNull
    public List<LiveAllocationSamplingMode> getSupportedLiveAllocationSamplingMode() {
        return Arrays.asList(LiveAllocationSamplingMode.values());
    }

    @NotNull
    public LiveAllocationSamplingMode getLiveAllocationSamplingMode() {
        return this.myLiveAllocationSamplingMode;
    }

    public void requestLiveAllocationSamplingModeUpdate(@NotNull LiveAllocationSamplingMode mode) {
        this.getStudioProfilers().getIdeServices().getPersistentProfilerPreferences().setInt(LIVE_ALLOCATION_SAMPLING_PREF, mode.getValue(), DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE.getValue());
        try {
            Memory.MemoryAllocSamplingData samplingRate = Memory.MemoryAllocSamplingData.newBuilder().setSamplingNumInterval(mode.getValue()).build();
            if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
                Transport.ExecuteResponse executeResponse = this.getStudioProfilers().getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(Commands.Command.newBuilder().setStreamId(this.mySessionData.getStreamId()).setPid(this.mySessionData.getPid()).setType(Commands.Command.CommandType.MEMORY_ALLOC_SAMPLING).setMemoryAllocSampling(samplingRate)).build());
            } else {
                MemoryProfiler.SetAllocationSamplingRateResponse setAllocationSamplingRateResponse = this.getStudioProfilers().getClient().getMemoryClient().setAllocationSamplingRate(MemoryProfiler.SetAllocationSamplingRateRequest.newBuilder().setSession(this.mySessionData).setSamplingRate(samplingRate).build());
            }
        }
        catch (StatusRuntimeException e) {
            MemoryProfilerStage.getLogger().debug((Throwable)e);
        }
    }

    private void setLiveAllocationSamplingModelInternal(@NotNull LiveAllocationSamplingMode mode) {
        if (mode == this.myLiveAllocationSamplingMode) {
            return;
        }
        this.myLiveAllocationSamplingMode = mode;
        this.myAspect.changed((Enum)MemoryProfilerAspect.LIVE_ALLOCATION_SAMPLING_MODE);
    }

    private void updateAllocationTrackingStatus() {
        List<Memory.AllocationsInfo> allocationsInfos = MemoryProfiler.getAllocationInfosForSession(this.getStudioProfilers().getClient(), this.mySessionData, new Range(-9.223372036854776E18, 9.223372036854776E18), this.getStudioProfilers().getIdeServices());
        Memory.AllocationsInfo lastInfo = allocationsInfos.isEmpty() ? null : allocationsInfos.get(allocationsInfos.size() - 1);
        boolean bl = this.myTrackingAllocations = lastInfo != null && lastInfo.getLegacy() && lastInfo.getEndTime() == Long.MAX_VALUE;
        if (this.myTrackingAllocations) {
            this.setPendingCaptureStartTime(lastInfo.getStartTime());
            this.myPendingLegacyAllocationStartTimeNs = lastInfo.getStartTime();
        } else {
            this.setPendingCaptureStartTime(-1L);
            this.myPendingLegacyAllocationStartTimeNs = -1L;
        }
    }

    private void updateNativeAllocationTrackingStatus() {
        List<Memory.MemoryNativeTrackingData> samples = MemoryProfiler.getNativeHeapStatusForSession(this.getStudioProfilers().getClient(), this.mySessionData, new Range(-9.223372036854776E18, 9.223372036854776E18));
        if (samples.isEmpty()) {
            return;
        }
        Memory.MemoryNativeTrackingData last = samples.get(samples.size() - 1);
        if (last.getStatus() == Memory.MemoryNativeTrackingData.Status.SUCCESS) {
            this.nativeAllocationTrackingStart(last);
        }
    }

    public AxisComponentModel getMemoryAxis() {
        return this.myMemoryAxis;
    }

    public AxisComponentModel getObjectsAxis() {
        return this.myObjectsAxis;
    }

    public MemoryStageLegends getLegends() {
        return this.myLegends;
    }

    public MemoryStageLegends getTooltipLegends() {
        return this.myTooltipLegends;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        return this.myInstructionsEaseOutModel;
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @NotNull
    public DurationDataModel<GcDurationData> getGcStatsModel() {
        return this.myGcStatsModel;
    }

    public String getName() {
        return "MEMORY";
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    public static boolean canSafelyLoadHprof(long fileSize) {
        System.gc();
        long leeway = 314572800L;
        long requestableMemory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
        return requestableMemory >= (long)MEMORY_HPROF_SAFE_FACTOR * fileSize + leeway;
    }

    public static enum LiveAllocationSamplingMode {
        NONE(0, "None"),
        SAMPLED(10, "Sampled"),
        FULL(1, "Full");

        static final Map<Integer, LiveAllocationSamplingMode> SAMPLING_RATE_MAP;
        static final Map<String, LiveAllocationSamplingMode> NAME_MAP;
        private String myDisplayName;
        private int mySamplingFrequency;

        private LiveAllocationSamplingMode(int frequency, String displayName) {
            this.myDisplayName = displayName;
            this.mySamplingFrequency = frequency;
        }

        public String getDisplayName() {
            return this.myDisplayName;
        }

        public int getValue() {
            return this.mySamplingFrequency;
        }

        @NotNull
        static LiveAllocationSamplingMode getModeFromFrequency(int frequency) {
            return SAMPLING_RATE_MAP.getOrDefault(frequency, DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE);
        }

        @NotNull
        static LiveAllocationSamplingMode getModeFromDisplayName(String displayName) {
            return NAME_MAP.getOrDefault(displayName, DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE);
        }

        static {
            HashMap<Integer, LiveAllocationSamplingMode> samplingRateMap = new HashMap<Integer, LiveAllocationSamplingMode>();
            HashMap<String, LiveAllocationSamplingMode> nameMap = new HashMap<String, LiveAllocationSamplingMode>();
            for (LiveAllocationSamplingMode mode : LiveAllocationSamplingMode.values()) {
                samplingRateMap.put(mode.getValue(), mode);
                nameMap.put(mode.getDisplayName(), mode);
            }
            SAMPLING_RATE_MAP = ImmutableMap.copyOf(samplingRateMap);
            NAME_MAP = ImmutableMap.copyOf(nameMap);
        }
    }

    private class AllocationSamplingRateUpdatable
    implements Updatable {
        private AllocationSamplingRateUpdatable() {
        }

        public void update(long elapsedNs) {
            if (!MemoryProfilerStage.this.isLiveAllocationTrackingReady()) {
                return;
            }
            double dataRangeMaxUs = MemoryProfilerStage.this.getTimeline().getDataRange().getMax();
            List<SeriesData<AllocationSamplingRateDurationData>> data = MemoryProfilerStage.this.myAllocationSamplingRateDataSeries.getDataForRange(new Range(dataRangeMaxUs, dataRangeMaxUs));
            if (data.isEmpty()) {
                return;
            }
            Memory.MemoryAllocSamplingData samplingInfo = ((AllocationSamplingRateDurationData)data.get((int)(data.size() - 1)).value).getCurrentRate();
            LiveAllocationSamplingMode mode = LiveAllocationSamplingMode.getModeFromFrequency(samplingInfo.getSamplingNumInterval());
            MemoryProfilerStage.this.setLiveAllocationSamplingModelInternal(mode);
        }
    }

    private class CaptureElapsedTimeUpdatable
    implements Updatable {
        private CaptureElapsedTimeUpdatable() {
        }

        public void update(long elapsedNs) {
            if (MemoryProfilerStage.this.myTrackingAllocations) {
                MemoryProfilerStage.this.getCaptureSelection().getAspect().changed((Enum)CaptureSelectionAspect.CURRENT_CAPTURE_ELAPSED_TIME);
            }
        }
    }
}

