/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class MemoryInstanceFilterView
extends AspectModel<MemoryProfilerAspect> {
    @NotNull
    private final MemoryCaptureSelection mySelection;
    @NotNull
    private JPanel myFilterToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
    @NotNull
    private JPanel myFilterDescriptionPanel = new JPanel((LayoutManager)new TabularLayout("Fit,*"));

    MemoryInstanceFilterView(@NotNull MemoryCaptureSelection selection2) {
        this.mySelection = selection2;
        this.myFilterDescriptionPanel.setBorder(JBUI.Borders.merge((Border)ProfilerLayout.TOOLBAR_LABEL_BORDER, (Border)AdtUiUtils.DEFAULT_TOP_BORDER, (boolean)true));
        this.myFilterDescriptionPanel.setBackground(ProfilerColors.WARNING_BAR_COLOR);
        this.myFilterDescriptionPanel.setVisible(false);
        this.mySelection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, this::updateFilters);
    }

    @NotNull
    JComponent getFilterToolbar() {
        return this.myFilterToolbar;
    }

    JComponent getFilterDescription() {
        return this.myFilterDescriptionPanel;
    }

    private void updateFilters() {
        this.myFilterToolbar.removeAll();
        CaptureObject captureObject = this.mySelection.getSelectedCapture();
        if (captureObject == null) {
            return;
        }
        for (CaptureObjectInstanceFilter supportedFilter : captureObject.getSupportedInstanceFilters()) {
            JBCheckBox filterCheckBox = new JBCheckBox(supportedFilter.getDisplayName());
            filterCheckBox.setBorder((Border)new JBEmptyBorder(0, 4, 0, 4));
            filterCheckBox.setToolTipText(supportedFilter.getSummaryDescription());
            filterCheckBox.addActionListener(l -> {
                if (filterCheckBox.isSelected()) {
                    this.mySelection.addInstanceFilter(supportedFilter, SwingUtilities::invokeLater);
                    this.mySelection.getIdeServices().getFeatureTracker().trackMemoryProfilerInstanceFilter(supportedFilter);
                } else {
                    this.mySelection.removeInstanceFilter(supportedFilter, SwingUtilities::invokeLater);
                }
                boolean hasFilterDescription = false;
                this.myFilterDescriptionPanel.removeAll();
                Set<CaptureObjectInstanceFilter> selectedFilters = captureObject.getSelectedInstanceFilters();
                int i2 = 0;
                for (CaptureObjectInstanceFilter filter : selectedFilters) {
                    String description = filter.getDetailedDescription();
                    if (description == null) continue;
                    HyperlinkLabel label = new HyperlinkLabel();
                    String docLink = filter.getDocumentationLink();
                    if (docLink != null) {
                        label.setHyperlinkText(description + " Please see the ", "documentation", " for details.");
                        label.setHyperlinkTarget(docLink);
                    } else {
                        label.setHyperlinkText(description, "", "");
                    }
                    this.myFilterDescriptionPanel.add((Component)label, new TabularLayout.Constraint(i2++, 0));
                    hasFilterDescription = true;
                }
                this.myFilterDescriptionPanel.setVisible(hasFilterDescription);
            });
            this.myFilterToolbar.add((Component)filterCheckBox);
        }
    }
}

