/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.event.LifecycleAction;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class LifecycleTooltipView
extends TooltipView {
    private static final int HOVER_OVER_WIDTH_PX = 6;
    @NotNull
    private final LifecycleTooltip myLifecycleTooltip;
    @NotNull
    private JLabel myActivityNameLabel;
    @NotNull
    private JLabel myDurationLabel;
    @NotNull
    private JPanel myFragmentsPanel;
    @NotNull
    private JComponent myComponent;

    public LifecycleTooltipView(@NotNull JComponent parent, @NotNull LifecycleTooltip tooltip2) {
        super(tooltip2.getTimeline());
        this.myLifecycleTooltip = tooltip2;
        this.myComponent = parent;
        this.getTimeline().getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::timeChanged);
        this.myActivityNameLabel = new JLabel();
        this.myDurationLabel = new JLabel();
        this.myFragmentsPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
    }

    public void dispose() {
        super.dispose();
        this.getTimeline().getDataRange().removeDependencies((AspectObserver)this);
    }

    protected void updateTooltip() {
        this.timeChanged();
    }

    private void timeChanged() {
        Range dataRange = this.getTimeline().getDataRange();
        Range range = this.getTimeline().getTooltipRange();
        if (!range.isEmpty()) {
            this.showStackedEventInfo(this.getTimeline(), dataRange, range.getMin());
        }
    }

    private void showStackedEventInfo(Timeline timeline, Range dataRange, double tooltipX) {
        LifecycleAction activity = this.myLifecycleTooltip.getActivityAt(tooltipX);
        if (activity != null) {
            double endTime = activity.getEndUs() == 0L ? dataRange.getMax() : (double)activity.getEndUs();
            this.setTimelineText(timeline.getDataRange(), activity.getStartUs(), endTime);
            this.myActivityNameLabel.setText(activity.getName());
        } else {
            this.myDurationLabel.setText("");
            this.myActivityNameLabel.setText("");
        }
        this.myFragmentsPanel.removeAll();
        double timePerPixel = this.getTimeline().getViewRange().getLength() / (double)this.myComponent.getWidth();
        Range hoverRange = new Range(tooltipX - timePerPixel * 6.0 / 2.0, tooltipX + timePerPixel * 6.0 / 2.0);
        List<LifecycleAction> fragments = this.myLifecycleTooltip.getFragmentsAt(hoverRange);
        ArrayList labels = new ArrayList();
        fragments.forEach(fragment -> {
            boolean justRemoved;
            String text = fragment.getName();
            boolean justAdded = (double)fragment.getStartUs() > hoverRange.getMin() && (double)fragment.getStartUs() <= hoverRange.getMax();
            boolean bl = justRemoved = fragment.getEndUs() != 0L && (double)fragment.getEndUs() > hoverRange.getMin() && (double)fragment.getEndUs() <= hoverRange.getMax();
            if (justAdded) {
                text = text + " - resumed";
            } else if (justRemoved) {
                text = text + " - paused";
            }
            labels.add(new JLabel(text));
        });
        labels.sort((o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText()));
        labels.forEach(label -> this.myFragmentsPanel.add((Component)label));
    }

    private void setTimelineText(Range dataRange, double startTime, double endTime) {
        String startTimeString = TimeFormatter.getSemiSimplifiedClockString((long)((long)(startTime - dataRange.getMin())));
        String endTimeString = TimeFormatter.getSemiSimplifiedClockString((long)((long)(endTime - dataRange.getMin())));
        this.myDurationLabel.setText(String.format("%s - %s", startTimeString, endTimeString));
    }

    @NotNull
    public JLabel getActivityNameLabel() {
        return this.myActivityNameLabel;
    }

    @NotNull
    public JLabel getDurationLabel() {
        return this.myDurationLabel;
    }

    @NotNull
    public JPanel getFragmentsPanel() {
        return this.myFragmentsPanel;
    }

    @NotNull
    public JComponent createTooltip() {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
        panel2.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        panel2.add(this.myActivityNameLabel);
        this.myDurationLabel.setForeground(Color.GRAY);
        this.myDurationLabel.setFont(this.myFont);
        panel2.add(this.myDurationLabel);
        this.myFragmentsPanel.setBorder((Border)new JBEmptyBorder(8, 0, 0, 0));
        panel2.add(this.myFragmentsPanel);
        return panel2;
    }
}

