/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.ProfilerClient;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class LegacyEnergyEventsDataSeries
implements DataSeries<Common.Event> {
    @NotNull
    private final ProfilerClient myClient;
    @NotNull
    private final Common.Session mySession;

    public LegacyEnergyEventsDataSeries(@NotNull ProfilerClient client, @NotNull Common.Session session) {
        this.myClient = client;
        this.mySession = session;
    }

    public List<SeriesData<Common.Event>> getDataForRange(Range range) {
        EnergyProfiler.EnergyRequest.Builder builder = EnergyProfiler.EnergyRequest.newBuilder().setSession(this.mySession);
        builder.setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)range.getMin()));
        builder.setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)range.getMax()));
        EnergyProfiler.EnergyEventsResponse response = this.myClient.getEnergyClient().getEvents(builder.build());
        return ContainerUtil.map((Collection)response.getEventsList(), evt -> new SeriesData(TimeUnit.NANOSECONDS.toMicros(evt.getTimestamp()), evt));
    }
}

